/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.analytics;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.msg.analytics.AnalyticsChunkHeader;
import com.couchbase.client.core.msg.analytics.AnalyticsChunkRow;
import com.couchbase.client.core.msg.analytics.AnalyticsChunkTrailer;
import com.couchbase.client.java.analytics.AnalyticsMetaData;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.codec.TypeRef;
import com.couchbase.client.java.json.JsonObject;
import java.util.ArrayList;
import java.util.List;

@Stability.Volatile
public class AnalyticsResult {
    private final List<AnalyticsChunkRow> rows;
    private final AnalyticsChunkHeader header;
    private final AnalyticsChunkTrailer trailer;
    private final JsonSerializer serializer;

    AnalyticsResult(AnalyticsChunkHeader header, List<AnalyticsChunkRow> rows, AnalyticsChunkTrailer trailer, JsonSerializer serializer) {
        this.rows = rows;
        this.header = header;
        this.trailer = trailer;
        this.serializer = serializer;
    }

    public <T> List<T> rowsAs(Class<T> target) {
        ArrayList<T> converted = new ArrayList<T>(this.rows.size());
        for (AnalyticsChunkRow row : this.rows) {
            converted.add(this.serializer.deserialize(target, row.data()));
        }
        return converted;
    }

    public <T> List<T> rowsAs(TypeRef<T> target) {
        ArrayList<T> converted = new ArrayList<T>(this.rows.size());
        for (AnalyticsChunkRow row : this.rows) {
            converted.add(this.serializer.deserialize(target, row.data()));
        }
        return converted;
    }

    public List<JsonObject> rowsAsObject() {
        return this.rowsAs(JsonObject.class);
    }

    public AnalyticsMetaData metaData() {
        return AnalyticsMetaData.from(this.header, this.trailer);
    }

    public String toString() {
        return "AnalyticsResult{rows=" + this.rows + ", header=" + this.header + ", trailer=" + this.trailer + ", serializer=" + this.serializer + '}';
    }
}

