/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.query;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.Reactor;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.InternalSpan;
import com.couchbase.client.core.config.ClusterCapabilities;
import com.couchbase.client.core.config.ClusterConfig;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.query.QueryChunkRow;
import com.couchbase.client.core.msg.query.QueryChunkTrailer;
import com.couchbase.client.core.msg.query.QueryRequest;
import com.couchbase.client.core.msg.query.QueryResponse;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.util.Golang;
import com.couchbase.client.core.util.LRUCache;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.query.QueryOptions;
import com.couchbase.client.java.query.QueryResult;
import com.couchbase.client.java.query.ReactiveQueryResult;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import reactor.core.publisher.Mono;

@Stability.Internal
public class QueryAccessor {
    private static final int QUERY_CACHE_SIZE = 5000;
    private final Map<String, QueryCacheEntry> queryCache = Collections.synchronizedMap(new LRUCache(5000));
    private final Core core;
    private volatile boolean enhancedPreparedEnabled = false;

    public QueryAccessor(Core core) {
        this.core = core;
        this.updateEnhancedPreparedEnabled(core.clusterConfig());
        core.configurationProvider().configs().subscribe(this::updateEnhancedPreparedEnabled);
    }

    private void updateEnhancedPreparedEnabled(ClusterConfig config) {
        if (this.enhancedPreparedEnabled) {
            return;
        }
        Set caps = (Set)config.clusterCapabilities().get(ServiceType.QUERY);
        this.enhancedPreparedEnabled = caps != null && caps.contains(ClusterCapabilities.ENHANCED_PREPARED_STATEMENTS);
    }

    public CompletableFuture<QueryResult> queryAsync(QueryRequest request, QueryOptions.Built options, JsonSerializer serializer) {
        return this.queryInternal(request, options, options.adhoc(), serializer).flatMap(response -> response.rows().collectList().flatMap(rows -> response.trailer().map(trailer -> new QueryResult(response.header(), (List<QueryChunkRow>)rows, (QueryChunkTrailer)trailer, serializer)))).toFuture();
    }

    public Mono<ReactiveQueryResult> queryReactive(QueryRequest request, QueryOptions.Built options, JsonSerializer serializer) {
        return this.queryInternal(request, options, options.adhoc(), serializer).map(r -> new ReactiveQueryResult((QueryResponse)r, serializer));
    }

    private Mono<QueryResponse> queryInternal(QueryRequest request, QueryOptions.Built options, boolean adhoc, JsonSerializer serializer) {
        if (adhoc) {
            this.core.send((Request)request);
            return Reactor.wrap((Request)request, (CompletableFuture)request.response(), (boolean)true).doFinally(signalType -> request.context().logicallyComplete());
        }
        return this.maybePrepareAndExecute(request, options, serializer).doFinally(signalType -> request.context().logicallyComplete());
    }

    private Mono<QueryResponse> maybePrepareAndExecute(QueryRequest request, QueryOptions.Built options, JsonSerializer serializer) {
        QueryCacheEntry cacheEntry = this.queryCache.get(request.statement());
        boolean enhancedEnabled = this.enhancedPreparedEnabled;
        if (cacheEntry != null && this.cacheEntryStillValid(cacheEntry, enhancedEnabled)) {
            return this.queryInternal(this.buildExecuteRequest(cacheEntry, request, options), options, true, serializer);
        }
        if (enhancedEnabled) {
            return this.queryInternal(this.buildPrepareRequest(request, options), options, true, serializer).flatMap(qr -> {
                Optional preparedName = qr.header().prepared();
                if (!preparedName.isPresent()) {
                    return Mono.error((Throwable)new CouchbaseException("No prepared name present but must be, this is a query bug!"));
                }
                this.queryCache.put(request.statement(), new QueryCacheEntry(false, null, (String)preparedName.get()));
                return Mono.just((Object)qr);
            });
        }
        return this.queryReactive(this.buildPrepareRequest(request, options), QueryOptions.queryOptions().build(), serializer).flatMap(result -> result.rowsAsObject().next()).map(row -> {
            this.queryCache.put(request.statement(), new QueryCacheEntry(true, row.getString("encoded_plan"), row.getString("name")));
            return row;
        }).then(Mono.defer(() -> this.maybePrepareAndExecute(request, options, serializer)));
    }

    private QueryRequest buildPrepareRequest(QueryRequest original, QueryOptions.Built options) {
        String statement = "PREPARE " + original.statement();
        JsonObject query = JsonObject.create();
        query.put("statement", statement);
        query.put("timeout", Golang.encodeDurationToMs((Duration)original.timeout()));
        query.put("client_context_id", options.clientContextId() != null ? options.clientContextId() : UUID.randomUUID().toString());
        if (this.enhancedPreparedEnabled) {
            query.put("auto_execute", true);
            options.injectParams(query);
        }
        InternalSpan span = this.core.context().environment().requestTracer().internalSpan("prepare", original.internalSpan().toRequestSpan());
        return new QueryRequest(original.timeout(), (CoreContext)original.context(), original.retryStrategy(), original.credentials(), statement, query.toString().getBytes(StandardCharsets.UTF_8), true, query.getString("client_context_id"), span);
    }

    private QueryRequest buildExecuteRequest(QueryCacheEntry cacheEntry, QueryRequest original, QueryOptions.Built originalOptions) {
        JsonObject query = cacheEntry.export();
        query.put("timeout", Golang.encodeDurationToMs((Duration)original.timeout()));
        originalOptions.injectParams(query);
        InternalSpan span = this.core.context().environment().requestTracer().internalSpan("execute", original.internalSpan().toRequestSpan());
        return new QueryRequest(original.timeout(), (CoreContext)original.context(), original.retryStrategy(), original.credentials(), original.statement(), query.toString().getBytes(StandardCharsets.UTF_8), originalOptions.readonly(), query.getString("client_context_id"), span);
    }

    private boolean cacheEntryStillValid(QueryCacheEntry entry, boolean enhancedEnabled) {
        return enhancedEnabled && !entry.fullPlan || !enhancedEnabled && entry.fullPlan;
    }

    private static class QueryCacheEntry {
        private final String name;
        private final boolean fullPlan;
        private final String value;

        QueryCacheEntry(boolean fullPlan, String value, String name) {
            this.fullPlan = fullPlan;
            this.value = value;
            this.name = name;
        }

        JsonObject export() {
            JsonObject result = JsonObject.create();
            result.put("prepared", this.name);
            if (this.fullPlan) {
                result.put("encoded_plan", this.value);
            }
            return result;
        }
    }
}

