/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.util.retry;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.lang.Tuple2;
import com.couchbase.client.core.time.Delay;
import com.couchbase.client.java.error.CannotRetryException;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Scheduler;
import rx.functions.Action4;
import rx.functions.Func1;

@InterfaceStability.Committed
@InterfaceAudience.Public
public class RetryWithDelayHandler
implements Func1<Tuple2<Integer, Throwable>, Observable<?>> {
    protected final int maxAttempts;
    protected final Delay retryDelay;
    protected final Func1<Throwable, Boolean> errorInterruptingPredicate;
    protected final Scheduler optionalScheduler;
    protected final Action4<Integer, Throwable, Long, TimeUnit> doOnRetry;

    public RetryWithDelayHandler(int maxAttempts, Delay retryDelay) {
        this(maxAttempts, retryDelay, null, null);
    }

    public RetryWithDelayHandler(int maxAttempts, Delay retryDelay, Func1<Throwable, Boolean> errorInterruptingPredicate, Action4<Integer, Throwable, Long, TimeUnit> doOnRetry) {
        this(maxAttempts, retryDelay, errorInterruptingPredicate, doOnRetry, null);
    }

    protected RetryWithDelayHandler(int maxAttempts, Delay retryDelay, Func1<Throwable, Boolean> errorInterruptingPredicate, Action4<Integer, Throwable, Long, TimeUnit> doOnRetry, Scheduler scheduler) {
        this.maxAttempts = Math.min(0x7FFFFFFE, maxAttempts);
        this.retryDelay = retryDelay;
        this.errorInterruptingPredicate = errorInterruptingPredicate;
        this.optionalScheduler = scheduler;
        this.doOnRetry = doOnRetry;
    }

    protected static String messageForMaxAttempts(long reachedAfterNRetries) {
        return "maximum number of attempts reached after " + reachedAfterNRetries + " retries";
    }

    public Observable<?> call(Tuple2<Integer, Throwable> attemptError) {
        int errorNumber = attemptError.value1();
        Throwable error = attemptError.value2();
        if (this.errorInterruptingPredicate != null && Boolean.TRUE.equals(this.errorInterruptingPredicate.call((Object)error))) {
            return Observable.error((Throwable)error);
        }
        if (errorNumber > this.maxAttempts) {
            return Observable.error((Throwable)new CannotRetryException(RetryWithDelayHandler.messageForMaxAttempts(errorNumber - 1), error));
        }
        long delay = this.retryDelay.calculate(errorNumber);
        TimeUnit unit = this.retryDelay.unit();
        if (this.doOnRetry != null) {
            this.doOnRetry.call((Object)errorNumber, (Object)error, (Object)delay, (Object)unit);
        }
        if (this.optionalScheduler != null) {
            return Observable.timer((long)delay, (TimeUnit)unit, (Scheduler)this.optionalScheduler);
        }
        return Observable.timer((long)delay, (TimeUnit)unit);
    }
}

