/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.util;

import com.couchbase.client.core.BackpressureException;
import com.couchbase.client.core.CouchbaseException;
import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.time.Delay;
import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.analytics.AnalyticsQuery;
import com.couchbase.client.java.analytics.AsyncAnalyticsQueryResult;
import com.couchbase.client.java.analytics.AsyncAnalyticsQueryRow;
import com.couchbase.client.java.document.JsonDocument;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.error.TemporaryFailureException;
import com.couchbase.client.java.util.retry.RetryBuilder;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@InterfaceAudience.Public
@InterfaceStability.Experimental
public enum AnalyticsIngester {

    private static final Func1<JsonObject, String> DEFAULT_ID_GENERATOR = new Func1<JsonObject, String>(){

        public String call(JsonObject jsonObject) {
            return UUID.randomUUID().toString();
        }
    };

    public static Completable ingest(Bucket bucket, AnalyticsQuery query) {
        return AnalyticsIngester.ingest(bucket, query, null);
    }

    public static Completable ingest(final Bucket bucket, AnalyticsQuery query, IngestOptions options) {
        IngestOptions opts;
        IngestOptions ingestOptions = opts = options == null ? IngestOptions.ingestOptions() : options;
        if (opts.ingestMethod == IngestMethod.REPLACE && opts.idGenerator.equals(DEFAULT_ID_GENERATOR)) {
            throw new IllegalArgumentException("IngestMethod.REPLACE does not work with the default ID generator which only creates new UUIDs and will make every replace operation fail. Please create your own ID Generator!");
        }
        final long kvTimeout = opts.kvTimeout > 0L ? opts.kvTimeout : bucket.environment().kvTimeout();
        long anTimeout = opts.analyticsTimeout > 0L ? opts.analyticsTimeout : bucket.environment().analyticsTimeout();
        return bucket.async().query(query).timeout(anTimeout, TimeUnit.MILLISECONDS).flatMap((Func1)new Func1<AsyncAnalyticsQueryResult, Observable<JsonDocument>>(){

            public Observable<JsonDocument> call(AsyncAnalyticsQueryResult result) {
                Observable errors = result.errors().map((Func1)new Func1<JsonObject, RowWithError>(){

                    public RowWithError call(JsonObject error) {
                        return new RowWithError(null, error);
                    }
                });
                Observable rows = result.rows().map((Func1)new Func1<AsyncAnalyticsQueryRow, RowWithError>(){

                    public RowWithError call(AsyncAnalyticsQueryRow row) {
                        return new RowWithError(row, null);
                    }
                });
                return Observable.merge((Observable)rows, (Observable)errors).map((Func1)new Func1<RowWithError, RowWithError>(){

                    public RowWithError call(RowWithError rwe) {
                        if (rwe.error != null) {
                            throw new CouchbaseException(rwe.error.toString());
                        }
                        return rwe;
                    }
                }).flatMap((Func1)new Func1<RowWithError, Observable<JsonDocument>>(){

                    public Observable<JsonDocument> call(RowWithError rwe) {
                        Observable result;
                        JsonObject data = (JsonObject)opts.dataConverter.call((Object)rwe.row.value());
                        String id = (String)opts.idGenerator.call((Object)data);
                        JsonDocument doc = JsonDocument.create(id, data);
                        switch (opts.ingestMethod) {
                            case INSERT: {
                                result = bucket.async().insert(doc);
                                break;
                            }
                            case UPSERT: {
                                result = bucket.async().upsert(doc);
                                break;
                            }
                            case REPLACE: {
                                result = bucket.async().replace(doc);
                                break;
                            }
                            default: {
                                return Observable.error((Throwable)new UnsupportedOperationException("Unsupported ingest method"));
                            }
                        }
                        result = result.timeout(kvTimeout, TimeUnit.MILLISECONDS);
                        if (opts.retryBuilder != null) {
                            result = result.retryWhen((Func1)opts.retryBuilder.build());
                        }
                        if (opts.ignoreIngestError) {
                            result = result.onErrorResumeNext(Observable.empty());
                        }
                        return result;
                    }
                });
            }
        }).last().toCompletable();
    }

    static /* synthetic */ Func1 access$200() {
        return DEFAULT_ID_GENERATOR;
    }

    private static class RowWithError {
        private final AsyncAnalyticsQueryRow row;
        private final JsonObject error;

        RowWithError(AsyncAnalyticsQueryRow row, JsonObject error) {
            this.row = row;
            this.error = error;
        }
    }

    public static enum IngestMethod {
        INSERT,
        UPSERT,
        REPLACE;

    }

    public static class IngestOptions {
        long analyticsTimeout = 0L;
        long kvTimeout = 0L;
        IngestMethod ingestMethod = IngestMethod.UPSERT;
        boolean ignoreIngestError = false;
        Func1<JsonObject, JsonObject> dataConverter = new Func1<JsonObject, JsonObject>(){

            public JsonObject call(JsonObject in) {
                return in;
            }
        };
        Func1<JsonObject, String> idGenerator = AnalyticsIngester.access$200();
        RetryBuilder retryBuilder = RetryBuilder.anyOf(BackpressureException.class, TemporaryFailureException.class).max(10).delay(Delay.exponential(TimeUnit.MILLISECONDS, 500L, 2L));

        private IngestOptions() {
        }

        public static IngestOptions ingestOptions() {
            return new IngestOptions();
        }

        public IngestOptions analyticsTimeout(long timeout, TimeUnit timeUnit) {
            this.analyticsTimeout = timeUnit.toMillis(timeout);
            return this;
        }

        public IngestOptions kvTimeout(long timeout, TimeUnit timeUnit) {
            this.kvTimeout = timeUnit.toMillis(timeout);
            return this;
        }

        public IngestOptions ingestMethod(IngestMethod ingestMethod) {
            this.ingestMethod = ingestMethod;
            return this;
        }

        public IngestOptions ignoreIngestError(boolean ignoreIngestError) {
            this.ignoreIngestError = ignoreIngestError;
            return this;
        }

        public IngestOptions retryBuilder(RetryBuilder retryBuilder) {
            this.retryBuilder = retryBuilder;
            return this;
        }

        public IngestOptions idGenerator(Func1<JsonObject, String> idGenerator) {
            this.idGenerator = idGenerator;
            return this;
        }

        public IngestOptions dataConverter(Func1<JsonObject, JsonObject> dataConverter) {
            this.dataConverter = dataConverter;
            return this;
        }
    }
}

