/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.subdoc;

import com.couchbase.client.core.CouchbaseException;
import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.message.ResponseStatus;

@InterfaceStability.Uncommitted
@InterfaceAudience.Private
public class SubdocOperationResult<OPERATION> {
    private final String path;
    private final OPERATION operation;
    private final ResponseStatus status;
    private final Object value;
    private final byte[] rawValue;

    private SubdocOperationResult(String path, OPERATION operation, ResponseStatus status, Object value, byte[] rawValue) {
        this.path = path;
        this.operation = operation;
        this.status = status;
        this.value = value;
        this.rawValue = rawValue;
    }

    private SubdocOperationResult(String path, OPERATION operation, ResponseStatus status, Object value) {
        this(path, operation, status, value, null);
    }

    public static <OPERATION> SubdocOperationResult<OPERATION> createFatal(String path, OPERATION operation, RuntimeException fatal) {
        return new SubdocOperationResult<OPERATION>(path, operation, ResponseStatus.FAILURE, fatal);
    }

    public static <OPERATION> SubdocOperationResult<OPERATION> createResult(String path, OPERATION operation, ResponseStatus status, Object value) {
        return new SubdocOperationResult<OPERATION>(path, operation, status, value, null);
    }

    public static <OPERATION> SubdocOperationResult<OPERATION> createResult(String path, OPERATION operation, ResponseStatus status, Object value, byte[] rawValue) {
        return new SubdocOperationResult<OPERATION>(path, operation, status, value, rawValue);
    }

    public static <OPERATION> SubdocOperationResult<OPERATION> createError(String path, OPERATION operation, ResponseStatus status, CouchbaseException exception) {
        return new SubdocOperationResult<OPERATION>(path, operation, status, exception);
    }

    public String path() {
        return this.path;
    }

    public OPERATION operation() {
        return this.operation;
    }

    public ResponseStatus status() {
        return this.status;
    }

    public boolean exists() {
        return this.status.isSuccess();
    }

    public Object value() {
        return this.value;
    }

    public byte[] rawValue() {
        return this.rawValue;
    }

    public boolean isFatal() {
        return this.status == ResponseStatus.FAILURE;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.operation).append('(').append(this.path).append("){");
        if (this.status.isSuccess() || !(this.value instanceof Exception)) {
            sb.append("value=").append(this.value);
            if (this.rawValue != null) {
                sb.append(", includesRaw");
            }
        } else if (this.status == ResponseStatus.FAILURE) {
            sb.append("fatal=").append(this.value);
        } else {
            sb.append("error=").append((Object)this.status);
        }
        return sb.append('}').toString();
    }
}

