/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.bucket.api;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.core.CouchbaseException;
import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.message.kv.GetRequest;
import com.couchbase.client.core.message.kv.GetResponse;
import com.couchbase.client.core.tracing.ThresholdLogSpan;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.java.bucket.api.Utils;
import com.couchbase.client.java.document.Document;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.error.CouchbaseOutOfMemoryException;
import com.couchbase.client.java.error.TemporaryFailureException;
import com.couchbase.client.java.error.TemporaryLockFailureException;
import com.couchbase.client.java.transcoder.Transcoder;
import com.couchbase.client.java.util.OnSubscribeDeferAndWatch;
import io.opentracing.Scope;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Func0;
import rx.functions.Func1;

@InterfaceAudience.Private
@InterfaceStability.Uncommitted
public class Get {
    public static <D extends Document<?>> Observable<D> get(final String id, final Class<D> target, final CouchbaseEnvironment environment, final String bucket, final ClusterFacade core, final Map<Class<? extends Document>, Transcoder<? extends Document, ?>> transcoders, final long timeout, final TimeUnit timeUnit) {
        return Observable.defer((Func0)new Func0<Observable<D>>(){

            public Observable<D> call() {
                final GetRequest request = new GetRequest(id, bucket);
                Utils.addRequestSpan(environment, request, "get");
                return Utils.applyTimeout(OnSubscribeDeferAndWatch.deferAndWatch(new Func1<Subscriber, Observable<GetResponse>>(){

                    public Observable<GetResponse> call(Subscriber s) {
                        request.subscriber(s);
                        return core.send(request);
                    }
                }).filter((Func1)new GetFilter(environment)).map(new GetMap(environment, transcoders, target, id)), request, environment, timeout, timeUnit);
            }
        });
    }

    public static <D extends Document<?>> Observable<D> getAndLock(final String id, final Class<D> target, final CouchbaseEnvironment environment, final String bucket, final ClusterFacade core, final Map<Class<? extends Document>, Transcoder<? extends Document, ?>> transcoders, final int lockTime, final long timeout, final TimeUnit timeUnit) {
        return Observable.defer((Func0)new Func0<Observable<D>>(){

            public Observable<D> call() {
                final GetRequest request = new GetRequest(id, bucket, true, false, lockTime);
                Utils.addRequestSpan(environment, request, "get_and_lock");
                return Utils.applyTimeout(OnSubscribeDeferAndWatch.deferAndWatch(new Func1<Subscriber, Observable<GetResponse>>(){

                    public Observable<GetResponse> call(Subscriber s) {
                        request.subscriber(s);
                        return core.send(request);
                    }
                }).filter((Func1)new GetAndLockFilter(environment)).map(new GetMap(environment, transcoders, target, id)), request, environment, timeout, timeUnit);
            }
        });
    }

    public static <D extends Document<?>> Observable<D> getAndTouch(final String id, final Class<D> target, final CouchbaseEnvironment environment, final String bucket, final ClusterFacade core, final Map<Class<? extends Document>, Transcoder<? extends Document, ?>> transcoders, final int expiry, final long timeout, final TimeUnit timeUnit) {
        return Observable.defer((Func0)new Func0<Observable<D>>(){

            public Observable<D> call() {
                final GetRequest request = new GetRequest(id, bucket, false, true, expiry);
                Utils.addRequestSpan(environment, request, "get_and_touch");
                return Utils.applyTimeout(OnSubscribeDeferAndWatch.deferAndWatch(new Func1<Subscriber, Observable<GetResponse>>(){

                    public Observable<GetResponse> call(Subscriber s) {
                        request.subscriber(s);
                        return core.send(request);
                    }
                }).filter((Func1)new GetAndTouchFilter(environment)).map(new GetMap(environment, transcoders, target, id)), request, environment, timeout, timeUnit);
            }
        });
    }

    public static class GetMap<D>
    implements Func1<GetResponse, D> {
        private final CouchbaseEnvironment environment;
        private final Map<Class<? extends Document>, Transcoder<? extends Document, ?>> transcoders;
        private final Class<D> target;
        private final String id;

        public GetMap(CouchbaseEnvironment environment, Map<Class<? extends Document>, Transcoder<? extends Document, ?>> transcoders, Class<D> target, String id) {
            this.environment = environment;
            this.transcoders = transcoders;
            this.target = target;
            this.id = id;
        }

        public D call(GetResponse response) {
            Transcoder<Document, ?> transcoder = this.transcoders.get(this.target);
            Scope decodeScope = null;
            if (this.environment.operationTracingEnabled()) {
                decodeScope = this.environment.tracer().buildSpan("response_decoding").asChildOf(response.request().span()).startActive(true);
            }
            Document decoded = transcoder.decode(this.id, response.content(), response.cas(), 0, response.flags(), response.status());
            if (this.environment.operationTracingEnabled() && decodeScope != null) {
                decodeScope.close();
                if (decodeScope.span() instanceof ThresholdLogSpan) {
                    decodeScope.span().setBaggageItem("decode_us", Long.toString(((ThresholdLogSpan)decodeScope.span()).durationMicros()));
                }
            }
            if (this.environment.operationTracingEnabled()) {
                this.environment.tracer().scopeManager().activate(response.request().span(), true).close();
            }
            return (D)decoded;
        }
    }

    private static class GetAndTouchFilter
    implements Func1<GetResponse, Boolean> {
        private final CouchbaseEnvironment environment;

        GetAndTouchFilter(CouchbaseEnvironment environment) {
            this.environment = environment;
        }

        public Boolean call(GetResponse response) {
            if (response.status().isSuccess()) {
                return true;
            }
            ByteBuf content = response.content();
            if (content != null && content.refCnt() > 0) {
                content.release();
            }
            if (this.environment.operationTracingEnabled()) {
                this.environment.tracer().scopeManager().activate(response.request().span(), true).close();
            }
            switch (response.status()) {
                case NOT_EXISTS: {
                    return false;
                }
                case TEMPORARY_FAILURE: 
                case SERVER_BUSY: 
                case LOCKED: {
                    throw Utils.addDetails(new TemporaryFailureException(), response);
                }
                case OUT_OF_MEMORY: {
                    throw Utils.addDetails(new CouchbaseOutOfMemoryException(), response);
                }
            }
            throw Utils.addDetails(new CouchbaseException(response.status().toString()), response);
        }
    }

    private static class GetAndLockFilter
    implements Func1<GetResponse, Boolean> {
        private final CouchbaseEnvironment environment;

        GetAndLockFilter(CouchbaseEnvironment environment) {
            this.environment = environment;
        }

        public Boolean call(GetResponse response) {
            if (response.status().isSuccess()) {
                return true;
            }
            ByteBuf content = response.content();
            if (content != null && content.refCnt() > 0) {
                content.release();
            }
            if (this.environment.operationTracingEnabled()) {
                this.environment.tracer().scopeManager().activate(response.request().span(), true).close();
            }
            switch (response.status()) {
                case NOT_EXISTS: {
                    return false;
                }
                case TEMPORARY_FAILURE: 
                case LOCKED: {
                    throw Utils.addDetails(new TemporaryLockFailureException(), response);
                }
                case SERVER_BUSY: {
                    throw Utils.addDetails(new TemporaryFailureException(), response);
                }
                case OUT_OF_MEMORY: {
                    throw Utils.addDetails(new CouchbaseOutOfMemoryException(), response);
                }
            }
            throw Utils.addDetails(new CouchbaseException(response.status().toString()), response);
        }
    }

    public static class GetFilter
    implements Func1<GetResponse, Boolean> {
        private final CouchbaseEnvironment environment;

        public GetFilter(CouchbaseEnvironment environment) {
            this.environment = environment;
        }

        public Boolean call(GetResponse response) {
            if (response.status().isSuccess()) {
                return true;
            }
            ByteBuf content = response.content();
            if (content != null && content.refCnt() > 0) {
                content.release();
            }
            if (this.environment.operationTracingEnabled()) {
                this.environment.tracer().scopeManager().activate(response.request().span(), true).close();
            }
            switch (response.status()) {
                case NOT_EXISTS: {
                    return false;
                }
                case TEMPORARY_FAILURE: 
                case SERVER_BUSY: {
                    throw Utils.addDetails(new TemporaryFailureException(), response);
                }
                case OUT_OF_MEMORY: {
                    throw Utils.addDetails(new CouchbaseOutOfMemoryException(), response);
                }
            }
            throw Utils.addDetails(new CouchbaseException(response.status().toString()), response);
        }
    }
}

