/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.core.CouchbaseException;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.CouchbaseResponse;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.core.message.cluster.CloseBucketRequest;
import com.couchbase.client.core.message.cluster.CloseBucketResponse;
import com.couchbase.client.core.message.internal.PingReport;
import com.couchbase.client.core.message.kv.subdoc.multi.Lookup;
import com.couchbase.client.core.message.kv.subdoc.multi.Mutation;
import com.couchbase.client.core.message.observe.Observe;
import com.couchbase.client.core.message.view.ViewQueryRequest;
import com.couchbase.client.core.message.view.ViewQueryResponse;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.utils.HealthPinger;
import com.couchbase.client.java.AsyncBucket;
import com.couchbase.client.java.PersistTo;
import com.couchbase.client.java.ReplicaMode;
import com.couchbase.client.java.ReplicateTo;
import com.couchbase.client.java.analytics.AnalyticsQuery;
import com.couchbase.client.java.analytics.AnalyticsQueryExecutor;
import com.couchbase.client.java.analytics.AsyncAnalyticsQueryResult;
import com.couchbase.client.java.bucket.AsyncBucketManager;
import com.couchbase.client.java.bucket.DefaultAsyncBucketManager;
import com.couchbase.client.java.bucket.ReplicaReader;
import com.couchbase.client.java.bucket.api.Exists;
import com.couchbase.client.java.bucket.api.Get;
import com.couchbase.client.java.bucket.api.Mutate;
import com.couchbase.client.java.bucket.api.Utils;
import com.couchbase.client.java.datastructures.MutationOptionBuilder;
import com.couchbase.client.java.datastructures.ResultMappingUtils;
import com.couchbase.client.java.document.Document;
import com.couchbase.client.java.document.JsonArrayDocument;
import com.couchbase.client.java.document.JsonDocument;
import com.couchbase.client.java.document.JsonLongDocument;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.error.CASMismatchException;
import com.couchbase.client.java.error.DocumentAlreadyExistsException;
import com.couchbase.client.java.error.DocumentDoesNotExistException;
import com.couchbase.client.java.error.DurabilityException;
import com.couchbase.client.java.error.subdoc.MultiMutationException;
import com.couchbase.client.java.error.subdoc.PathNotFoundException;
import com.couchbase.client.java.query.AsyncN1qlQueryResult;
import com.couchbase.client.java.query.N1qlQuery;
import com.couchbase.client.java.query.Statement;
import com.couchbase.client.java.query.core.N1qlQueryExecutor;
import com.couchbase.client.java.repository.AsyncRepository;
import com.couchbase.client.java.repository.CouchbaseAsyncRepository;
import com.couchbase.client.java.search.SearchQuery;
import com.couchbase.client.java.search.core.SearchQueryExecutor;
import com.couchbase.client.java.search.result.AsyncSearchQueryResult;
import com.couchbase.client.java.subdoc.AsyncLookupInBuilder;
import com.couchbase.client.java.subdoc.AsyncMutateInBuilder;
import com.couchbase.client.java.subdoc.DocumentFragment;
import com.couchbase.client.java.transcoder.BinaryTranscoder;
import com.couchbase.client.java.transcoder.ByteArrayTranscoder;
import com.couchbase.client.java.transcoder.JacksonTransformers;
import com.couchbase.client.java.transcoder.JsonArrayTranscoder;
import com.couchbase.client.java.transcoder.JsonBooleanTranscoder;
import com.couchbase.client.java.transcoder.JsonDoubleTranscoder;
import com.couchbase.client.java.transcoder.JsonLongTranscoder;
import com.couchbase.client.java.transcoder.JsonStringTranscoder;
import com.couchbase.client.java.transcoder.JsonTranscoder;
import com.couchbase.client.java.transcoder.LegacyTranscoder;
import com.couchbase.client.java.transcoder.RawJsonTranscoder;
import com.couchbase.client.java.transcoder.SerializableTranscoder;
import com.couchbase.client.java.transcoder.StringTranscoder;
import com.couchbase.client.java.transcoder.Transcoder;
import com.couchbase.client.java.transcoder.crypto.JsonCryptoTranscoder;
import com.couchbase.client.java.transcoder.subdoc.FragmentTranscoder;
import com.couchbase.client.java.transcoder.subdoc.JacksonFragmentTranscoder;
import com.couchbase.client.java.util.OnSubscribeDeferAndWatch;
import com.couchbase.client.java.view.AsyncSpatialViewResult;
import com.couchbase.client.java.view.AsyncViewResult;
import com.couchbase.client.java.view.SpatialViewQuery;
import com.couchbase.client.java.view.ViewQuery;
import com.couchbase.client.java.view.ViewQueryResponseMapper;
import com.couchbase.client.java.view.ViewRetryHandler;
import io.opentracing.Scope;
import io.opentracing.Span;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Single;
import rx.Subscriber;
import rx.functions.Action0;
import rx.functions.Func0;
import rx.functions.Func1;

public class CouchbaseAsyncBucket
implements AsyncBucket {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(CouchbaseAsyncBucket.class);
    public static final int COUNTER_NOT_EXISTS_EXPIRY = -1;
    private static final int MAX_CAS_RETRIES_DATASTRUCTURES = Integer.parseInt(System.getProperty("com.couchbase.datastructureCASRetryLimit", "10"));
    public static final String CURRENT_BUCKET_IDENTIFIER = "#CURRENT_BUCKET#";
    public static final JsonTranscoder JSON_OBJECT_TRANSCODER = new JsonTranscoder();
    public static final JsonArrayTranscoder JSON_ARRAY_TRANSCODER = new JsonArrayTranscoder();
    public static final JsonBooleanTranscoder JSON_BOOLEAN_TRANSCODER = new JsonBooleanTranscoder();
    public static final JsonDoubleTranscoder JSON_DOUBLE_TRANSCODER = new JsonDoubleTranscoder();
    public static final JsonLongTranscoder JSON_LONG_TRANSCODER = new JsonLongTranscoder();
    public static final JsonStringTranscoder JSON_STRING_TRANSCODER = new JsonStringTranscoder();
    public static final RawJsonTranscoder RAW_JSON_TRANSCODER = new RawJsonTranscoder();
    public static final ByteArrayTranscoder BYTE_ARRAY_TRANSCODER = new ByteArrayTranscoder();
    public static final LegacyTranscoder LEGACY_TRANSCODER = new LegacyTranscoder();
    public static final BinaryTranscoder BINARY_TRANSCODER = new BinaryTranscoder();
    public static final StringTranscoder STRING_TRANSCODER = new StringTranscoder();
    public static final SerializableTranscoder SERIALIZABLE_TRANSCODER = new SerializableTranscoder();
    private final String bucket;
    private final String username;
    private final String password;
    private final ClusterFacade core;
    private final Map<Class<? extends Document>, Transcoder<? extends Document, ?>> transcoders;
    private final FragmentTranscoder subdocumentTranscoder = new JacksonFragmentTranscoder(JacksonTransformers.MAPPER);
    private final AsyncBucketManager bucketManager;
    private final CouchbaseEnvironment environment;
    private final N1qlQueryExecutor n1qlQueryExecutor;
    private final AnalyticsQueryExecutor analyticsQueryExecutor;
    private final SearchQueryExecutor searchQueryExecutor;
    private volatile boolean closed;

    public CouchbaseAsyncBucket(ClusterFacade core, CouchbaseEnvironment environment, String name, String password, List<Transcoder<? extends Document, ?>> customTranscoders) {
        this(core, environment, name, name, password, customTranscoders);
    }

    public CouchbaseAsyncBucket(ClusterFacade core, CouchbaseEnvironment environment, String name, String username, String password, List<Transcoder<? extends Document, ?>> customTranscoders) {
        this.bucket = name;
        this.username = username;
        this.password = password;
        this.core = core;
        this.environment = environment;
        this.closed = false;
        this.transcoders = new ConcurrentHashMap();
        if (environment != null && environment.cryptoManager() != null) {
            JsonCryptoTranscoder transcoder = new JsonCryptoTranscoder(environment.cryptoManager());
            this.transcoders.put(transcoder.documentType(), transcoder);
        } else {
            this.transcoders.put(JSON_OBJECT_TRANSCODER.documentType(), JSON_OBJECT_TRANSCODER);
        }
        this.transcoders.put(JSON_ARRAY_TRANSCODER.documentType(), JSON_ARRAY_TRANSCODER);
        this.transcoders.put(JSON_BOOLEAN_TRANSCODER.documentType(), JSON_BOOLEAN_TRANSCODER);
        this.transcoders.put(JSON_DOUBLE_TRANSCODER.documentType(), JSON_DOUBLE_TRANSCODER);
        this.transcoders.put(JSON_LONG_TRANSCODER.documentType(), JSON_LONG_TRANSCODER);
        this.transcoders.put(JSON_STRING_TRANSCODER.documentType(), JSON_STRING_TRANSCODER);
        this.transcoders.put(RAW_JSON_TRANSCODER.documentType(), RAW_JSON_TRANSCODER);
        this.transcoders.put(LEGACY_TRANSCODER.documentType(), LEGACY_TRANSCODER);
        this.transcoders.put(BINARY_TRANSCODER.documentType(), BINARY_TRANSCODER);
        this.transcoders.put(STRING_TRANSCODER.documentType(), STRING_TRANSCODER);
        this.transcoders.put(SERIALIZABLE_TRANSCODER.documentType(), SERIALIZABLE_TRANSCODER);
        this.transcoders.put(BYTE_ARRAY_TRANSCODER.documentType(), BYTE_ARRAY_TRANSCODER);
        for (Transcoder transcoder : customTranscoders) {
            this.transcoders.put(transcoder.documentType(), transcoder);
        }
        this.bucketManager = DefaultAsyncBucketManager.create(this.bucket, username, password, core, environment);
        boolean n1qlPreparedEncodedPlanEnabled = "true".equalsIgnoreCase(System.getProperty("com.couchbase.query.encodedPlanEnabled", "true"));
        this.n1qlQueryExecutor = new N1qlQueryExecutor(core, this.bucket, username, password, n1qlPreparedEncodedPlanEnabled);
        this.analyticsQueryExecutor = new AnalyticsQueryExecutor(core, this.bucket, username, password);
        this.searchQueryExecutor = new SearchQueryExecutor(environment, core, this.bucket, username, password);
    }

    @Override
    public String name() {
        return this.bucket;
    }

    @Override
    public Observable<ClusterFacade> core() {
        return Observable.just((Object)this.core);
    }

    @Override
    public FragmentTranscoder subdocumentTranscoder() {
        return this.subdocumentTranscoder;
    }

    protected N1qlQueryExecutor n1qlQueryExecutor() {
        return this.n1qlQueryExecutor;
    }

    @Override
    public CouchbaseEnvironment environment() {
        return this.environment;
    }

    @Override
    public Observable<AsyncRepository> repository() {
        return Observable.just((Object)new CouchbaseAsyncRepository(this));
    }

    @Override
    public Observable<JsonDocument> get(String id) {
        return this.get(id, JsonDocument.class);
    }

    @Override
    public <D extends Document<?>> Observable<D> get(D document) {
        return this.get(document.id(), document.getClass());
    }

    @Override
    public <D extends Document<?>> Observable<D> get(String id, Class<D> target) {
        return Get.get(id, target, this.environment, this.bucket, this.core, this.transcoders, 0L, null);
    }

    @Override
    public <D extends Document<?>> Observable<D> get(String id, Class<D> target, long timeout, TimeUnit timeUnit) {
        return Get.get(id, target, this.environment, this.bucket, this.core, this.transcoders, timeout, timeUnit);
    }

    @Override
    public Observable<JsonDocument> get(String id, long timeout, TimeUnit timeUnit) {
        return this.get(id, JsonDocument.class, timeout, timeUnit);
    }

    @Override
    public <D extends Document<?>> Observable<D> get(D document, long timeout, TimeUnit timeUnit) {
        return Get.get(document.id(), document.getClass(), this.environment, this.bucket, this.core, this.transcoders, timeout, timeUnit);
    }

    @Override
    public Observable<Boolean> exists(String id, long timeout, TimeUnit timeUnit) {
        return Exists.exists(id, this.environment, this.core, this.bucket, timeout, timeUnit);
    }

    @Override
    public <D extends Document<?>> Observable<Boolean> exists(D document, long timeout, TimeUnit timeUnit) {
        return this.exists((D)((Object)document.id()), timeout, timeUnit);
    }

    @Override
    public Observable<Boolean> exists(String id) {
        return Exists.exists(id, this.environment, this.core, this.bucket, 0L, null);
    }

    @Override
    public <D extends Document<?>> Observable<Boolean> exists(D document) {
        return this.exists((D)((Object)document.id()));
    }

    @Override
    public Observable<JsonDocument> getAndLock(String id, int lockTime) {
        return this.getAndLock(id, lockTime, JsonDocument.class);
    }

    @Override
    public <D extends Document<?>> Observable<D> getAndLock(D document, int lockTime) {
        return this.getAndLock(document.id(), lockTime, document.getClass());
    }

    @Override
    public <D extends Document<?>> Observable<D> getAndLock(String id, int lockTime, Class<D> target) {
        return Get.getAndLock(id, target, this.environment, this.bucket, this.core, this.transcoders, lockTime, 0L, null);
    }

    @Override
    public Observable<JsonDocument> getAndTouch(String id, int expiry) {
        return this.getAndTouch(id, expiry, JsonDocument.class);
    }

    @Override
    public <D extends Document<?>> Observable<D> getAndTouch(D document) {
        return this.getAndTouch(document.id(), document.expiry(), document.getClass());
    }

    @Override
    public <D extends Document<?>> Observable<D> getAndTouch(String id, int expiry, Class<D> target) {
        return Get.getAndTouch(id, target, this.environment, this.bucket, this.core, this.transcoders, expiry, 0L, null);
    }

    @Override
    public Observable<JsonDocument> getFromReplica(String id, ReplicaMode type) {
        return this.getFromReplica(id, type, JsonDocument.class);
    }

    @Override
    public <D extends Document<?>> Observable<D> getFromReplica(D document, ReplicaMode type) {
        return this.getFromReplica(document.id(), type, document.getClass());
    }

    @Override
    public <D extends Document<?>> Observable<D> getFromReplica(String id, ReplicaMode type, Class<D> target) {
        return this.getFromReplica(id, type, target, 0L, null);
    }

    @Override
    public Observable<JsonDocument> getFromReplica(String id, ReplicaMode type, long timeout, TimeUnit timeUnit) {
        return this.getFromReplica(id, type, JsonDocument.class, timeout, timeUnit);
    }

    @Override
    public <D extends Document<?>> Observable<D> getFromReplica(D document, ReplicaMode type, long timeout, TimeUnit timeUnit) {
        return this.getFromReplica(document.id(), type, document.getClass(), timeout, timeUnit);
    }

    @Override
    public <D extends Document<?>> Observable<D> getFromReplica(String id, ReplicaMode type, Class<D> target, long timeout, TimeUnit timeUnit) {
        return ReplicaReader.read(this.core, id, type, this.bucket, this.transcoders, target, this.environment, timeout, timeUnit);
    }

    @Override
    public Observable<JsonDocument> getAndLock(String id, int lockTime, long timeout, TimeUnit timeUnit) {
        return this.getAndLock(id, lockTime, JsonDocument.class, timeout, timeUnit);
    }

    @Override
    public <D extends Document<?>> Observable<D> getAndLock(D document, int lockTime, long timeout, TimeUnit timeUnit) {
        return this.getAndLock(document.id(), lockTime, document.getClass(), timeout, timeUnit);
    }

    @Override
    public <D extends Document<?>> Observable<D> getAndLock(String id, int lockTime, Class<D> target, long timeout, TimeUnit timeUnit) {
        return Get.getAndLock(id, target, this.environment, this.bucket, this.core, this.transcoders, lockTime, timeout, timeUnit);
    }

    @Override
    public Observable<JsonDocument> getAndTouch(String id, int expiry, long timeout, TimeUnit timeUnit) {
        return this.getAndTouch(id, expiry, JsonDocument.class, timeout, timeUnit);
    }

    @Override
    public <D extends Document<?>> Observable<D> getAndTouch(D document, long timeout, TimeUnit timeUnit) {
        return this.getAndTouch(document.id(), document.expiry(), document.getClass(), timeout, timeUnit);
    }

    @Override
    public <D extends Document<?>> Observable<D> getAndTouch(String id, int expiry, Class<D> target, long timeout, TimeUnit timeUnit) {
        return Get.getAndTouch(id, target, this.environment, this.bucket, this.core, this.transcoders, expiry, timeout, timeUnit);
    }

    @Override
    public <D extends Document<?>> Observable<D> insert(D document) {
        return this.insert(document, 0L, null);
    }

    @Override
    public <D extends Document<?>> Observable<D> insert(D document, final PersistTo persistTo, final ReplicateTo replicateTo, final long timeout, final TimeUnit timeUnit) {
        if (persistTo == PersistTo.NONE && replicateTo == ReplicateTo.NONE) {
            return this.insert(document, timeout, timeUnit);
        }
        final Span parent = this.startTracing("insert_with_durability");
        return this.insert(document, parent, timeout, timeUnit).flatMap(new Func1<D, Observable<D>>(){

            public Observable<D> call(D doc) {
                Observable or = Observe.call(CouchbaseAsyncBucket.this.core, CouchbaseAsyncBucket.this.bucket, doc.id(), doc.cas(), false, doc.mutationToken(), persistTo.value(), replicateTo.value(), CouchbaseAsyncBucket.this.environment.observeIntervalDelay(), CouchbaseAsyncBucket.this.environment.retryStrategy(), parent).map(new Func1<Boolean, D>((Document)doc){
                    final /* synthetic */ Document val$doc;
                    {
                        this.val$doc = document;
                    }

                    public D call(Boolean aBoolean) {
                        return this.val$doc;
                    }
                }).onErrorResumeNext(new Func1<Throwable, Observable<? extends D>>(){

                    public Observable<? extends D> call(Throwable throwable) {
                        return Observable.error((Throwable)new DurabilityException("Durability requirement failed: " + throwable.getMessage(), throwable));
                    }
                });
                return timeout > 0L ? or.timeout(timeout, timeUnit, CouchbaseAsyncBucket.this.environment.scheduler()) : or;
            }
        }).doOnTerminate(this.stopTracing(parent));
    }

    @Override
    public <D extends Document<?>> Observable<D> upsert(D document) {
        return this.upsert(document, 0L, null);
    }

    @Override
    public <D extends Document<?>> Observable<D> upsert(D document, final PersistTo persistTo, final ReplicateTo replicateTo, final long timeout, final TimeUnit timeUnit) {
        if (persistTo == PersistTo.NONE && replicateTo == ReplicateTo.NONE) {
            return this.upsert(document, timeout, timeUnit);
        }
        final Span parent = this.startTracing("upsert_with_durability");
        return this.upsert(document, parent, timeout, timeUnit).flatMap(new Func1<D, Observable<D>>(){

            public Observable<D> call(D doc) {
                Observable or = Observe.call(CouchbaseAsyncBucket.this.core, CouchbaseAsyncBucket.this.bucket, doc.id(), doc.cas(), false, doc.mutationToken(), persistTo.value(), replicateTo.value(), CouchbaseAsyncBucket.this.environment.observeIntervalDelay(), CouchbaseAsyncBucket.this.environment.retryStrategy(), parent).map(new Func1<Boolean, D>((Document)doc){
                    final /* synthetic */ Document val$doc;
                    {
                        this.val$doc = document;
                    }

                    public D call(Boolean aBoolean) {
                        return this.val$doc;
                    }
                }).onErrorResumeNext(new Func1<Throwable, Observable<? extends D>>(){

                    public Observable<? extends D> call(Throwable throwable) {
                        return Observable.error((Throwable)new DurabilityException("Durability requirement failed: " + throwable.getMessage(), throwable));
                    }
                });
                return timeout > 0L ? or.timeout(timeout, timeUnit, CouchbaseAsyncBucket.this.environment.scheduler()) : or;
            }
        }).doOnTerminate(this.stopTracing(parent));
    }

    @Override
    public <D extends Document<?>> Observable<D> replace(D document) {
        return this.replace(document, 0L, null);
    }

    @Override
    public <D extends Document<?>> Observable<D> insert(D document, long timeout, TimeUnit timeUnit) {
        return this.insert(document, (Span)null, timeout, timeUnit);
    }

    private <D extends Document<?>> Observable<D> insert(D document, Span parent, long timeout, TimeUnit timeUnit) {
        Transcoder<Document<Object>, Object> transcoder = this.transcoders.get(document.getClass());
        return Mutate.insert(document, this.environment, transcoder, this.core, this.bucket, timeout, timeUnit, parent);
    }

    @Override
    public <D extends Document<?>> Observable<D> insert(D document, PersistTo persistTo, ReplicateTo replicateTo) {
        return this.insert(document, persistTo, replicateTo, 0L, null);
    }

    @Override
    public <D extends Document<?>> Observable<D> insert(D document, PersistTo persistTo, long timeout, TimeUnit timeUnit) {
        return this.insert(document, persistTo, ReplicateTo.NONE, timeout, timeUnit);
    }

    @Override
    public <D extends Document<?>> Observable<D> insert(D document, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return this.insert(document, PersistTo.NONE, replicateTo, timeout, timeUnit);
    }

    @Override
    public <D extends Document<?>> Observable<D> upsert(D document, long timeout, TimeUnit timeUnit) {
        return this.upsert(document, (Span)null, timeout, timeUnit);
    }

    private <D extends Document<?>> Observable<D> upsert(D document, Span parent, long timeout, TimeUnit timeUnit) {
        Transcoder<Document<Object>, Object> transcoder = this.transcoders.get(document.getClass());
        return Mutate.upsert(document, this.environment, transcoder, this.core, this.bucket, timeout, timeUnit, parent);
    }

    @Override
    public <D extends Document<?>> Observable<D> upsert(D document, PersistTo persistTo, ReplicateTo replicateTo) {
        return this.upsert(document, persistTo, replicateTo, 0L, null);
    }

    @Override
    public <D extends Document<?>> Observable<D> upsert(D document, PersistTo persistTo, long timeout, TimeUnit timeUnit) {
        return this.upsert(document, persistTo, ReplicateTo.NONE, timeout, timeUnit);
    }

    @Override
    public <D extends Document<?>> Observable<D> upsert(D document, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return this.upsert(document, PersistTo.NONE, replicateTo, timeout, timeUnit);
    }

    @Override
    public <D extends Document<?>> Observable<D> replace(D document, long timeout, TimeUnit timeUnit) {
        return this.replace(document, (Span)null, timeout, timeUnit);
    }

    private <D extends Document<?>> Observable<D> replace(D document, Span parent, long timeout, TimeUnit timeUnit) {
        Transcoder<Document<Object>, Object> transcoder = this.transcoders.get(document.getClass());
        return Mutate.replace(document, this.environment, transcoder, this.core, this.bucket, timeout, timeUnit, parent);
    }

    @Override
    public <D extends Document<?>> Observable<D> replace(D document, PersistTo persistTo, ReplicateTo replicateTo) {
        return this.replace(document, persistTo, replicateTo, 0L, null);
    }

    @Override
    public <D extends Document<?>> Observable<D> replace(D document, PersistTo persistTo, long timeout, TimeUnit timeUnit) {
        return this.replace(document, persistTo, ReplicateTo.NONE, timeout, timeUnit);
    }

    @Override
    public <D extends Document<?>> Observable<D> replace(D document, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return this.replace(document, PersistTo.NONE, replicateTo, timeout, timeUnit);
    }

    @Override
    public <D extends Document<?>> Observable<D> replace(D document, final PersistTo persistTo, final ReplicateTo replicateTo, final long timeout, final TimeUnit timeUnit) {
        if (persistTo == PersistTo.NONE && replicateTo == ReplicateTo.NONE) {
            return this.replace(document, timeout, timeUnit);
        }
        final Span parent = this.startTracing("replace_with_durability");
        return this.replace(document, parent, timeout, timeUnit).flatMap(new Func1<D, Observable<D>>(){

            public Observable<D> call(D doc) {
                Observable or = Observe.call(CouchbaseAsyncBucket.this.core, CouchbaseAsyncBucket.this.bucket, doc.id(), doc.cas(), false, doc.mutationToken(), persistTo.value(), replicateTo.value(), CouchbaseAsyncBucket.this.environment.observeIntervalDelay(), CouchbaseAsyncBucket.this.environment.retryStrategy(), parent).map(new Func1<Boolean, D>((Document)doc){
                    final /* synthetic */ Document val$doc;
                    {
                        this.val$doc = document;
                    }

                    public D call(Boolean aBoolean) {
                        return this.val$doc;
                    }
                }).onErrorResumeNext(new Func1<Throwable, Observable<? extends D>>(){

                    public Observable<? extends D> call(Throwable throwable) {
                        return Observable.error((Throwable)new DurabilityException("Durability requirement failed: " + throwable.getMessage(), throwable));
                    }
                });
                return timeout > 0L ? or.timeout(timeout, timeUnit, CouchbaseAsyncBucket.this.environment.scheduler()) : or;
            }
        }).doOnTerminate(this.stopTracing(parent));
    }

    @Override
    public <D extends Document<?>> Observable<D> remove(D document, long timeout, TimeUnit timeUnit) {
        return this.remove(document, (Span)null, timeout, timeUnit);
    }

    private <D extends Document<?>> Observable<D> remove(D document, Span parent, long timeout, TimeUnit timeUnit) {
        Transcoder<Document<Object>, Object> transcoder = this.transcoders.get(document.getClass());
        return Mutate.remove(document, this.environment, transcoder, this.core, this.bucket, timeout, timeUnit, parent);
    }

    @Override
    public Observable<JsonDocument> remove(String id) {
        return this.remove(id, JsonDocument.class);
    }

    @Override
    public <D extends Document<?>> Observable<D> remove(String id, Class<D> target) {
        Transcoder<Document, ?> transcoder = this.transcoders.get(target);
        return this.remove(transcoder.newDocument(id, 0, null, 0L, null));
    }

    @Override
    public <D extends Document<?>> Observable<D> remove(D document, PersistTo persistTo, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return this.observeRemove(document, persistTo, replicateTo, timeout, timeUnit);
    }

    @Override
    public Observable<JsonDocument> remove(String id, PersistTo persistTo, ReplicateTo replicateTo) {
        return this.remove(id, persistTo, replicateTo, JsonDocument.class);
    }

    @Override
    public <D extends Document<?>> Observable<D> remove(String id, PersistTo persistTo, ReplicateTo replicateTo, Class<D> target, long timeout, TimeUnit timeUnit) {
        Transcoder<Document, ?> transcoder = this.transcoders.get(target);
        return this.observeRemove(transcoder.newDocument(id, 0, null, 0L, null), persistTo, replicateTo, timeout, timeUnit);
    }

    @Override
    public <D extends Document<?>> Observable<D> remove(D document) {
        return this.remove(document, 0L, null);
    }

    @Override
    public <D extends Document<?>> Observable<D> remove(D document, PersistTo persistTo, ReplicateTo replicateTo) {
        return this.remove(document, persistTo, replicateTo, 0L, null);
    }

    @Override
    public <D extends Document<?>> Observable<D> remove(D document, PersistTo persistTo, long timeout, TimeUnit timeUnit) {
        return this.remove(document, persistTo, ReplicateTo.NONE, timeout, timeUnit);
    }

    @Override
    public <D extends Document<?>> Observable<D> remove(D document, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return this.remove(document, PersistTo.NONE, replicateTo, timeout, timeUnit);
    }

    @Override
    public Observable<JsonDocument> remove(String id, long timeout, TimeUnit timeUnit) {
        return this.remove(id, JsonDocument.class, timeout, timeUnit);
    }

    @Override
    public Observable<JsonDocument> remove(String id, PersistTo persistTo, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return this.remove(id, persistTo, replicateTo, JsonDocument.class, timeout, timeUnit);
    }

    @Override
    public Observable<JsonDocument> remove(String id, PersistTo persistTo, long timeout, TimeUnit timeUnit) {
        return this.remove(id, persistTo, ReplicateTo.NONE, JsonDocument.class, timeout, timeUnit);
    }

    @Override
    public Observable<JsonDocument> remove(String id, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return this.remove(id, PersistTo.NONE, replicateTo, JsonDocument.class, timeout, timeUnit);
    }

    @Override
    public <D extends Document<?>> Observable<D> remove(String id, Class<D> target, long timeout, TimeUnit timeUnit) {
        Transcoder<Document, ?> transcoder = this.transcoders.get(target);
        return this.remove(transcoder.newDocument(id, 0, null, 0L, null), timeout, timeUnit);
    }

    @Override
    public <D extends Document<?>> Observable<D> remove(String id, PersistTo persistTo, ReplicateTo replicateTo, Class<D> target) {
        return this.remove(id, persistTo, replicateTo, target, 0L, null);
    }

    @Override
    public <D extends Document<?>> Observable<D> remove(String id, PersistTo persistTo, Class<D> target, long timeout, TimeUnit timeUnit) {
        return this.remove(id, persistTo, ReplicateTo.NONE, target, timeout, timeUnit);
    }

    @Override
    public <D extends Document<?>> Observable<D> remove(String id, ReplicateTo replicateTo, Class<D> target, long timeout, TimeUnit timeUnit) {
        return this.remove(id, PersistTo.NONE, replicateTo, target, timeout, timeUnit);
    }

    private <D extends Document<?>> Observable<D> observeRemove(D document, final PersistTo persistTo, final ReplicateTo replicateTo, final long timeout, final TimeUnit timeUnit) {
        if (persistTo == PersistTo.NONE && replicateTo == ReplicateTo.NONE) {
            return this.remove(document, timeout, timeUnit);
        }
        final Span parent = this.startTracing("remove_with_durability");
        return this.remove(document, parent, timeout, timeUnit).flatMap(new Func1<D, Observable<D>>(){

            public Observable<D> call(D doc) {
                Observable or = Observe.call(CouchbaseAsyncBucket.this.core, CouchbaseAsyncBucket.this.bucket, doc.id(), doc.cas(), true, doc.mutationToken(), persistTo.value(), replicateTo.value(), CouchbaseAsyncBucket.this.environment.observeIntervalDelay(), CouchbaseAsyncBucket.this.environment.retryStrategy(), parent).map(new Func1<Boolean, D>((Document)doc){
                    final /* synthetic */ Document val$doc;
                    {
                        this.val$doc = document;
                    }

                    public D call(Boolean aBoolean) {
                        return this.val$doc;
                    }
                }).onErrorResumeNext(new Func1<Throwable, Observable<? extends D>>(){

                    public Observable<? extends D> call(Throwable throwable) {
                        return Observable.error((Throwable)new DurabilityException("Durability requirement failed: " + throwable.getMessage(), throwable));
                    }
                });
                return timeout > 0L ? or.timeout(timeout, timeUnit, CouchbaseAsyncBucket.this.environment.scheduler()) : or;
            }
        }).doOnTerminate(this.stopTracing(parent));
    }

    @Override
    public Observable<AsyncViewResult> query(ViewQuery query) {
        return this.query(query, this.environment.viewTimeout(), TimeUnit.MILLISECONDS);
    }

    @Override
    public Observable<AsyncViewResult> query(final ViewQuery query, final long timeout, final TimeUnit timeUnit) {
        Observable<? extends ViewQueryResponse> source = OnSubscribeDeferAndWatch.deferAndWatch(new Func1<Subscriber, Observable<? extends ViewQueryResponse>>(){

            public Observable<? extends ViewQueryResponse> call(Subscriber subscriber) {
                ViewQueryRequest request = new ViewQueryRequest(query.getDesign(), query.getView(), query.isDevelopment(), query.toQueryString(), query.getKeys(), CouchbaseAsyncBucket.this.bucket, CouchbaseAsyncBucket.this.username, CouchbaseAsyncBucket.this.password);
                Utils.addRequestSpan(CouchbaseAsyncBucket.this.environment, request, "view");
                request.subscriber(subscriber);
                return Utils.applyTimeout(CouchbaseAsyncBucket.this.core.send(request), request, CouchbaseAsyncBucket.this.environment, timeout, timeUnit);
            }
        });
        return ViewRetryHandler.retryOnCondition(source).flatMap((Func1)new Func1<ViewQueryResponse, Observable<AsyncViewResult>>(){

            public Observable<AsyncViewResult> call(ViewQueryResponse response) {
                return ViewQueryResponseMapper.mapToViewResult(CouchbaseAsyncBucket.this, query, response);
            }
        });
    }

    @Override
    public Observable<AsyncSearchQueryResult> query(SearchQuery query) {
        return this.query(query, this.environment.searchTimeout(), TimeUnit.MILLISECONDS);
    }

    @Override
    public Observable<AsyncSearchQueryResult> query(SearchQuery query, long timeout, TimeUnit timeUnit) {
        if (query.getServerSideTimeout() == null) {
            query.serverSideTimeout(this.environment().searchTimeout(), TimeUnit.MILLISECONDS);
        }
        return this.searchQueryExecutor.execute(query, timeout, timeUnit);
    }

    @Override
    public Observable<AsyncSpatialViewResult> query(SpatialViewQuery query) {
        return this.query(query, this.environment.viewTimeout(), TimeUnit.MILLISECONDS);
    }

    @Override
    public Observable<AsyncSpatialViewResult> query(final SpatialViewQuery query, final long timeout, final TimeUnit timeUnit) {
        Observable<? extends ViewQueryResponse> source = OnSubscribeDeferAndWatch.deferAndWatch(new Func1<Subscriber, Observable<? extends ViewQueryResponse>>(){

            public Observable<? extends ViewQueryResponse> call(Subscriber subscriber) {
                ViewQueryRequest request = new ViewQueryRequest(query.getDesign(), query.getView(), query.isDevelopment(), true, query.toString(), null, CouchbaseAsyncBucket.this.bucket, CouchbaseAsyncBucket.this.username, CouchbaseAsyncBucket.this.password);
                Utils.addRequestSpan(CouchbaseAsyncBucket.this.environment, request, "spatial_view");
                request.subscriber(subscriber);
                return Utils.applyTimeout(CouchbaseAsyncBucket.this.core.send(request), request, CouchbaseAsyncBucket.this.environment, timeout, timeUnit);
            }
        });
        return ViewRetryHandler.retryOnCondition(source).flatMap((Func1)new Func1<ViewQueryResponse, Observable<AsyncSpatialViewResult>>(){

            public Observable<AsyncSpatialViewResult> call(ViewQueryResponse response) {
                return ViewQueryResponseMapper.mapToSpatialViewResult(CouchbaseAsyncBucket.this, query, response);
            }
        });
    }

    @Override
    public Observable<AsyncN1qlQueryResult> query(Statement statement) {
        return this.query(N1qlQuery.simple(statement));
    }

    @Override
    public Observable<AsyncN1qlQueryResult> query(N1qlQuery query) {
        return this.query(query, this.environment.queryTimeout(), TimeUnit.MILLISECONDS);
    }

    @Override
    public Observable<AsyncN1qlQueryResult> query(N1qlQuery query, long timeout, TimeUnit timeUnit) {
        if (!query.params().hasServerSideTimeout()) {
            query.params().serverSideTimeout(timeout, timeUnit);
        }
        if (query.params().clientContextId() == null || query.params().clientContextId().isEmpty()) {
            query.params().withContextId(UUID.randomUUID().toString());
        }
        return this.n1qlQueryExecutor.execute(query, this.environment, timeout, timeUnit);
    }

    @Override
    public Observable<AsyncAnalyticsQueryResult> query(AnalyticsQuery query) {
        return this.query(query, this.environment.analyticsTimeout(), TimeUnit.MILLISECONDS);
    }

    @Override
    public Observable<AsyncAnalyticsQueryResult> query(AnalyticsQuery query, long timeout, TimeUnit timeUnit) {
        if (!query.params().hasServerSideTimeout()) {
            query.params().serverSideTimeout(timeout, timeUnit);
        }
        if (query.params().clientContextId() == null || query.params().clientContextId().isEmpty()) {
            query.params().withContextId(UUID.randomUUID().toString());
        }
        return this.analyticsQueryExecutor.execute(query, this.environment, timeout, timeUnit);
    }

    @Override
    public Observable<JsonLongDocument> counter(String id, long delta, long timeout, TimeUnit timeUnit) {
        return this.counter(id, delta, 0L, -1, timeout, timeUnit);
    }

    @Override
    public Observable<JsonLongDocument> counter(String id, long delta, long initial, long timeout, TimeUnit timeUnit) {
        return this.counter(id, delta, initial, 0, timeout, timeUnit);
    }

    @Override
    public Observable<JsonLongDocument> counter(String id, long delta, long initial, int expiry, long timeout, TimeUnit timeUnit) {
        return this.counter(id, delta, initial, expiry, (Span)null, timeout, timeUnit);
    }

    private Observable<JsonLongDocument> counter(String id, long delta, long initial, int expiry, Span parent, long timeout, TimeUnit timeUnit) {
        return Mutate.counter(id, delta, initial, expiry, this.environment, this.core, this.bucket, timeout, timeUnit, parent);
    }

    @Override
    public Observable<Boolean> unlock(String id, long cas, long timeout, TimeUnit timeUnit) {
        return Mutate.unlock(id, cas, this.environment, this.core, this.bucket, timeout, timeUnit);
    }

    @Override
    public <D extends Document<?>> Observable<Boolean> unlock(D document, long timeout, TimeUnit timeUnit) {
        return this.unlock(document.id(), document.cas(), timeout, timeUnit);
    }

    @Override
    public Observable<Boolean> unlock(String id, long cas) {
        return this.unlock(id, cas, 0L, null);
    }

    @Override
    public <D extends Document<?>> Observable<Boolean> unlock(D document) {
        return this.unlock(document, 0L, null);
    }

    @Override
    public Observable<Boolean> touch(String id, int expiry, long timeout, TimeUnit timeUnit) {
        return Mutate.touch(id, expiry, this.environment, this.core, this.bucket, timeout, timeUnit);
    }

    @Override
    public <D extends Document<?>> Observable<Boolean> touch(D document, long timeout, TimeUnit timeUnit) {
        return this.touch(document.id(), document.expiry(), timeout, timeUnit);
    }

    @Override
    public Observable<Boolean> touch(String id, int expiry) {
        return this.touch(id, expiry, 0L, null);
    }

    @Override
    public <D extends Document<?>> Observable<Boolean> touch(D document) {
        return this.touch(document, 0L, null);
    }

    @Override
    public <D extends Document<?>> Observable<D> append(D document, long timeout, TimeUnit timeUnit) {
        return this.append(document, (Span)null, timeout, timeUnit);
    }

    private <D extends Document<?>> Observable<D> append(D document, Span parent, long timeout, TimeUnit timeUnit) {
        Transcoder<Document<Object>, Object> transcoder = this.transcoders.get(document.getClass());
        return Mutate.append(document, this.environment, transcoder, this.core, this.bucket, timeout, timeUnit, parent);
    }

    @Override
    public <D extends Document<?>> Observable<D> prepend(D document, long timeout, TimeUnit timeUnit) {
        return this.prepend(document, (Span)null, timeout, timeUnit);
    }

    private <D extends Document<?>> Observable<D> prepend(D document, Span parent, long timeout, TimeUnit timeUnit) {
        Transcoder<Document<Object>, Object> transcoder = this.transcoders.get(document.getClass());
        return Mutate.prepend(document, this.environment, transcoder, this.core, this.bucket, timeout, timeUnit, parent);
    }

    @Override
    public Observable<AsyncBucketManager> bucketManager() {
        return Observable.just((Object)this.bucketManager);
    }

    @Override
    public <D extends Document<?>> Observable<D> insert(D document, PersistTo persistTo) {
        return this.insert(document, persistTo, ReplicateTo.NONE);
    }

    @Override
    public <D extends Document<?>> Observable<D> insert(D document, ReplicateTo replicateTo) {
        return this.insert(document, PersistTo.NONE, replicateTo);
    }

    @Override
    public <D extends Document<?>> Observable<D> upsert(D document, PersistTo persistTo) {
        return this.upsert(document, persistTo, ReplicateTo.NONE);
    }

    @Override
    public <D extends Document<?>> Observable<D> upsert(D document, ReplicateTo replicateTo) {
        return this.upsert(document, PersistTo.NONE, replicateTo);
    }

    @Override
    public <D extends Document<?>> Observable<D> replace(D document, PersistTo persistTo) {
        return this.replace(document, persistTo, ReplicateTo.NONE);
    }

    @Override
    public <D extends Document<?>> Observable<D> replace(D document, ReplicateTo replicateTo) {
        return this.replace(document, PersistTo.NONE, replicateTo);
    }

    @Override
    public <D extends Document<?>> Observable<D> remove(D document, PersistTo persistTo) {
        return this.remove(document, persistTo, ReplicateTo.NONE);
    }

    @Override
    public <D extends Document<?>> Observable<D> remove(D document, ReplicateTo replicateTo) {
        return this.remove(document, PersistTo.NONE, replicateTo);
    }

    @Override
    public Observable<JsonDocument> remove(String id, PersistTo persistTo) {
        return this.remove((Document)((Object)id), persistTo, ReplicateTo.NONE);
    }

    @Override
    public Observable<JsonDocument> remove(String id, ReplicateTo replicateTo) {
        return this.remove((Document)((Object)id), PersistTo.NONE, replicateTo);
    }

    @Override
    public <D extends Document<?>> Observable<D> remove(String id, PersistTo persistTo, Class<D> target) {
        return this.remove(id, persistTo, ReplicateTo.NONE, target);
    }

    @Override
    public <D extends Document<?>> Observable<D> remove(String id, ReplicateTo replicateTo, Class<D> target) {
        return this.remove(id, PersistTo.NONE, replicateTo, target);
    }

    @Override
    public Observable<JsonLongDocument> counter(String id, long delta, PersistTo persistTo, long timeout, TimeUnit timeUnit) {
        return this.counter(id, delta, persistTo, ReplicateTo.NONE, timeout, timeUnit);
    }

    @Override
    public Observable<JsonLongDocument> counter(String id, long delta, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return this.counter(id, delta, PersistTo.NONE, replicateTo, timeout, timeUnit);
    }

    @Override
    public Observable<JsonLongDocument> counter(String id, long delta, long initial, PersistTo persistTo, long timeout, TimeUnit timeUnit) {
        return this.counter(id, delta, initial, persistTo, ReplicateTo.NONE, timeout, timeUnit);
    }

    @Override
    public Observable<JsonLongDocument> counter(String id, long delta, long initial, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return this.counter(id, delta, initial, PersistTo.NONE, replicateTo, timeout, timeUnit);
    }

    @Override
    public Observable<JsonLongDocument> counter(String id, long delta, long initial, int expiry, PersistTo persistTo, long timeout, TimeUnit timeUnit) {
        return this.counter(id, delta, initial, expiry, persistTo, ReplicateTo.NONE, timeout, timeUnit);
    }

    @Override
    public Observable<JsonLongDocument> counter(String id, long delta, long initial, int expiry, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return this.counter(id, delta, initial, expiry, PersistTo.NONE, replicateTo, timeout, timeUnit);
    }

    @Override
    public Observable<JsonLongDocument> counter(String id, long delta, long initial, PersistTo persistTo, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return this.counter(id, delta, initial, 0, persistTo, replicateTo, timeout, timeUnit);
    }

    @Override
    public Observable<JsonLongDocument> counter(String id, long delta, PersistTo persistTo, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return this.counter(id, delta, 0L, -1, persistTo, replicateTo, timeout, timeUnit);
    }

    @Override
    public Observable<JsonLongDocument> counter(String id, long delta, long initial, int expiry, final PersistTo persistTo, final ReplicateTo replicateTo, final long timeout, final TimeUnit timeUnit) {
        if (persistTo == PersistTo.NONE && replicateTo == ReplicateTo.NONE) {
            return this.counter(id, delta, initial, expiry, timeout, timeUnit);
        }
        final Span parent = this.startTracing("counter_with_durability");
        return this.counter(id, delta, initial, expiry, parent, timeout, timeUnit).flatMap((Func1)new Func1<JsonLongDocument, Observable<JsonLongDocument>>(){

            public Observable<JsonLongDocument> call(final JsonLongDocument doc) {
                Observable or = Observe.call(CouchbaseAsyncBucket.this.core, CouchbaseAsyncBucket.this.bucket, doc.id(), doc.cas(), false, doc.mutationToken(), persistTo.value(), replicateTo.value(), CouchbaseAsyncBucket.this.environment.observeIntervalDelay(), CouchbaseAsyncBucket.this.environment.retryStrategy(), parent).map((Func1)new Func1<Boolean, JsonLongDocument>(){

                    public JsonLongDocument call(Boolean aBoolean) {
                        return doc;
                    }
                }).onErrorResumeNext((Func1)new Func1<Throwable, Observable<? extends JsonLongDocument>>(){

                    public Observable<? extends JsonLongDocument> call(Throwable throwable) {
                        return Observable.error((Throwable)new DurabilityException("Durability requirement failed: " + throwable.getMessage(), throwable));
                    }
                });
                return timeout > 0L ? or.timeout(timeout, timeUnit, CouchbaseAsyncBucket.this.environment.scheduler()) : or;
            }
        }).doOnTerminate(this.stopTracing(parent));
    }

    @Override
    public Observable<JsonLongDocument> counter(String id, long delta) {
        return this.counter(id, delta, 0L, (TimeUnit)null);
    }

    @Override
    public Observable<JsonLongDocument> counter(String id, long delta, PersistTo persistTo) {
        return this.counter(id, delta, persistTo, 0L, null);
    }

    @Override
    public Observable<JsonLongDocument> counter(String id, long delta, ReplicateTo replicateTo) {
        return this.counter(id, delta, replicateTo, 0L, null);
    }

    @Override
    public Observable<JsonLongDocument> counter(String id, long delta, PersistTo persistTo, ReplicateTo replicateTo) {
        return this.counter(id, delta, persistTo, replicateTo, 0L, null);
    }

    @Override
    public Observable<JsonLongDocument> counter(String id, long delta, long initial) {
        return this.counter(id, delta, initial, 0L, (TimeUnit)null);
    }

    @Override
    public Observable<JsonLongDocument> counter(String id, long delta, long initial, PersistTo persistTo) {
        return this.counter(id, delta, initial, persistTo, 0L, null);
    }

    @Override
    public Observable<JsonLongDocument> counter(String id, long delta, long initial, ReplicateTo replicateTo) {
        return this.counter(id, delta, initial, replicateTo, 0L, null);
    }

    @Override
    public Observable<JsonLongDocument> counter(String id, long delta, long initial, PersistTo persistTo, ReplicateTo replicateTo) {
        return this.counter(id, delta, initial, persistTo, replicateTo, 0L, null);
    }

    @Override
    public Observable<JsonLongDocument> counter(String id, long delta, long initial, int expiry) {
        return this.counter(id, delta, initial, expiry, 0L, null);
    }

    @Override
    public Observable<JsonLongDocument> counter(String id, long delta, long initial, int expiry, PersistTo persistTo) {
        return this.counter(id, delta, initial, expiry, persistTo, 0L, null);
    }

    @Override
    public Observable<JsonLongDocument> counter(String id, long delta, long initial, int expiry, ReplicateTo replicateTo) {
        return this.counter(id, delta, initial, expiry, replicateTo, 0L, null);
    }

    @Override
    public Observable<JsonLongDocument> counter(String id, long delta, long initial, int expiry, PersistTo persistTo, ReplicateTo replicateTo) {
        return this.counter(id, delta, initial, expiry, persistTo, replicateTo, 0L, null);
    }

    @Override
    public <D extends Document<?>> Observable<D> append(D document, PersistTo persistTo, long timeout, TimeUnit timeUnit) {
        return this.append(document, persistTo, ReplicateTo.NONE, timeout, timeUnit);
    }

    @Override
    public <D extends Document<?>> Observable<D> append(D document, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return this.append(document, PersistTo.NONE, replicateTo, timeout, timeUnit);
    }

    @Override
    public <D extends Document<?>> Observable<D> append(D document, final PersistTo persistTo, final ReplicateTo replicateTo, final long timeout, final TimeUnit timeUnit) {
        if (persistTo == PersistTo.NONE && replicateTo == ReplicateTo.NONE) {
            return this.append(document, timeout, timeUnit);
        }
        final Span parent = this.startTracing("append_with_durability");
        return this.append(document, parent, timeout, timeUnit).flatMap(new Func1<D, Observable<D>>(){

            public Observable<D> call(D doc) {
                Observable or = Observe.call(CouchbaseAsyncBucket.this.core, CouchbaseAsyncBucket.this.bucket, doc.id(), doc.cas(), false, doc.mutationToken(), persistTo.value(), replicateTo.value(), CouchbaseAsyncBucket.this.environment.observeIntervalDelay(), CouchbaseAsyncBucket.this.environment.retryStrategy(), parent).map(new Func1<Boolean, D>((Document)doc){
                    final /* synthetic */ Document val$doc;
                    {
                        this.val$doc = document;
                    }

                    public D call(Boolean aBoolean) {
                        return this.val$doc;
                    }
                }).onErrorResumeNext(new Func1<Throwable, Observable<? extends D>>(){

                    public Observable<? extends D> call(Throwable throwable) {
                        return Observable.error((Throwable)new DurabilityException("Durability requirement failed: " + throwable.getMessage(), throwable));
                    }
                });
                return timeout > 0L ? or.timeout(timeout, timeUnit, CouchbaseAsyncBucket.this.environment.scheduler()) : or;
            }
        }).doOnTerminate(this.stopTracing(parent));
    }

    @Override
    public <D extends Document<?>> Observable<D> prepend(D document, PersistTo persistTo, long timeout, TimeUnit timeUnit) {
        return this.prepend(document, persistTo, ReplicateTo.NONE, timeout, timeUnit);
    }

    @Override
    public <D extends Document<?>> Observable<D> prepend(D document, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return this.prepend(document, PersistTo.NONE, replicateTo, timeout, timeUnit);
    }

    @Override
    public <D extends Document<?>> Observable<D> prepend(D document, final PersistTo persistTo, final ReplicateTo replicateTo, final long timeout, final TimeUnit timeUnit) {
        if (persistTo == PersistTo.NONE && replicateTo == ReplicateTo.NONE) {
            return this.prepend(document, timeout, timeUnit);
        }
        final Span parent = this.startTracing("prepend_with_durability");
        return this.prepend(document, parent, timeout, timeUnit).flatMap(new Func1<D, Observable<D>>(){

            public Observable<D> call(D doc) {
                Observable or = Observe.call(CouchbaseAsyncBucket.this.core, CouchbaseAsyncBucket.this.bucket, doc.id(), doc.cas(), false, doc.mutationToken(), persistTo.value(), replicateTo.value(), CouchbaseAsyncBucket.this.environment.observeIntervalDelay(), CouchbaseAsyncBucket.this.environment.retryStrategy(), parent).map(new Func1<Boolean, D>((Document)doc){
                    final /* synthetic */ Document val$doc;
                    {
                        this.val$doc = document;
                    }

                    public D call(Boolean aBoolean) {
                        return this.val$doc;
                    }
                }).onErrorResumeNext(new Func1<Throwable, Observable<? extends D>>(){

                    public Observable<? extends D> call(Throwable throwable) {
                        return Observable.error((Throwable)new DurabilityException("Durability requirement failed: " + throwable.getMessage(), throwable));
                    }
                });
                return timeout > 0L ? or.timeout(timeout, timeUnit, CouchbaseAsyncBucket.this.environment.scheduler()) : or;
            }
        }).doOnTerminate(this.stopTracing(parent));
    }

    @Override
    public <D extends Document<?>> Observable<D> append(D document) {
        return this.append(document, 0L, null);
    }

    @Override
    public <D extends Document<?>> Observable<D> append(D document, PersistTo persistTo) {
        return this.append(document, persistTo, 0L, null);
    }

    @Override
    public <D extends Document<?>> Observable<D> append(D document, ReplicateTo replicateTo) {
        return this.append(document, replicateTo, 0L, null);
    }

    @Override
    public <D extends Document<?>> Observable<D> append(D document, PersistTo persistTo, ReplicateTo replicateTo) {
        return this.append(document, persistTo, replicateTo, 0L, null);
    }

    @Override
    public <D extends Document<?>> Observable<D> prepend(D document) {
        return this.prepend(document, 0L, null);
    }

    @Override
    public <D extends Document<?>> Observable<D> prepend(D document, PersistTo persistTo) {
        return this.prepend(document, persistTo, 0L, null);
    }

    @Override
    public <D extends Document<?>> Observable<D> prepend(D document, ReplicateTo replicateTo) {
        return this.prepend(document, replicateTo, 0L, null);
    }

    @Override
    public <D extends Document<?>> Observable<D> prepend(D document, PersistTo persistTo, ReplicateTo replicateTo) {
        return this.prepend(document, persistTo, replicateTo, 0L, null);
    }

    @Override
    public AsyncLookupInBuilder lookupIn(String docId) {
        return new AsyncLookupInBuilder(this.core, this.bucket, this.environment, this.subdocumentTranscoder, docId);
    }

    @Override
    public AsyncMutateInBuilder mutateIn(String docId) {
        return new AsyncMutateInBuilder(this.core, this.bucket, this.environment, this.subdocumentTranscoder, docId);
    }

    @Override
    public <V> Observable<V> mapGet(String docId, String key, Class<V> valueType) {
        Func1 mapResult = new Func1<DocumentFragment<Lookup>, V>(){

            public V call(DocumentFragment<Lookup> documentFragment) {
                ResponseStatus status = documentFragment.status(0);
                if (status == ResponseStatus.SUCCESS) {
                    return documentFragment.content(0);
                }
                if (status == ResponseStatus.SUBDOC_PATH_NOT_FOUND) {
                    throw new PathNotFoundException("Key not found in map");
                }
                throw new CouchbaseException(status.toString());
            }
        };
        return this.lookupIn(docId).get(key).execute().map(mapResult);
    }

    @Override
    public <V> Observable<Boolean> mapAdd(String docId, String key, V value) {
        return this.mapAdd(docId, key, value, MutationOptionBuilder.builder());
    }

    @Override
    public <V> Observable<Boolean> mapAdd(String docId, String key, V value, MutationOptionBuilder mutationOptionBuilder) {
        return this.mapSubdocAdd(docId, key, value, mutationOptionBuilder).map(ResultMappingUtils.getMapResultFnForSubdocMutationToBoolean());
    }

    private <V> Observable<DocumentFragment<Mutation>> mapSubdocAdd(final String docId, final String key, final V value, final MutationOptionBuilder mutationOptionBuilder) {
        final Mutation mutationOperation = Mutation.DICT_UPSERT;
        Func1<Throwable, Observable<? extends DocumentFragment<Mutation>>> retryAddIfDocExists = new Func1<Throwable, Observable<? extends DocumentFragment<Mutation>>>(){

            public Observable<? extends DocumentFragment<Mutation>> call(Throwable throwable) {
                if (throwable instanceof DocumentAlreadyExistsException) {
                    return CouchbaseAsyncBucket.this.mapSubdocAdd(docId, key, value, mutationOptionBuilder);
                }
                return Observable.error((Throwable)throwable);
            }
        };
        return this.mutateIn(docId).upsert(key, value).withCas(mutationOptionBuilder.cas()).withDurability(mutationOptionBuilder.persistTo(), mutationOptionBuilder.replicateTo()).withExpiry(mutationOptionBuilder.expiry()).execute().onErrorResumeNext((Func1)new Func1<Throwable, Observable<? extends DocumentFragment<Mutation>>>((Func1)retryAddIfDocExists){
            final /* synthetic */ Func1 val$retryAddIfDocExists;
            {
                this.val$retryAddIfDocExists = func1;
            }

            public Observable<? extends DocumentFragment<Mutation>> call(Throwable throwable) {
                if (throwable instanceof DocumentDoesNotExistException) {
                    if (mutationOptionBuilder.createDocument()) {
                        return CouchbaseAsyncBucket.this.insert(JsonDocument.create(docId, mutationOptionBuilder.expiry(), JsonObject.create().put(key, value)), mutationOptionBuilder.persistTo(), mutationOptionBuilder.replicateTo()).map(ResultMappingUtils.getMapFullDocResultToSubDocFn(mutationOperation)).onErrorResumeNext(this.val$retryAddIfDocExists);
                    }
                    return Observable.error((Throwable)throwable);
                }
                if (throwable instanceof MultiMutationException) {
                    ResponseStatus status = ((MultiMutationException)throwable).firstFailureStatus();
                    return Observable.just(ResultMappingUtils.convertToSubDocumentResult(status, mutationOperation, value));
                }
                return Observable.error((Throwable)throwable);
            }
        });
    }

    @Override
    public Observable<Boolean> mapRemove(String docId, String key) {
        return this.mapRemove(docId, key, MutationOptionBuilder.builder());
    }

    @Override
    public Observable<Boolean> mapRemove(String docId, String key, MutationOptionBuilder mutationOptionBuilder) {
        Func1<Throwable, Observable<? extends Boolean>> handleSubdocException = new Func1<Throwable, Observable<? extends Boolean>>(){

            public Observable<? extends Boolean> call(Throwable throwable) {
                ResponseStatus status = ((MultiMutationException)throwable).firstFailureStatus();
                if (status == ResponseStatus.SUBDOC_PATH_NOT_FOUND) {
                    return Observable.just((Object)true);
                }
                throw new CouchbaseException(status.toString());
            }
        };
        return this.mutateIn(docId).remove(key).withCas(mutationOptionBuilder.cas()).withDurability(mutationOptionBuilder.persistTo(), mutationOptionBuilder.replicateTo()).withExpiry(mutationOptionBuilder.expiry()).execute().map(ResultMappingUtils.getMapResultFnForSubdocMutationToBoolean()).onErrorResumeNext((Func1)handleSubdocException);
    }

    @Override
    public Observable<Integer> mapSize(String docId) {
        return this.get(docId, JsonDocument.class).toList().map((Func1)new Func1<List<JsonDocument>, Integer>(){

            public Integer call(List<JsonDocument> documents) {
                if (documents.size() == 0) {
                    throw new DocumentDoesNotExistException();
                }
                return ((JsonObject)documents.get(0).content()).size();
            }
        });
    }

    @Override
    public <E> Observable<E> listGet(String docId, int index, Class<E> elementType) {
        Func1 mapResult = new Func1<DocumentFragment<Lookup>, E>(){

            public E call(DocumentFragment<Lookup> documentFragment) {
                ResponseStatus status = documentFragment.status(0);
                if (status == ResponseStatus.SUCCESS) {
                    return documentFragment.content(0);
                }
                if (status == ResponseStatus.SUBDOC_PATH_NOT_FOUND) {
                    throw new PathNotFoundException("Index not found in list");
                }
                throw new CouchbaseException(status.toString());
            }
        };
        return this.lookupIn(docId).get("[" + index + "]").execute().map(mapResult);
    }

    @Override
    public <E> Observable<Boolean> listAppend(String docId, E element) {
        return this.listAppend(docId, element, MutationOptionBuilder.builder());
    }

    @Override
    public <E> Observable<Boolean> listAppend(String docId, E element, MutationOptionBuilder mutationOptionBuilder) {
        return this.listSubdocPushLast(docId, element, mutationOptionBuilder).map(ResultMappingUtils.getMapResultFnForSubdocMutationToBoolean());
    }

    private <E> Observable<DocumentFragment<Mutation>> listSubdocPushLast(final String docId, final E element, final MutationOptionBuilder mutationOptionBuilder) {
        final Mutation mutationOperation = Mutation.ARRAY_PUSH_LAST;
        Func1<Throwable, Observable<? extends DocumentFragment<Mutation>>> retryIfDocExists = new Func1<Throwable, Observable<? extends DocumentFragment<Mutation>>>(){

            public Observable<? extends DocumentFragment<Mutation>> call(Throwable throwable) {
                if (throwable instanceof DocumentAlreadyExistsException) {
                    return CouchbaseAsyncBucket.this.listSubdocPushLast(docId, element, mutationOptionBuilder);
                }
                return Observable.error((Throwable)throwable);
            }
        };
        return this.mutateIn(docId).arrayAppend("", element).withCas(mutationOptionBuilder.cas()).withDurability(mutationOptionBuilder.persistTo(), mutationOptionBuilder.replicateTo()).withExpiry(mutationOptionBuilder.expiry()).execute().onErrorResumeNext((Func1)new Func1<Throwable, Observable<? extends DocumentFragment<Mutation>>>((Func1)retryIfDocExists){
            final /* synthetic */ Func1 val$retryIfDocExists;
            {
                this.val$retryIfDocExists = func1;
            }

            public Observable<? extends DocumentFragment<Mutation>> call(Throwable throwable) {
                if (throwable instanceof DocumentDoesNotExistException) {
                    if (mutationOptionBuilder.createDocument()) {
                        return CouchbaseAsyncBucket.this.insert(JsonArrayDocument.create(docId, mutationOptionBuilder.expiry(), JsonArray.create().add(element)), mutationOptionBuilder.persistTo(), mutationOptionBuilder.replicateTo()).map(ResultMappingUtils.getMapFullArrayDocResultToSubDocFn(mutationOperation)).onErrorResumeNext(this.val$retryIfDocExists);
                    }
                    return Observable.error((Throwable)throwable);
                }
                if (throwable instanceof MultiMutationException) {
                    ResponseStatus status = ((MultiMutationException)throwable).firstFailureStatus();
                    return Observable.just(ResultMappingUtils.convertToSubDocumentResult(status, mutationOperation, element));
                }
                return Observable.error((Throwable)throwable);
            }
        });
    }

    @Override
    public Observable<Boolean> listRemove(String docId, int index) {
        return this.listRemove(docId, index, MutationOptionBuilder.builder());
    }

    @Override
    public Observable<Boolean> listRemove(String docId, int index, MutationOptionBuilder mutationOptionBuilder) {
        return this.listSubdocRemove(docId, index, mutationOptionBuilder).map(ResultMappingUtils.getMapResultFnForSubdocMutationToBoolean());
    }

    private Observable<DocumentFragment<Mutation>> listSubdocRemove(String docId, int index, MutationOptionBuilder mutationOptionBuilder) {
        return this.mutateIn(docId).remove("[" + index + "]").withCas(mutationOptionBuilder.cas()).withExpiry(mutationOptionBuilder.expiry()).withDurability(mutationOptionBuilder.persistTo(), mutationOptionBuilder.replicateTo()).execute();
    }

    @Override
    public <E> Observable<Boolean> listSet(String docId, int index, E element) {
        return this.listSet(docId, index, element, MutationOptionBuilder.builder());
    }

    @Override
    public <E> Observable<Boolean> listSet(String docId, int index, E element, MutationOptionBuilder mutationOptionBuilder) {
        return this.listSubdocInsert(docId, index, element, mutationOptionBuilder).map(ResultMappingUtils.getMapResultFnForSubdocMutationToBoolean());
    }

    private <E> Observable<DocumentFragment<Mutation>> listSubdocInsert(final String docId, final int index, final E element, final MutationOptionBuilder mutationOptionBuilder) {
        final Mutation mutationOperation = Mutation.ARRAY_INSERT;
        Func1<Throwable, Observable<? extends DocumentFragment<Mutation>>> retryIfDocExists = new Func1<Throwable, Observable<? extends DocumentFragment<Mutation>>>(){

            public Observable<? extends DocumentFragment<Mutation>> call(Throwable throwable) {
                if (throwable instanceof DocumentAlreadyExistsException) {
                    return CouchbaseAsyncBucket.this.listSubdocInsert(docId, index, element, mutationOptionBuilder);
                }
                return Observable.error((Throwable)throwable);
            }
        };
        return this.mutateIn(docId).arrayInsert("[" + index + "]", element).withCas(mutationOptionBuilder.cas()).withDurability(mutationOptionBuilder.persistTo(), mutationOptionBuilder.replicateTo()).withExpiry(mutationOptionBuilder.expiry()).execute().onErrorResumeNext((Func1)new Func1<Throwable, Observable<? extends DocumentFragment<Mutation>>>((Func1)retryIfDocExists){
            final /* synthetic */ Func1 val$retryIfDocExists;
            {
                this.val$retryIfDocExists = func1;
            }

            public Observable<? extends DocumentFragment<Mutation>> call(Throwable throwable) {
                if (throwable instanceof DocumentDoesNotExistException) {
                    if (mutationOptionBuilder.createDocument()) {
                        return CouchbaseAsyncBucket.this.insert(JsonArrayDocument.create(docId, mutationOptionBuilder.expiry(), JsonArray.create().add(element)), mutationOptionBuilder.persistTo(), mutationOptionBuilder.replicateTo()).map(ResultMappingUtils.getMapFullArrayDocResultToSubDocFn(mutationOperation)).onErrorResumeNext(this.val$retryIfDocExists);
                    }
                    return Observable.error((Throwable)throwable);
                }
                if (throwable instanceof MultiMutationException) {
                    ResponseStatus status = ((MultiMutationException)throwable).firstFailureStatus();
                    return Observable.just(ResultMappingUtils.convertToSubDocumentResult(status, mutationOperation, element));
                }
                return Observable.error((Throwable)throwable);
            }
        });
    }

    @Override
    public <E> Observable<Boolean> listPrepend(String docId, E element) {
        return this.listPrepend(docId, element, MutationOptionBuilder.builder());
    }

    @Override
    public <E> Observable<Boolean> listPrepend(String docId, E element, MutationOptionBuilder mutationOptionBuilder) {
        return this.listSubdocPushFirst(docId, element, mutationOptionBuilder).map(ResultMappingUtils.getMapResultFnForSubdocMutationToBoolean());
    }

    private <E> Observable<DocumentFragment<Mutation>> listSubdocPushFirst(final String docId, final E element, final MutationOptionBuilder mutationOptionBuilder) {
        final Mutation mutationOperation = Mutation.ARRAY_PUSH_FIRST;
        Func1<Throwable, Observable<? extends DocumentFragment<Mutation>>> retryIfDocExists = new Func1<Throwable, Observable<? extends DocumentFragment<Mutation>>>(){

            public Observable<? extends DocumentFragment<Mutation>> call(Throwable throwable) {
                return CouchbaseAsyncBucket.this.listSubdocPushFirst(docId, element, mutationOptionBuilder);
            }
        };
        return this.mutateIn(docId).arrayPrepend("", element).withCas(mutationOptionBuilder.cas()).withDurability(mutationOptionBuilder.persistTo(), mutationOptionBuilder.replicateTo()).withExpiry(mutationOptionBuilder.expiry()).execute().onErrorResumeNext((Func1)new Func1<Throwable, Observable<? extends DocumentFragment<Mutation>>>((Func1)retryIfDocExists){
            final /* synthetic */ Func1 val$retryIfDocExists;
            {
                this.val$retryIfDocExists = func1;
            }

            public Observable<? extends DocumentFragment<Mutation>> call(Throwable throwable) {
                if (throwable instanceof DocumentDoesNotExistException) {
                    if (mutationOptionBuilder.createDocument()) {
                        return CouchbaseAsyncBucket.this.insert(JsonArrayDocument.create(docId, mutationOptionBuilder.expiry(), JsonArray.create().add(element)), mutationOptionBuilder.persistTo(), mutationOptionBuilder.replicateTo()).map(ResultMappingUtils.getMapFullArrayDocResultToSubDocFn(mutationOperation)).onErrorResumeNext(this.val$retryIfDocExists);
                    }
                    return Observable.error((Throwable)throwable);
                }
                if (throwable instanceof MultiMutationException) {
                    ResponseStatus status = ((MultiMutationException)throwable).firstFailureStatus();
                    return Observable.just(ResultMappingUtils.convertToSubDocumentResult(status, mutationOperation, element));
                }
                return Observable.error((Throwable)throwable);
            }
        });
    }

    @Override
    public Observable<Integer> listSize(String docId) {
        return this.get(docId, JsonArrayDocument.class).toList().map((Func1)new Func1<List<JsonArrayDocument>, Integer>(){

            public Integer call(List<JsonArrayDocument> documents) {
                if (documents.size() == 0) {
                    throw new DocumentDoesNotExistException();
                }
                return ((JsonArray)documents.get(0).content()).size();
            }
        });
    }

    @Override
    public <E> Observable<Boolean> setAdd(String docId, E element) {
        return this.setAdd(docId, element, MutationOptionBuilder.builder());
    }

    @Override
    public <E> Observable<Boolean> setAdd(String docId, E element, MutationOptionBuilder mutationOptionBuilder) {
        Func1<DocumentFragment<Mutation>, Boolean> mapResult = new Func1<DocumentFragment<Mutation>, Boolean>(){

            public Boolean call(DocumentFragment<Mutation> documentFragment) {
                ResponseStatus status = documentFragment.status(0);
                if (status == ResponseStatus.SUCCESS) {
                    return true;
                }
                if (status == ResponseStatus.SUBDOC_PATH_EXISTS) {
                    return false;
                }
                throw new CouchbaseException(status.toString());
            }
        };
        return this.setSubdocAddUnique(docId, element, mutationOptionBuilder).map((Func1)mapResult);
    }

    private <E> Observable<DocumentFragment<Mutation>> setSubdocAddUnique(final String docId, final E element, final MutationOptionBuilder mutationOptionBuilder) {
        final Mutation mutationOperation = Mutation.ARRAY_ADD_UNIQUE;
        Func1<Throwable, Observable<? extends DocumentFragment<Mutation>>> retryIfDocExists = new Func1<Throwable, Observable<? extends DocumentFragment<Mutation>>>(){

            public Observable<? extends DocumentFragment<Mutation>> call(Throwable throwable) {
                if (throwable instanceof DocumentAlreadyExistsException) {
                    return CouchbaseAsyncBucket.this.setSubdocAddUnique(docId, element, mutationOptionBuilder);
                }
                return Observable.error((Throwable)throwable);
            }
        };
        return this.mutateIn(docId).arrayAddUnique("", element).withCas(mutationOptionBuilder.cas()).withDurability(mutationOptionBuilder.persistTo(), mutationOptionBuilder.replicateTo()).withExpiry(mutationOptionBuilder.expiry()).execute().onErrorResumeNext((Func1)new Func1<Throwable, Observable<? extends DocumentFragment<Mutation>>>((Func1)retryIfDocExists){
            final /* synthetic */ Func1 val$retryIfDocExists;
            {
                this.val$retryIfDocExists = func1;
            }

            public Observable<? extends DocumentFragment<Mutation>> call(Throwable throwable) {
                if (throwable instanceof DocumentDoesNotExistException) {
                    if (mutationOptionBuilder.createDocument()) {
                        return CouchbaseAsyncBucket.this.insert(JsonArrayDocument.create(docId, mutationOptionBuilder.expiry(), JsonArray.create().add(element)), mutationOptionBuilder.persistTo(), mutationOptionBuilder.replicateTo()).map(ResultMappingUtils.getMapFullArrayDocResultToSubDocFn(mutationOperation)).onErrorResumeNext(this.val$retryIfDocExists);
                    }
                    return Observable.error((Throwable)throwable);
                }
                if (throwable instanceof MultiMutationException) {
                    ResponseStatus status = ((MultiMutationException)throwable).firstFailureStatus();
                    return Observable.just(ResultMappingUtils.convertToSubDocumentResult(status, mutationOperation, element));
                }
                return Observable.error((Throwable)throwable);
            }
        });
    }

    @Override
    public <E> Observable<Boolean> setContains(String docId, final E element) {
        return this.get(docId, JsonArrayDocument.class).toList().map((Func1)new Func1<List<JsonArrayDocument>, Boolean>(){

            public Boolean call(List<JsonArrayDocument> documents) {
                if (documents.size() == 0) {
                    throw new DocumentDoesNotExistException();
                }
                JsonArrayDocument document = documents.get(0);
                JsonArray jsonArray = (JsonArray)document.content();
                for (Object next : jsonArray) {
                    if (next == null && element == null) {
                        return true;
                    }
                    if (next == null || !next.equals(element)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    public <E> Observable<E> setRemove(String docId, E element) {
        return this.setRemove(docId, element, MutationOptionBuilder.builder());
    }

    @Override
    public <E> Observable<E> setRemove(String docId, E element, MutationOptionBuilder mutationOptionBuilder) {
        return this.setSubdocRemove(docId, element, mutationOptionBuilder, MAX_CAS_RETRIES_DATASTRUCTURES);
    }

    private <E> Observable<E> setSubdocRemove(final String docId, final E element, final MutationOptionBuilder mutationOptionBuilder, final int retryCount) {
        final Mutation mutationOperation = Mutation.DELETE;
        if (retryCount <= 0) {
            return Observable.error((Throwable)new CASMismatchException());
        }
        return this.get(docId, JsonArrayDocument.class).toList().flatMap(new Func1<List<JsonArrayDocument>, Observable<E>>(){

            public Observable<E> call(List<JsonArrayDocument> documents) {
                if (documents.size() == 0) {
                    throw new DocumentDoesNotExistException();
                }
                JsonArrayDocument jsonArrayDocument = documents.get(0);
                Iterator<Object> iterator = ((JsonArray)jsonArrayDocument.content()).iterator();
                int ii = 0;
                int index = -1;
                while (iterator.hasNext()) {
                    Object next = iterator.next();
                    if (next == null && element == null) {
                        index = ii;
                        break;
                    }
                    if (next != null && next.equals(element)) {
                        index = ii;
                        break;
                    }
                    ++ii;
                }
                if (index == -1) {
                    return Observable.just((Object)element);
                }
                Func1<Throwable, Observable<? extends DocumentFragment<Mutation>>> handleCASMismatch = new Func1<Throwable, Observable<? extends DocumentFragment<Mutation>>>(){

                    public Observable<? extends DocumentFragment<Mutation>> call(Throwable throwable) {
                        if (throwable instanceof CASMismatchException) {
                            return CouchbaseAsyncBucket.this.setSubdocRemove(docId, element, mutationOptionBuilder, retryCount - 1).map(new Func1<E, DocumentFragment<Mutation>>(){

                                public DocumentFragment<Mutation> call(E element) {
                                    return ResultMappingUtils.convertToSubDocumentResult(ResponseStatus.SUCCESS, mutationOperation, element);
                                }
                            });
                        }
                        return Observable.error((Throwable)throwable);
                    }
                };
                return CouchbaseAsyncBucket.this.mutateIn(docId).remove("[" + index + "]").withCas(jsonArrayDocument.cas()).withExpiry(mutationOptionBuilder.expiry()).withDurability(mutationOptionBuilder.persistTo(), mutationOptionBuilder.replicateTo()).execute().onErrorResumeNext((Func1)handleCASMismatch).map(new Func1<DocumentFragment<Mutation>, E>(){

                    public E call(DocumentFragment<Mutation> documentFragment) {
                        ResponseStatus status = documentFragment.status(0);
                        if (status == ResponseStatus.SUCCESS) {
                            return element;
                        }
                        if (status == ResponseStatus.SUBDOC_PATH_NOT_FOUND || status == ResponseStatus.SUBDOC_PATH_INVALID) {
                            return element;
                        }
                        throw new CouchbaseException(status.toString());
                    }
                });
            }
        });
    }

    @Override
    public Observable<Integer> setSize(String docId) {
        return this.get(docId, JsonArrayDocument.class).toList().map((Func1)new Func1<List<JsonArrayDocument>, Integer>(){

            public Integer call(List<JsonArrayDocument> documents) {
                if (documents.size() == 0) {
                    throw new DocumentDoesNotExistException();
                }
                return ((JsonArray)documents.get(0).content()).size();
            }
        });
    }

    @Override
    public <E> Observable<Boolean> queuePush(String docId, E element) {
        return this.queuePush(docId, element, MutationOptionBuilder.builder());
    }

    @Override
    public <E> Observable<Boolean> queuePush(String docId, E element, MutationOptionBuilder mutationOptionBuilder) {
        return this.queueSubdocAddFirst(docId, element, mutationOptionBuilder).map(ResultMappingUtils.getMapResultFnForSubdocMutationToBoolean());
    }

    private <E> Observable<DocumentFragment<Mutation>> queueSubdocAddFirst(final String docId, final E element, final MutationOptionBuilder mutationOptionBuilder) {
        final Mutation mutationOperation = Mutation.ARRAY_PUSH_FIRST;
        Func1<Throwable, Observable<? extends DocumentFragment<Mutation>>> retryIfDocExists = new Func1<Throwable, Observable<? extends DocumentFragment<Mutation>>>(){

            public Observable<? extends DocumentFragment<Mutation>> call(Throwable throwable) {
                if (throwable instanceof DocumentAlreadyExistsException) {
                    return CouchbaseAsyncBucket.this.queueSubdocAddFirst(docId, element, mutationOptionBuilder);
                }
                return Observable.error((Throwable)throwable);
            }
        };
        return this.mutateIn(docId).arrayPrepend("", element).withCas(mutationOptionBuilder.cas()).withDurability(mutationOptionBuilder.persistTo(), mutationOptionBuilder.replicateTo()).withExpiry(mutationOptionBuilder.expiry()).execute().onErrorResumeNext((Func1)new Func1<Throwable, Observable<? extends DocumentFragment<Mutation>>>((Func1)retryIfDocExists){
            final /* synthetic */ Func1 val$retryIfDocExists;
            {
                this.val$retryIfDocExists = func1;
            }

            public Observable<? extends DocumentFragment<Mutation>> call(Throwable throwable) {
                if (throwable instanceof DocumentDoesNotExistException) {
                    if (mutationOptionBuilder.createDocument()) {
                        return CouchbaseAsyncBucket.this.insert(JsonArrayDocument.create(docId, mutationOptionBuilder.expiry(), JsonArray.create().add(element)), mutationOptionBuilder.persistTo(), mutationOptionBuilder.replicateTo()).map(ResultMappingUtils.getMapFullArrayDocResultToSubDocFn(mutationOperation)).onErrorResumeNext(this.val$retryIfDocExists);
                    }
                    return Observable.error((Throwable)throwable);
                }
                if (throwable instanceof MultiMutationException) {
                    ResponseStatus status = ((MultiMutationException)throwable).firstFailureStatus();
                    return Observable.just(ResultMappingUtils.convertToSubDocumentResult(status, mutationOperation, element));
                }
                return Observable.error((Throwable)throwable);
            }
        });
    }

    @Override
    public <E> Observable<E> queuePop(String docId, Class<E> elementType) {
        return this.queuePop(docId, elementType, MutationOptionBuilder.builder());
    }

    @Override
    public <E> Observable<E> queuePop(String docId, Class<E> elementType, MutationOptionBuilder mutationOptionBuilder) {
        return this.queueSubdocRemove(docId, mutationOptionBuilder, elementType, MAX_CAS_RETRIES_DATASTRUCTURES);
    }

    private <E> Observable<E> queueSubdocRemove(final String docId, final MutationOptionBuilder mutationOptionBuilder, final Class<E> elementType, final int retryCount) {
        if (retryCount <= 0) {
            return Observable.error((Throwable)new CASMismatchException());
        }
        final Mutation mutationOperation = Mutation.DELETE;
        int index = -1;
        return this.lookupIn(docId).get("[-1]").execute().flatMap(new Func1<DocumentFragment<Lookup>, Observable<E>>(){

            public Observable<E> call(DocumentFragment<Lookup> documentFragment) {
                long cas = documentFragment.cas();
                if (mutationOptionBuilder.cas() != 0L && cas != mutationOptionBuilder.cas()) {
                    throw new CASMismatchException();
                }
                final Object val = documentFragment.content(0);
                Func1<Throwable, Observable<? extends DocumentFragment<Mutation>>> handleCASMismatch = new Func1<Throwable, Observable<? extends DocumentFragment<Mutation>>>(){

                    public Observable<? extends DocumentFragment<Mutation>> call(Throwable throwable) {
                        if (throwable instanceof CASMismatchException) {
                            return CouchbaseAsyncBucket.this.queueSubdocRemove(docId, mutationOptionBuilder, elementType, retryCount - 1).map(new Func1<E, DocumentFragment<Mutation>>(){

                                public DocumentFragment<Mutation> call(E element) {
                                    if (element == null) {
                                        throw new CASMismatchException();
                                    }
                                    return ResultMappingUtils.convertToSubDocumentResult(ResponseStatus.SUCCESS, mutationOperation, element);
                                }
                            });
                        }
                        if (throwable.getCause() instanceof PathNotFoundException) {
                            return Observable.just(ResultMappingUtils.convertToSubDocumentResult(ResponseStatus.NOT_EXISTS, mutationOperation, null));
                        }
                        return Observable.error((Throwable)throwable);
                    }
                };
                return CouchbaseAsyncBucket.this.mutateIn(docId).remove("[-1]").withCas(cas).withExpiry(mutationOptionBuilder.expiry()).withDurability(mutationOptionBuilder.persistTo(), mutationOptionBuilder.replicateTo()).execute().onErrorResumeNext((Func1)handleCASMismatch).map(new Func1<DocumentFragment<Mutation>, E>(){

                    public E call(DocumentFragment<Mutation> documentFragment) {
                        ResponseStatus status = documentFragment.status(0);
                        if (status == ResponseStatus.SUCCESS) {
                            if (documentFragment.content(0) != null) {
                                return documentFragment.content(0);
                            }
                            return val;
                        }
                        if (status == ResponseStatus.NOT_EXISTS) {
                            return null;
                        }
                        throw new CouchbaseException(status.toString());
                    }
                });
            }
        });
    }

    @Override
    public Observable<Integer> queueSize(String docId) {
        return this.get(docId, JsonArrayDocument.class).toList().map((Func1)new Func1<List<JsonArrayDocument>, Integer>(){

            public Integer call(List<JsonArrayDocument> documents) {
                if (documents.size() == 0) {
                    throw new DocumentDoesNotExistException();
                }
                return ((JsonArray)documents.get(0).content()).size();
            }
        });
    }

    @Override
    public Observable<Boolean> close() {
        return Observable.defer((Func0)new Func0<Observable<CloseBucketResponse>>(){

            public Observable<CloseBucketResponse> call() {
                return CouchbaseAsyncBucket.this.core.send(new CloseBucketRequest(CouchbaseAsyncBucket.this.bucket));
            }
        }).map((Func1)new Func1<CloseBucketResponse, Boolean>(){

            public Boolean call(CloseBucketResponse response) {
                CouchbaseAsyncBucket.this.closed = true;
                return response.status().isSuccess();
            }
        });
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public String toString() {
        return "AsyncBucket[" + this.name() + "]";
    }

    @Override
    public Observable<Integer> invalidateQueryCache() {
        return Observable.just((Object)this.n1qlQueryExecutor.invalidateQueryCache());
    }

    @Override
    public Single<PingReport> ping(String reportId, long timeout, TimeUnit timeUnit) {
        return HealthPinger.ping(this.environment, this.bucket, this.password, this.core, reportId, timeout, timeUnit, new ServiceType[0]);
    }

    @Override
    public Single<PingReport> ping(long timeout, TimeUnit timeUnit) {
        return HealthPinger.ping(this.environment, this.bucket, this.password, this.core, null, timeout, timeUnit, new ServiceType[0]);
    }

    @Override
    public Single<PingReport> ping(Collection<ServiceType> services, long timeout, TimeUnit timeUnit) {
        return HealthPinger.ping(this.environment, this.bucket, this.password, this.core, null, timeout, timeUnit, services.toArray(new ServiceType[services.size()]));
    }

    @Override
    public Single<PingReport> ping(String reportId, Collection<ServiceType> services, long timeout, TimeUnit timeUnit) {
        return HealthPinger.ping(this.environment, this.bucket, this.password, this.core, reportId, timeout, timeUnit, services.toArray(new ServiceType[services.size()]));
    }

    private Span startTracing(String spanName) {
        if (!this.environment.operationTracingEnabled()) {
            return null;
        }
        Scope scope = this.environment.tracer().buildSpan(spanName).startActive(false);
        Span parent = scope.span();
        scope.close();
        return parent;
    }

    private Action0 stopTracing(final Span parent) {
        return new Action0(){

            public void call() {
                if (parent != null) {
                    CouchbaseAsyncBucket.this.environment.tracer().scopeManager().activate(parent, true).close();
                }
            }
        };
    }

    private static <X extends CouchbaseException, R extends CouchbaseResponse> X addDetails(X ex, R r) {
        return Utils.addDetails(ex, r);
    }
}

