/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.transcoder.subdoc;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.deps.com.fasterxml.jackson.databind.ObjectMapper;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.java.error.TranscodingException;
import com.couchbase.client.java.transcoder.TranscoderUtils;
import com.couchbase.client.java.transcoder.subdoc.AbstractByteArrayFragmentTranscoder;
import java.io.IOException;
import java.io.OutputStream;

@InterfaceStability.Uncommitted
@InterfaceAudience.Private
public class JacksonFragmentTranscoder
extends AbstractByteArrayFragmentTranscoder {
    private final ObjectMapper mapper;

    public JacksonFragmentTranscoder(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public <T> T decodeWithMessage(ByteBuf encoded, Class<? extends T> clazz, String transcodingErrorMessage) throws TranscodingException {
        try {
            if (Object.class.equals(clazz)) {
                return (T)TranscoderUtils.byteBufToGenericObject(encoded, this.mapper);
            }
            return TranscoderUtils.byteBufToClass(encoded, clazz, this.mapper);
        }
        catch (IOException e) {
            throw new TranscodingException(transcodingErrorMessage, e);
        }
    }

    @Override
    protected Object byteArrayToGenericObject(byte[] byteArray, int offset, int length) throws IOException {
        throw new UnsupportedOperationException("byteArrayToGenericObject is unused by custom decodeWithMessage");
    }

    @Override
    protected <T> T byteArrayToClass(byte[] byteArray, int offset, int length, Class<? extends T> clazz) throws IOException {
        throw new UnsupportedOperationException("byteArrayToClass is unused by custom decodeWithMessage");
    }

    @Override
    protected <T> byte[] writeValueAsBytes(T value) throws IOException {
        return this.mapper.writeValueAsBytes(value);
    }

    @Override
    protected void writeValueIntoStream(OutputStream out, Object o) throws IOException {
        this.mapper.writeValue(out, o);
    }
}

