/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.cluster;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.core.CouchbaseException;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.config.BucketsConfigRequest;
import com.couchbase.client.core.message.config.BucketsConfigResponse;
import com.couchbase.client.core.message.config.ClusterConfigRequest;
import com.couchbase.client.core.message.config.ClusterConfigResponse;
import com.couchbase.client.core.message.config.GetUsersRequest;
import com.couchbase.client.core.message.config.GetUsersResponse;
import com.couchbase.client.core.message.config.InsertBucketRequest;
import com.couchbase.client.core.message.config.InsertBucketResponse;
import com.couchbase.client.core.message.config.RemoveBucketRequest;
import com.couchbase.client.core.message.config.RemoveBucketResponse;
import com.couchbase.client.core.message.config.RemoveUserRequest;
import com.couchbase.client.core.message.config.RemoveUserResponse;
import com.couchbase.client.core.message.config.UpdateBucketRequest;
import com.couchbase.client.core.message.config.UpdateBucketResponse;
import com.couchbase.client.core.message.config.UpsertUserRequest;
import com.couchbase.client.core.message.config.UpsertUserResponse;
import com.couchbase.client.core.message.internal.AddNodeRequest;
import com.couchbase.client.core.message.internal.AddNodeResponse;
import com.couchbase.client.core.message.internal.AddServiceRequest;
import com.couchbase.client.core.message.internal.AddServiceResponse;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.time.Delay;
import com.couchbase.client.core.utils.ConnectionString;
import com.couchbase.client.core.utils.NetworkAddress;
import com.couchbase.client.java.CouchbaseAsyncBucket;
import com.couchbase.client.java.bucket.BucketType;
import com.couchbase.client.java.cluster.AsyncClusterManager;
import com.couchbase.client.java.cluster.AuthDomain;
import com.couchbase.client.java.cluster.BucketSettings;
import com.couchbase.client.java.cluster.ClusterInfo;
import com.couchbase.client.java.cluster.CompressionMode;
import com.couchbase.client.java.cluster.DefaultBucketSettings;
import com.couchbase.client.java.cluster.DefaultClusterInfo;
import com.couchbase.client.java.cluster.EjectionMethod;
import com.couchbase.client.java.cluster.User;
import com.couchbase.client.java.cluster.UserRole;
import com.couchbase.client.java.cluster.UserSettings;
import com.couchbase.client.java.cluster.api.AsyncClusterApiClient;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.error.BucketAlreadyExistsException;
import com.couchbase.client.java.error.BucketDoesNotExistException;
import com.couchbase.client.java.error.InvalidPasswordException;
import com.couchbase.client.java.error.TranscodingException;
import com.couchbase.client.java.util.OnSubscribeDeferAndWatch;
import com.couchbase.client.java.util.retry.RetryBuilder;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Action1;
import rx.functions.Func1;

public class DefaultAsyncClusterManager
implements AsyncClusterManager {
    final ClusterFacade core;
    final String username;
    final String password;
    final CouchbaseEnvironment environment;
    private final ConnectionString connectionString;

    DefaultAsyncClusterManager(String username, String password, ConnectionString connectionString, CouchbaseEnvironment environment, ClusterFacade core) {
        this.username = username;
        this.password = password;
        this.core = core;
        this.environment = environment;
        this.connectionString = connectionString;
    }

    public static DefaultAsyncClusterManager create(String username, String password, ConnectionString connectionString, CouchbaseEnvironment environment, ClusterFacade core) {
        return new DefaultAsyncClusterManager(username, password, connectionString, environment, core);
    }

    @Override
    @InterfaceStability.Experimental
    public Observable<AsyncClusterApiClient> apiClient() {
        return this.ensureServiceEnabled().map((Func1)new Func1<Boolean, AsyncClusterApiClient>(){

            public AsyncClusterApiClient call(Boolean aBoolean) {
                return new AsyncClusterApiClient(DefaultAsyncClusterManager.this.username, DefaultAsyncClusterManager.this.password, DefaultAsyncClusterManager.this.core);
            }
        });
    }

    @Override
    public Observable<ClusterInfo> info() {
        return this.ensureServiceEnabled().flatMap((Func1)new Func1<Boolean, Observable<ClusterConfigResponse>>(){

            public Observable<ClusterConfigResponse> call(Boolean aBoolean) {
                return OnSubscribeDeferAndWatch.deferAndWatch(new Func1<Subscriber, Observable<? extends ClusterConfigResponse>>(){

                    public Observable<? extends ClusterConfigResponse> call(Subscriber subscriber) {
                        ClusterConfigRequest request = new ClusterConfigRequest(DefaultAsyncClusterManager.this.username, DefaultAsyncClusterManager.this.password);
                        request.subscriber(subscriber);
                        return DefaultAsyncClusterManager.this.core.send((CouchbaseRequest)request);
                    }
                });
            }
        }).retryWhen((Func1)RetryBuilder.any().delay(Delay.fixed((long)100L, (TimeUnit)TimeUnit.MILLISECONDS)).max(Integer.MAX_VALUE).build()).doOnNext((Action1)new Action1<ClusterConfigResponse>(){

            public void call(ClusterConfigResponse response) {
                if (!response.status().isSuccess()) {
                    if (response.config().contains("Unauthorized")) {
                        throw new InvalidPasswordException();
                    }
                    throw new CouchbaseException(response.status() + ": " + response.config());
                }
            }
        }).map((Func1)new Func1<ClusterConfigResponse, ClusterInfo>(){

            public ClusterInfo call(ClusterConfigResponse response) {
                try {
                    return new DefaultClusterInfo(CouchbaseAsyncBucket.JSON_OBJECT_TRANSCODER.stringToJsonObject(response.config()));
                }
                catch (Exception e) {
                    throw new TranscodingException("Could not decode cluster info.", e);
                }
            }
        });
    }

    @Override
    public Observable<BucketSettings> getBuckets() {
        return this.ensureServiceEnabled().flatMap((Func1)new Func1<Boolean, Observable<BucketsConfigResponse>>(){

            public Observable<BucketsConfigResponse> call(Boolean aBoolean) {
                return OnSubscribeDeferAndWatch.deferAndWatch(new Func1<Subscriber, Observable<? extends BucketsConfigResponse>>(){

                    public Observable<? extends BucketsConfigResponse> call(Subscriber subscriber) {
                        BucketsConfigRequest request = new BucketsConfigRequest(DefaultAsyncClusterManager.this.username, DefaultAsyncClusterManager.this.password);
                        request.subscriber(subscriber);
                        return DefaultAsyncClusterManager.this.core.send((CouchbaseRequest)request);
                    }
                });
            }
        }).retryWhen((Func1)RetryBuilder.any().delay(Delay.fixed((long)100L, (TimeUnit)TimeUnit.MILLISECONDS)).max(Integer.MAX_VALUE).build()).doOnNext((Action1)new Action1<BucketsConfigResponse>(){

            public void call(BucketsConfigResponse response) {
                if (!response.status().isSuccess()) {
                    if (response.config().contains("Unauthorized")) {
                        throw new InvalidPasswordException();
                    }
                    throw new CouchbaseException(response.status() + ": " + response.config());
                }
            }
        }).flatMap((Func1)new Func1<BucketsConfigResponse, Observable<BucketSettings>>(){

            public Observable<BucketSettings> call(BucketsConfigResponse response) {
                try {
                    JsonArray decoded = CouchbaseAsyncBucket.JSON_ARRAY_TRANSCODER.stringToJsonArray(response.config());
                    ArrayList<DefaultBucketSettings> settings = new ArrayList<DefaultBucketSettings>();
                    for (Object item : decoded) {
                        JsonObject bucket = (JsonObject)item;
                        JsonObject controllers = bucket.getObject("controllers");
                        boolean enableFlush = controllers != null && controllers.getString("flush") != null;
                        Boolean replicaIndex = bucket.getBoolean("replicaIndex");
                        boolean indexReplicas = replicaIndex != null ? replicaIndex : false;
                        int ramQuota = 0;
                        ramQuota = bucket.getObject("quota").get("ram") instanceof Long ? (int)(bucket.getObject("quota").getLong("ram") / 1024L / 1024L) : bucket.getObject("quota").getInt("ram") / 1024 / 1024;
                        String rawType = bucket.getString("bucketType");
                        BucketType bucketType = "membase".equalsIgnoreCase(rawType) ? BucketType.COUCHBASE : ("ephemeral".equalsIgnoreCase(rawType) ? BucketType.EPHEMERAL : BucketType.MEMCACHED);
                        CompressionMode compressionMode = null;
                        String rawCompressionMode = bucket.getString("compressionMode");
                        if (rawCompressionMode != null && !rawCompressionMode.isEmpty()) {
                            compressionMode = "off".equalsIgnoreCase(rawCompressionMode) ? CompressionMode.OFF : ("active".equalsIgnoreCase(rawCompressionMode) ? CompressionMode.ACTIVE : CompressionMode.PASSIVE);
                        }
                        EjectionMethod ejectionMethod = EjectionMethod.VALUE;
                        String rawEjectionMethod = bucket.getString("evictionPolicy");
                        if (rawEjectionMethod != null && !rawEjectionMethod.isEmpty() && "fullEviction".equalsIgnoreCase(rawEjectionMethod)) {
                            ejectionMethod = EjectionMethod.FULL;
                        }
                        settings.add(DefaultBucketSettings.builder().name(bucket.getString("name")).enableFlush(enableFlush).type(bucketType).replicas(bucket.getInt("replicaNumber")).quota(ramQuota).indexReplicas(indexReplicas).port(bucket.getInt("proxyPort")).password(bucket.getString("saslPassword")).compressionMode(compressionMode).ejectionMethod(ejectionMethod).build(bucket));
                    }
                    return Observable.from(settings);
                }
                catch (Exception e) {
                    throw new TranscodingException("Could not decode cluster info.", e);
                }
            }
        });
    }

    @Override
    public Observable<BucketSettings> getBucket(final String name) {
        return this.getBuckets().filter((Func1)new Func1<BucketSettings, Boolean>(){

            public Boolean call(BucketSettings bucketSettings) {
                return bucketSettings.name().equals(name);
            }
        });
    }

    @Override
    public Observable<Boolean> hasBucket(String name) {
        return this.getBucket(name).isEmpty().map((Func1)new Func1<Boolean, Boolean>(){

            public Boolean call(Boolean notFound) {
                return notFound == false;
            }
        });
    }

    @Override
    public Observable<Boolean> removeBucket(final String name) {
        return this.ensureServiceEnabled().flatMap((Func1)new Func1<Boolean, Observable<RemoveBucketResponse>>(){

            public Observable<RemoveBucketResponse> call(Boolean aBoolean) {
                return OnSubscribeDeferAndWatch.deferAndWatch(new Func1<Subscriber, Observable<? extends RemoveBucketResponse>>(){

                    public Observable<? extends RemoveBucketResponse> call(Subscriber subscriber) {
                        RemoveBucketRequest request = new RemoveBucketRequest(name, DefaultAsyncClusterManager.this.username, DefaultAsyncClusterManager.this.password);
                        request.subscriber(subscriber);
                        return DefaultAsyncClusterManager.this.core.send((CouchbaseRequest)request);
                    }
                });
            }
        }).retryWhen((Func1)RetryBuilder.any().delay(Delay.fixed((long)100L, (TimeUnit)TimeUnit.MILLISECONDS)).max(Integer.MAX_VALUE).build()).map((Func1)new Func1<RemoveBucketResponse, Boolean>(){

            public Boolean call(RemoveBucketResponse response) {
                return response.status().isSuccess();
            }
        });
    }

    @Override
    public Observable<BucketSettings> insertBucket(final BucketSettings settings) {
        final String payload = this.getConfigureBucketPayload(settings, true);
        return this.ensureBucketIsHealthy((Observable<BucketSettings>)this.hasBucket(settings.name()).doOnNext((Action1)new Action1<Boolean>(){

            public void call(Boolean exists) {
                if (exists.booleanValue()) {
                    throw new BucketAlreadyExistsException("Bucket " + settings.name() + " already exists!");
                }
            }
        }).flatMap((Func1)new Func1<Boolean, Observable<InsertBucketResponse>>(){

            public Observable<InsertBucketResponse> call(Boolean exists) {
                return OnSubscribeDeferAndWatch.deferAndWatch(new Func1<Subscriber, Observable<? extends InsertBucketResponse>>(){

                    public Observable<? extends InsertBucketResponse> call(Subscriber subscriber) {
                        InsertBucketRequest request = new InsertBucketRequest(payload, DefaultAsyncClusterManager.this.username, DefaultAsyncClusterManager.this.password);
                        request.subscriber(subscriber);
                        return DefaultAsyncClusterManager.this.core.send((CouchbaseRequest)request);
                    }
                });
            }
        }).retryWhen((Func1)RetryBuilder.any().delay(Delay.fixed((long)100L, (TimeUnit)TimeUnit.MILLISECONDS)).max(Integer.MAX_VALUE).build()).map((Func1)new Func1<InsertBucketResponse, BucketSettings>(){

            public BucketSettings call(InsertBucketResponse response) {
                if (!response.status().isSuccess()) {
                    throw new CouchbaseException("Could not insert bucket: " + response.config());
                }
                return settings;
            }
        }));
    }

    @Override
    public Observable<BucketSettings> updateBucket(final BucketSettings settings) {
        final String payload = this.getConfigureBucketPayload(settings, false);
        return this.ensureBucketIsHealthy((Observable<BucketSettings>)this.hasBucket(settings.name()).doOnNext((Action1)new Action1<Boolean>(){

            public void call(Boolean exists) {
                if (!exists.booleanValue()) {
                    throw new BucketDoesNotExistException("Bucket " + settings.name() + " does not exist!");
                }
            }
        }).flatMap((Func1)new Func1<Boolean, Observable<UpdateBucketResponse>>(){

            public Observable<UpdateBucketResponse> call(Boolean exists) {
                return OnSubscribeDeferAndWatch.deferAndWatch(new Func1<Subscriber, Observable<? extends UpdateBucketResponse>>(){

                    public Observable<? extends UpdateBucketResponse> call(Subscriber subscriber) {
                        UpdateBucketRequest request = new UpdateBucketRequest(settings.name(), payload, DefaultAsyncClusterManager.this.username, DefaultAsyncClusterManager.this.password);
                        request.subscriber(subscriber);
                        return DefaultAsyncClusterManager.this.core.send((CouchbaseRequest)request);
                    }
                });
            }
        }).retryWhen((Func1)RetryBuilder.any().delay(Delay.fixed((long)100L, (TimeUnit)TimeUnit.MILLISECONDS)).max(Integer.MAX_VALUE).build()).map((Func1)new Func1<UpdateBucketResponse, BucketSettings>(){

            public BucketSettings call(UpdateBucketResponse response) {
                if (!response.status().isSuccess()) {
                    throw new CouchbaseException("Could not update bucket: " + response.config());
                }
                return settings;
            }
        }));
    }

    @Override
    public Observable<Boolean> upsertUser(final AuthDomain domain, final String userid, UserSettings userSettings) {
        final String payload = this.getUserSettingsPayload(userSettings);
        return this.ensureServiceEnabled().flatMap((Func1)new Func1<Boolean, Observable<UpsertUserResponse>>(){

            public Observable<UpsertUserResponse> call(Boolean aBoolean) {
                return OnSubscribeDeferAndWatch.deferAndWatch(new Func1<Subscriber, Observable<? extends UpsertUserResponse>>(){

                    public Observable<? extends UpsertUserResponse> call(Subscriber subscriber) {
                        UpsertUserRequest request = new UpsertUserRequest(DefaultAsyncClusterManager.this.username, DefaultAsyncClusterManager.this.password, domain.alias(), userid, payload);
                        request.subscriber(subscriber);
                        return DefaultAsyncClusterManager.this.core.send((CouchbaseRequest)request);
                    }
                });
            }
        }).retryWhen((Func1)RetryBuilder.any().delay(Delay.fixed((long)100L, (TimeUnit)TimeUnit.MILLISECONDS)).max(Integer.MAX_VALUE).build()).map((Func1)new Func1<UpsertUserResponse, Boolean>(){

            public Boolean call(UpsertUserResponse response) {
                if (!response.status().isSuccess()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Could not update user: ");
                    sb.append(response.status());
                    if (response.message().length() > 0) {
                        sb.append(", ");
                        sb.append("msg: ");
                        sb.append(response.message());
                    }
                    throw new CouchbaseException(sb.toString());
                }
                return true;
            }
        });
    }

    @Override
    public Observable<Boolean> removeUser(final AuthDomain domain, final String userid) {
        return this.ensureServiceEnabled().flatMap((Func1)new Func1<Boolean, Observable<RemoveUserResponse>>(){

            public Observable<RemoveUserResponse> call(Boolean aBoolean) {
                return OnSubscribeDeferAndWatch.deferAndWatch(new Func1<Subscriber, Observable<? extends RemoveUserResponse>>(){

                    public Observable<? extends RemoveUserResponse> call(Subscriber subscriber) {
                        RemoveUserRequest request = new RemoveUserRequest(DefaultAsyncClusterManager.this.username, DefaultAsyncClusterManager.this.password, domain.alias(), userid);
                        request.subscriber(subscriber);
                        return DefaultAsyncClusterManager.this.core.send((CouchbaseRequest)request);
                    }
                });
            }
        }).retryWhen((Func1)RetryBuilder.any().delay(Delay.fixed((long)100L, (TimeUnit)TimeUnit.MILLISECONDS)).max(Integer.MAX_VALUE).build()).map((Func1)new Func1<RemoveUserResponse, Boolean>(){

            public Boolean call(RemoveUserResponse response) {
                return response.status().isSuccess();
            }
        });
    }

    @Override
    public Observable<User> getUsers(AuthDomain domain) {
        return this.getUser(domain, null);
    }

    @Override
    public Observable<User> getUser(final AuthDomain domain, final String userid) {
        return this.ensureServiceEnabled().flatMap((Func1)new Func1<Boolean, Observable<GetUsersResponse>>(){

            public Observable<GetUsersResponse> call(Boolean aBoolean) {
                final GetUsersRequest request = userid == null || userid.isEmpty() ? GetUsersRequest.usersFromDomain((String)DefaultAsyncClusterManager.this.username, (String)DefaultAsyncClusterManager.this.password, (String)domain.alias()) : GetUsersRequest.user((String)DefaultAsyncClusterManager.this.username, (String)DefaultAsyncClusterManager.this.password, (String)domain.alias(), (String)userid);
                return OnSubscribeDeferAndWatch.deferAndWatch(new Func1<Subscriber, Observable<? extends GetUsersResponse>>(){

                    public Observable<? extends GetUsersResponse> call(Subscriber subscriber) {
                        request.subscriber(subscriber);
                        return DefaultAsyncClusterManager.this.core.send((CouchbaseRequest)request);
                    }
                });
            }
        }).retryWhen((Func1)RetryBuilder.any().delay(Delay.fixed((long)100L, (TimeUnit)TimeUnit.MILLISECONDS)).max(Integer.MAX_VALUE).build()).doOnNext((Action1)new Action1<GetUsersResponse>(){

            public void call(GetUsersResponse response) {
                if (!response.status().isSuccess()) {
                    if (response.content().contains("Unauthorized")) {
                        throw new InvalidPasswordException();
                    }
                    throw new CouchbaseException(response.status() + ": " + response.content());
                }
            }
        }).flatMap((Func1)new Func1<GetUsersResponse, Observable<User>>(){

            public Observable<User> call(GetUsersResponse response) {
                try {
                    if (userid != null && !userid.isEmpty()) {
                        JsonObject decoded = CouchbaseAsyncBucket.JSON_OBJECT_TRANSCODER.stringToJsonObject(response.content());
                        JsonArray rolesJsonArr = decoded.getArray("roles");
                        UserRole[] userRoles = new UserRole[rolesJsonArr.size()];
                        int i = 0;
                        for (Object role : rolesJsonArr) {
                            userRoles[i] = new UserRole(((JsonObject)role).getString("role"), ((JsonObject)role).getString("bucket_name"));
                            ++i;
                        }
                        User user = new User(decoded.getString("name"), decoded.getString("id"), AuthDomain.fromAlias(decoded.getString("domain")), userRoles);
                        return Observable.just((Object)user);
                    }
                    JsonArray decoded = CouchbaseAsyncBucket.JSON_ARRAY_TRANSCODER.stringToJsonArray(response.content());
                    ArrayList<User> users = new ArrayList<User>();
                    for (Object item : decoded) {
                        JsonObject userJsonObj = (JsonObject)item;
                        JsonArray rolesJsonArr = userJsonObj.getArray("roles");
                        UserRole[] userRoles = new UserRole[rolesJsonArr.size()];
                        int i = 0;
                        for (Object role : rolesJsonArr) {
                            userRoles[i] = new UserRole(((JsonObject)role).getString("role"), ((JsonObject)role).getString("bucket_name"));
                            ++i;
                        }
                        User user = new User(userJsonObj.getString("name"), userJsonObj.getString("id"), AuthDomain.fromAlias(userJsonObj.getString("domain")), userRoles);
                        users.add(user);
                    }
                    return Observable.from(users);
                }
                catch (Exception e) {
                    throw new TranscodingException("Could not decode user info.", e);
                }
            }
        });
    }

    protected String getConfigureBucketPayload(BucketSettings settings, boolean includeName) {
        String bucketType;
        Map<String, Object> customSettings = settings.customSettings();
        LinkedHashMap<String, Object> actual = new LinkedHashMap<String, Object>(8 + customSettings.size());
        if (includeName) {
            actual.put("name", settings.name());
        }
        actual.put("ramQuotaMB", settings.quota());
        actual.put("authType", "sasl");
        if (settings.password() != null && !settings.password().isEmpty()) {
            actual.put("saslPassword", settings.password());
        }
        actual.put("replicaNumber", settings.replicas());
        if (settings.port() > 0) {
            actual.put("proxyPort", settings.port());
        }
        if (settings.compressionMode() != null) {
            String compressionMode;
            switch (settings.compressionMode()) {
                case OFF: {
                    compressionMode = "off";
                    break;
                }
                case ACTIVE: {
                    compressionMode = "active";
                    break;
                }
                case PASSIVE: {
                    compressionMode = "passive";
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Could not convert compression mode " + (Object)((Object)settings.compressionMode()));
                }
            }
            actual.put("compressionMode", compressionMode);
        }
        if (settings.ejectionMethod() != null && settings.ejectionMethod() == EjectionMethod.FULL) {
            actual.put("evictionPolicy", "fullEviction");
        }
        switch (settings.type()) {
            case COUCHBASE: {
                bucketType = "membase";
                break;
            }
            case MEMCACHED: {
                bucketType = "memcached";
                break;
            }
            case EPHEMERAL: {
                bucketType = "ephemeral";
                break;
            }
            default: {
                throw new UnsupportedOperationException("Could not convert bucket type " + (Object)((Object)settings.type()));
            }
        }
        actual.put("bucketType", bucketType);
        actual.put("flushEnabled", settings.enableFlush() ? "1" : "0");
        for (Map.Entry<String, Object> customSetting : customSettings.entrySet()) {
            if (actual.containsKey(customSetting.getKey()) || !includeName && "name".equals(customSetting.getKey())) continue;
            actual.put(customSetting.getKey(), customSetting.getValue());
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry setting : actual.entrySet()) {
            sb.append('&').append((String)setting.getKey()).append('=').append(setting.getValue());
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    protected String getUserSettingsPayload(UserSettings settings) {
        StringBuilder sb;
        LinkedHashMap<String, String> settingsMap = new LinkedHashMap<String, String>();
        if (settings.name() != null) {
            settingsMap.put("name", settings.name());
        }
        if (settings.password() != null) {
            settingsMap.put("password", settings.password());
        }
        if (settings.roles() != null && settings.roles().size() > 0) {
            sb = new StringBuilder();
            for (UserRole userRole : settings.roles()) {
                if (sb.length() != 0) {
                    sb.append(",");
                }
                sb.append(userRole.role());
                if (userRole.bucket() == null || userRole.bucket().equals("")) continue;
                sb.append("[");
                sb.append(userRole.bucket().replace("%", "%25"));
                sb.append("]");
            }
            settingsMap.put("roles", sb.toString());
        }
        sb = new StringBuilder();
        for (Map.Entry entry : settingsMap.entrySet()) {
            sb.append('&').append((String)entry.getKey()).append('=').append(entry.getValue());
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    private Observable<BucketSettings> ensureBucketIsHealthy(Observable<BucketSettings> input) {
        return input.flatMap((Func1)new Func1<BucketSettings, Observable<BucketSettings>>(){

            public Observable<BucketSettings> call(final BucketSettings bucketSettings) {
                return DefaultAsyncClusterManager.this.info().delay(100L, TimeUnit.MILLISECONDS).filter((Func1)new Func1<ClusterInfo, Boolean>(){

                    public Boolean call(ClusterInfo clusterInfo) {
                        boolean allHealthy = true;
                        for (Object n : clusterInfo.raw().getArray("nodes")) {
                            JsonObject node = (JsonObject)n;
                            if (node.getString("status").equals("healthy")) continue;
                            allHealthy = false;
                            break;
                        }
                        return allHealthy;
                    }
                }).repeat().take(1).flatMap((Func1)new Func1<ClusterInfo, Observable<BucketSettings>>(){

                    public Observable<BucketSettings> call(ClusterInfo clusterInfo) {
                        return Observable.just((Object)bucketSettings);
                    }
                });
            }
        });
    }

    Observable<Boolean> sendAddNodeRequest(InetSocketAddress address) {
        final NetworkAddress networkAddress = NetworkAddress.create((String)address.getAddress().getHostAddress());
        return this.core.send((CouchbaseRequest)new AddNodeRequest(networkAddress)).flatMap((Func1)new Func1<AddNodeResponse, Observable<AddServiceResponse>>(){

            public Observable<AddServiceResponse> call(AddNodeResponse addNodeResponse) {
                if (!addNodeResponse.status().isSuccess()) {
                    throw new CouchbaseException("Could not enable ClusterManager service to function properly.");
                }
                int port = DefaultAsyncClusterManager.this.environment.sslEnabled() ? DefaultAsyncClusterManager.this.environment.bootstrapHttpSslPort() : DefaultAsyncClusterManager.this.environment.bootstrapHttpDirectPort();
                return DefaultAsyncClusterManager.this.core.send((CouchbaseRequest)new AddServiceRequest(ServiceType.CONFIG, DefaultAsyncClusterManager.this.username, DefaultAsyncClusterManager.this.password, port, networkAddress));
            }
        }).map((Func1)new Func1<AddServiceResponse, Boolean>(){

            public Boolean call(AddServiceResponse addServiceResponse) {
                if (!addServiceResponse.status().isSuccess()) {
                    throw new CouchbaseException("Could not enable ClusterManager service to function properly.");
                }
                return true;
            }
        });
    }

    private Observable<Boolean> ensureServiceEnabled() {
        if (this.connectionString.hosts().isEmpty()) {
            return Observable.error((Throwable)new IllegalStateException("No host found in the connection string! " + this.connectionString.toString()));
        }
        final AtomicInteger integer = new AtomicInteger(0);
        return Observable.just((Object)this.connectionString.hosts()).flatMap((Func1)new Func1<List<InetSocketAddress>, Observable<Boolean>>(){

            public Observable<Boolean> call(List<InetSocketAddress> inetSocketAddresses) {
                int hostIndex = integer.getAndIncrement();
                if (hostIndex >= DefaultAsyncClusterManager.this.connectionString.hosts().size()) {
                    integer.set(0);
                    return Observable.error((Throwable)new CouchbaseException("Could not enable ClusterManager service to function properly."));
                }
                return DefaultAsyncClusterManager.this.sendAddNodeRequest(inetSocketAddresses.get(hostIndex));
            }
        });
    }
}

