/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.facet;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.search.facet.SearchFacet;
import com.couchbase.client.java.search.util.SearchUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@InterfaceStability.Experimental
@InterfaceAudience.Public
public class DateRangeFacet
extends SearchFacet {
    private final Map<String, DateRange> dateRanges = new HashMap<String, DateRange>();

    DateRangeFacet(String field, int limit) {
        super(field, limit);
    }

    protected void checkRange(String name, String start, String end) {
        if (name == null) {
            throw new NullPointerException("Cannot create date range without a name");
        }
        if (start == null && end == null) {
            throw new NullPointerException("Cannot create date range without start nor end");
        }
    }

    public DateRangeFacet addRange(String rangeName, Date start, Date end) {
        return this.addRange(rangeName, SearchUtils.toFtsUtcString(start), SearchUtils.toFtsUtcString(end));
    }

    public DateRangeFacet addRange(String rangeName, String start, String end) {
        this.checkRange(rangeName, start, end);
        this.dateRanges.put(rangeName, new DateRange(start, end));
        return this;
    }

    @Override
    public void injectParams(JsonObject queryJson) {
        super.injectParams(queryJson);
        JsonArray dateRange = JsonArray.empty();
        for (Map.Entry<String, DateRange> dr : this.dateRanges.entrySet()) {
            JsonObject drJson = JsonObject.create();
            drJson.put("name", dr.getKey());
            if (dr.getValue().start != null) {
                drJson.put("start", dr.getValue().start);
            }
            if (dr.getValue().end != null) {
                drJson.put("end", dr.getValue().end);
            }
            dateRange.add(drJson);
        }
        queryJson.put("date_ranges", dateRange);
    }

    private static class DateRange {
        public final String start;
        public final String end;

        public DateRange(String start, String end) {
            this.start = start;
            this.end = end;
        }
    }
}

