/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.query;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.MutationState;
import com.couchbase.client.java.auth.Credential;
import com.couchbase.client.java.document.Document;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.document.json.JsonValue;
import com.couchbase.client.java.query.consistency.ScanConsistency;
import com.couchbase.client.java.subdoc.DocumentFragment;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@InterfaceStability.Committed
@InterfaceAudience.Public
public class N1qlParams
implements Serializable {
    private static final long serialVersionUID = 8888370260267213831L;
    private String serverSideTimeout;
    private ScanConsistency consistency;
    private String scanWait;
    private String clientContextId;
    private Integer maxParallelism;
    private boolean disableMetrics = false;
    private MutationState mutationState;
    private Map<String, Object> rawParams;
    private boolean pretty = true;
    private final Map<String, String> credentials = new HashMap<String, String>();
    private boolean adhoc = true;

    private N1qlParams() {
    }

    public void injectParams(JsonObject queryJson) {
        if (this.serverSideTimeout != null) {
            queryJson.put("timeout", this.serverSideTimeout);
        }
        if (this.consistency != null) {
            queryJson.put("scan_consistency", this.consistency.n1ql());
        }
        if (this.scanWait != null && (ScanConsistency.REQUEST_PLUS == this.consistency || ScanConsistency.STATEMENT_PLUS == this.consistency)) {
            queryJson.put("scan_wait", this.scanWait);
        }
        if (this.clientContextId != null) {
            queryJson.put("client_context_id", this.clientContextId);
        }
        if (this.maxParallelism != null) {
            queryJson.put("max_parallelism", this.maxParallelism.toString());
        }
        if (this.disableMetrics) {
            queryJson.put("metrics", false);
        }
        if (this.mutationState != null) {
            if (this.consistency != null) {
                throw new IllegalArgumentException("`consistency(...)` cannot be used together with `consistentWith(...)`");
            }
            queryJson.put("scan_vectors", this.mutationState.export());
            queryJson.put("scan_consistency", "at_plus");
        }
        if (!this.credentials.isEmpty()) {
            JsonArray creds = JsonArray.create();
            for (Map.Entry<String, String> c : this.credentials.entrySet()) {
                creds.add(JsonObject.create().put("user", c.getKey()).put("pass", c.getValue()));
            }
            queryJson.put("creds", creds);
        }
        if (!this.pretty) {
            queryJson.put("pretty", false);
        }
        if (this.rawParams != null) {
            for (Map.Entry<String, Object> entry : this.rawParams.entrySet()) {
                queryJson.put(entry.getKey(), entry.getValue());
            }
        }
    }

    private static String durationToN1qlFormat(long duration, TimeUnit unit) {
        switch (unit) {
            case NANOSECONDS: {
                return duration + "ns";
            }
            case MICROSECONDS: {
                return duration + "us";
            }
            case MILLISECONDS: {
                return duration + "ms";
            }
            case SECONDS: {
                return duration + "s";
            }
            case MINUTES: {
                return duration + "m";
            }
            case HOURS: {
                return duration + "h";
            }
        }
        return unit.toHours(duration) + "h";
    }

    public static N1qlParams build() {
        return new N1qlParams();
    }

    public N1qlParams serverSideTimeout(long timeout, TimeUnit unit) {
        this.serverSideTimeout = N1qlParams.durationToN1qlFormat(timeout, unit);
        return this;
    }

    public N1qlParams withContextId(String clientContextId) {
        this.clientContextId = clientContextId;
        return this;
    }

    public N1qlParams disableMetrics(boolean disableMetrics) {
        this.disableMetrics = disableMetrics;
        return this;
    }

    public N1qlParams consistency(ScanConsistency consistency) {
        this.consistency = consistency;
        if (consistency == ScanConsistency.NOT_BOUNDED) {
            this.scanWait = null;
        }
        return this;
    }

    @InterfaceStability.Committed
    public N1qlParams consistentWith(Document ... documents) {
        return this.consistentWith(MutationState.from(documents));
    }

    @InterfaceStability.Committed
    public N1qlParams consistentWith(DocumentFragment ... fragments) {
        return this.consistentWith(MutationState.from(fragments));
    }

    @InterfaceStability.Committed
    public N1qlParams consistentWith(MutationState mutationState) {
        this.mutationState = mutationState;
        return this;
    }

    public N1qlParams scanWait(long wait, TimeUnit unit) {
        this.scanWait = this.consistency == ScanConsistency.NOT_BOUNDED ? null : N1qlParams.durationToN1qlFormat(wait, unit);
        return this;
    }

    public N1qlParams maxParallelism(int maxParallelism) {
        this.maxParallelism = maxParallelism;
        return this;
    }

    public N1qlParams adhoc(boolean adhoc) {
        this.adhoc = adhoc;
        return this;
    }

    public N1qlParams withCredentials(List<Credential> credentials) {
        for (Credential credential : credentials) {
            this.withCredentials(credential.login(), credential.password());
        }
        return this;
    }

    public N1qlParams withCredentials(String login, String password) {
        this.credentials.put(login, password);
        return this;
    }

    public N1qlParams pretty(boolean pretty) {
        this.pretty = pretty;
        return this;
    }

    @InterfaceStability.Uncommitted
    public N1qlParams rawParam(String name, Object value) {
        if (this.rawParams == null) {
            this.rawParams = new HashMap<String, Object>();
        }
        if (!JsonValue.checkType(value)) {
            throw new IllegalArgumentException("Only JSON types are supported.");
        }
        this.rawParams.put(name, value);
        return this;
    }

    public boolean hasServerSideTimeout() {
        return this.serverSideTimeout != null;
    }

    public boolean isAdhoc() {
        return this.adhoc;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        N1qlParams that = (N1qlParams)o;
        if (this.disableMetrics != that.disableMetrics) {
            return false;
        }
        if (this.adhoc != that.adhoc) {
            return false;
        }
        if (this.pretty != that.pretty) {
            return false;
        }
        if (this.serverSideTimeout != null ? !this.serverSideTimeout.equals(that.serverSideTimeout) : that.serverSideTimeout != null) {
            return false;
        }
        if (this.consistency != that.consistency) {
            return false;
        }
        if (this.scanWait != null ? !this.scanWait.equals(that.scanWait) : that.scanWait != null) {
            return false;
        }
        if (this.clientContextId != null ? !this.clientContextId.equals(that.clientContextId) : that.clientContextId != null) {
            return false;
        }
        if (this.maxParallelism != null ? !this.maxParallelism.equals(that.maxParallelism) : that.maxParallelism != null) {
            return false;
        }
        if (this.mutationState != null ? !this.mutationState.equals(that.mutationState) : that.mutationState != null) {
            return false;
        }
        if (!this.credentials.equals(that.credentials)) {
            return false;
        }
        return this.rawParams != null ? this.rawParams.equals(that.rawParams) : that.rawParams == null;
    }

    public int hashCode() {
        int result = this.serverSideTimeout != null ? this.serverSideTimeout.hashCode() : 0;
        result = 31 * result + (this.consistency != null ? this.consistency.hashCode() : 0);
        result = 31 * result + (this.scanWait != null ? this.scanWait.hashCode() : 0);
        result = 31 * result + (this.clientContextId != null ? this.clientContextId.hashCode() : 0);
        result = 31 * result + (this.maxParallelism != null ? this.maxParallelism.hashCode() : 0);
        result = 31 * result + (this.disableMetrics ? 1 : 0);
        result = 31 * result + (this.mutationState != null ? this.mutationState.hashCode() : 0);
        result = 31 * result + this.credentials.hashCode();
        result = 31 * result + (this.rawParams != null ? this.rawParams.hashCode() : 0);
        result = 31 * result + (this.adhoc ? 1 : 0);
        result = 31 * result + (this.pretty ? 1 : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("N1qlParams{");
        sb.append("serverSideTimeout='").append(this.serverSideTimeout).append('\'');
        sb.append(", consistency=").append((Object)this.consistency);
        sb.append(", scanWait='").append(this.scanWait).append('\'');
        sb.append(", clientContextId='").append(this.clientContextId).append('\'');
        sb.append(", maxParallelism=").append(this.maxParallelism);
        sb.append(", adhoc=").append(this.adhoc);
        sb.append(", pretty=").append(this.pretty);
        sb.append(", disableMetrics=").append(this.disableMetrics);
        sb.append(", rawParams=").append(this.rawParams);
        if (!this.credentials.isEmpty()) {
            sb.append(", credentials=").append(this.credentials.size());
        }
        sb.append('}');
        return sb.toString();
    }
}

