/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.util.rawQuerying;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.utils.Blocking;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.query.N1qlQuery;
import com.couchbase.client.java.search.SearchQuery;
import com.couchbase.client.java.transcoder.TranscoderUtils;
import com.couchbase.client.java.util.rawQuerying.AsyncRawQueryExecutor;
import java.util.concurrent.TimeUnit;
import rx.functions.Func1;

@InterfaceStability.Uncommitted
@InterfaceAudience.Public
public class RawQueryExecutor {
    private final CouchbaseEnvironment env;
    private final AsyncRawQueryExecutor async;

    public RawQueryExecutor(AsyncRawQueryExecutor async, CouchbaseEnvironment env) {
        this.env = env;
        this.async = async;
    }

    public RawQueryExecutor(String bucket, String password, ClusterFacade core, CouchbaseEnvironment env) {
        this(new AsyncRawQueryExecutor(bucket, password, core), env);
    }

    public JsonObject n1qlToJsonObject(N1qlQuery query) {
        return (JsonObject)Blocking.blockForSingle(this.async.n1qlToJsonObject(query), (long)this.env.queryTimeout(), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public String n1qlToRawJson(N1qlQuery query) {
        return (String)Blocking.blockForSingle(this.async.n1qlToRawJson(query), (long)this.env.queryTimeout(), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public <T> T n1qlToRawCustom(N1qlQuery query, Func1<TranscoderUtils.ByteBufToArray, T> deserializer) {
        return (T)Blocking.blockForSingle(this.async.n1qlToRawCustom(query, deserializer), (long)this.env.queryTimeout(), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public JsonObject ftsToJsonObject(SearchQuery query) {
        return (JsonObject)Blocking.blockForSingle(this.async.ftsToJsonObject(query), (long)this.env.searchTimeout(), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public String ftsToRawJson(SearchQuery query) {
        return (String)Blocking.blockForSingle(this.async.ftsToRawJson(query), (long)this.env.searchTimeout(), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public <T> T ftsToRawCustom(SearchQuery query, Func1<String, T> deserializer) {
        return (T)Blocking.blockForSingle(this.async.ftsToRawCustom(query, deserializer), (long)this.env.searchTimeout(), (TimeUnit)TimeUnit.MILLISECONDS);
    }
}

