/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.auth;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.auth.Authenticator;
import com.couchbase.client.java.auth.Credential;
import com.couchbase.client.java.auth.CredentialContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@InterfaceStability.Committed
@InterfaceAudience.Private
public class ClassicAuthenticator
implements Authenticator {
    private Credential clusterManagementCredential = null;
    private Map<String, Credential> bucketCredentials = new HashMap<String, Credential>();

    @Override
    public List<Credential> getCredentials(CredentialContext context, String specific) {
        switch (context) {
            case BUCKET_KV: 
            case BUCKET_N1QL: 
            case BUCKET_FTS: 
            case BUCKET_ANALYTICS: 
            case BUCKET_VIEW: 
            case BUCKET_MANAGEMENT: {
                return this.bucketCredentialOrEmpty(specific);
            }
            case CLUSTER_MANAGEMENT: {
                return this.clusterManagementCredential == null ? Collections.emptyList() : Collections.singletonList(this.clusterManagementCredential);
            }
            case CLUSTER_FTS: 
            case CLUSTER_N1QL: 
            case CLUSTER_ANALYTICS: {
                return new ArrayList<Credential>(this.bucketCredentials.values());
            }
        }
        throw new IllegalArgumentException("Unsupported credential context " + (Object)((Object)context) + " for this Authenticator type");
    }

    private List<Credential> bucketCredentialOrEmpty(String specific) {
        Credential cred = this.bucketCredentials.get(specific);
        if (cred == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(cred);
    }

    @Override
    public boolean isEmpty() {
        return this.clusterManagementCredential == null && this.bucketCredentials.isEmpty();
    }

    public ClassicAuthenticator bucket(String bucketName, String password) {
        this.bucketCredentials.put(bucketName, new Credential(bucketName, password));
        return this;
    }

    public ClassicAuthenticator cluster(String adminName, String adminPassword) {
        this.clusterManagementCredential = new Credential(adminName, adminPassword);
        return this;
    }
}

