/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.java.AsyncBucket;
import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.CouchbaseAsyncBucket;
import com.couchbase.client.java.PersistTo;
import com.couchbase.client.java.ReplicaMode;
import com.couchbase.client.java.ReplicateTo;
import com.couchbase.client.java.analytics.AnalyticsQuery;
import com.couchbase.client.java.analytics.AnalyticsQueryExecutor;
import com.couchbase.client.java.analytics.AnalyticsQueryResult;
import com.couchbase.client.java.bucket.AsyncBucketManager;
import com.couchbase.client.java.bucket.BucketManager;
import com.couchbase.client.java.bucket.DefaultBucketManager;
import com.couchbase.client.java.datastructures.MutationOptionBuilder;
import com.couchbase.client.java.document.Document;
import com.couchbase.client.java.document.JsonDocument;
import com.couchbase.client.java.document.JsonLongDocument;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.query.N1qlQuery;
import com.couchbase.client.java.query.N1qlQueryResult;
import com.couchbase.client.java.query.Statement;
import com.couchbase.client.java.query.core.N1qlQueryExecutor;
import com.couchbase.client.java.repository.CouchbaseRepository;
import com.couchbase.client.java.repository.Repository;
import com.couchbase.client.java.search.SearchQuery;
import com.couchbase.client.java.search.result.SearchQueryResult;
import com.couchbase.client.java.search.result.impl.DefaultSearchQueryResult;
import com.couchbase.client.java.subdoc.AsyncLookupInBuilder;
import com.couchbase.client.java.subdoc.AsyncMutateInBuilder;
import com.couchbase.client.java.subdoc.LookupInBuilder;
import com.couchbase.client.java.subdoc.MutateInBuilder;
import com.couchbase.client.java.transcoder.Transcoder;
import com.couchbase.client.java.util.Blocking;
import com.couchbase.client.java.view.AsyncSpatialViewResult;
import com.couchbase.client.java.view.AsyncViewResult;
import com.couchbase.client.java.view.DefaultSpatialViewResult;
import com.couchbase.client.java.view.DefaultViewResult;
import com.couchbase.client.java.view.SpatialViewQuery;
import com.couchbase.client.java.view.SpatialViewResult;
import com.couchbase.client.java.view.ViewQuery;
import com.couchbase.client.java.view.ViewResult;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import rx.functions.Func1;

public class CouchbaseBucket
implements Bucket {
    private static final TimeUnit TIMEOUT_UNIT = TimeUnit.MILLISECONDS;
    private final AsyncBucket asyncBucket;
    private final CouchbaseEnvironment environment;
    private final long kvTimeout;
    private final String name;
    private final String password;
    private final ClusterFacade core;

    public CouchbaseBucket(CouchbaseEnvironment env, ClusterFacade core, String name, String password, List<Transcoder<? extends Document, ?>> customTranscoders) {
        this(new CouchbaseAsyncBucket(core, env, name, password, customTranscoders), env, core, name, password);
    }

    public CouchbaseBucket(AsyncBucket asyncBucket, CouchbaseEnvironment env, ClusterFacade core, String name, String password) {
        this.asyncBucket = asyncBucket;
        this.environment = env;
        this.kvTimeout = env.kvTimeout();
        this.name = name;
        this.password = password;
        this.core = core;
    }

    @Override
    public AsyncBucket async() {
        return this.asyncBucket;
    }

    @Override
    public String name() {
        return this.asyncBucket.name();
    }

    @Override
    public ClusterFacade core() {
        return (ClusterFacade)this.asyncBucket.core().toBlocking().single();
    }

    @Override
    public CouchbaseEnvironment environment() {
        return this.environment;
    }

    @Override
    public Repository repository() {
        return new CouchbaseRepository(this, this.environment);
    }

    @Override
    public JsonDocument get(String id) {
        return this.get(id, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public JsonDocument get(String id, long timeout, TimeUnit timeUnit) {
        return (JsonDocument)Blocking.blockForSingle(this.asyncBucket.get(id).singleOrDefault(null), timeout, timeUnit);
    }

    @Override
    public <D extends Document<?>> D get(D document) {
        return this.get(document, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D get(D document, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.get(document).singleOrDefault(null), timeout, timeUnit));
    }

    @Override
    public <D extends Document<?>> D get(String id, Class<D> target) {
        return this.get(id, target, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D get(String id, Class<D> target, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.get(id, target).singleOrDefault(null), timeout, timeUnit));
    }

    @Override
    public boolean exists(String id) {
        return this.exists(id, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public boolean exists(String id, long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncBucket.exists(id), timeout, timeUnit);
    }

    @Override
    public <D extends Document<?>> boolean exists(D document) {
        return this.exists(document.id());
    }

    @Override
    public <D extends Document<?>> boolean exists(D document, long timeout, TimeUnit timeUnit) {
        return this.exists(document.id(), timeout, timeUnit);
    }

    @Override
    public List<JsonDocument> getFromReplica(String id, ReplicaMode type) {
        return this.getFromReplica((Document)((Object)id), type, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public List<JsonDocument> getFromReplica(String id, ReplicaMode type, long timeout, TimeUnit timeUnit) {
        return (List)Blocking.blockForSingle(this.asyncBucket.getFromReplica(id, type).toList(), timeout, timeUnit);
    }

    @Override
    public <D extends Document<?>> List<D> getFromReplica(D document, ReplicaMode type) {
        return this.getFromReplica(document, type, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> List<D> getFromReplica(D document, ReplicaMode type, long timeout, TimeUnit timeUnit) {
        return (List)Blocking.blockForSingle(this.asyncBucket.getFromReplica(document, type).toList(), timeout, timeUnit);
    }

    @Override
    public <D extends Document<?>> List<D> getFromReplica(String id, ReplicaMode type, Class<D> target) {
        return this.getFromReplica(id, type, target, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> List<D> getFromReplica(String id, ReplicaMode type, Class<D> target, long timeout, TimeUnit timeUnit) {
        return (List)Blocking.blockForSingle(this.asyncBucket.getFromReplica(id, type, target).toList(), timeout, timeUnit);
    }

    @Override
    public Iterator<JsonDocument> getFromReplica(String id) {
        return this.getFromReplica(id, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> Iterator<D> getFromReplica(D document) {
        return this.getFromReplica(document, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> Iterator<D> getFromReplica(String id, Class<D> target) {
        return this.getFromReplica(id, target, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> Iterator<D> getFromReplica(String id, Class<D> target, long timeout, TimeUnit timeUnit) {
        return this.asyncBucket.getFromReplica(id, ReplicaMode.ALL, target).timeout(timeout, timeUnit).toBlocking().getIterator();
    }

    @Override
    public <D extends Document<?>> Iterator<D> getFromReplica(D document, long timeout, TimeUnit timeUnit) {
        return this.asyncBucket.getFromReplica(document, ReplicaMode.ALL).timeout(timeout, timeUnit).toBlocking().getIterator();
    }

    @Override
    public Iterator<JsonDocument> getFromReplica(String id, long timeout, TimeUnit timeUnit) {
        return this.asyncBucket.getFromReplica(id, ReplicaMode.ALL).timeout(timeout, timeUnit).toBlocking().getIterator();
    }

    @Override
    public JsonDocument getAndLock(String id, int lockTime) {
        return this.getAndLock(id, lockTime, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public JsonDocument getAndLock(String id, int lockTime, long timeout, TimeUnit timeUnit) {
        return (JsonDocument)Blocking.blockForSingle(this.asyncBucket.getAndLock(id, lockTime).singleOrDefault(null), timeout, timeUnit);
    }

    @Override
    public <D extends Document<?>> D getAndLock(D document, int lockTime) {
        return this.getAndLock(document, lockTime, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D getAndLock(D document, int lockTime, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.getAndLock(document, lockTime).singleOrDefault(null), timeout, timeUnit));
    }

    @Override
    public <D extends Document<?>> D getAndLock(String id, int lockTime, Class<D> target) {
        return this.getAndLock(id, lockTime, target, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D getAndLock(String id, int lockTime, Class<D> target, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.getAndLock(id, lockTime, target).singleOrDefault(null), timeout, timeUnit));
    }

    @Override
    public JsonDocument getAndTouch(String id, int expiry) {
        return this.getAndTouch(id, expiry, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public JsonDocument getAndTouch(String id, int expiry, long timeout, TimeUnit timeUnit) {
        return (JsonDocument)Blocking.blockForSingle(this.asyncBucket.getAndTouch(id, expiry).singleOrDefault(null), timeout, timeUnit);
    }

    @Override
    public <D extends Document<?>> D getAndTouch(D document) {
        return this.getAndTouch(document, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D getAndTouch(D document, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.getAndTouch(document).singleOrDefault(null), timeout, timeUnit));
    }

    @Override
    public <D extends Document<?>> D getAndTouch(String id, int expiry, Class<D> target) {
        return this.getAndTouch(id, expiry, target, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D getAndTouch(String id, int expiry, Class<D> target, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.getAndTouch(id, expiry, target).singleOrDefault(null), timeout, timeUnit));
    }

    @Override
    public <D extends Document<?>> D insert(D document) {
        return this.insert(document, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D insert(D document, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.insert(document).single(), timeout, timeUnit));
    }

    @Override
    public <D extends Document<?>> D insert(D document, PersistTo persistTo, ReplicateTo replicateTo) {
        return this.insert(document, persistTo, replicateTo, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D insert(D document, PersistTo persistTo, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.insert(document, persistTo, replicateTo).single(), timeout, timeUnit));
    }

    @Override
    public <D extends Document<?>> D insert(D document, PersistTo persistTo) {
        return this.insert(document, persistTo, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D insert(D document, PersistTo persistTo, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.insert(document, persistTo).single(), timeout, timeUnit));
    }

    @Override
    public <D extends Document<?>> D insert(D document, ReplicateTo replicateTo) {
        return this.insert(document, replicateTo, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D insert(D document, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.insert(document, replicateTo).single(), timeout, timeUnit));
    }

    @Override
    public <D extends Document<?>> D upsert(D document) {
        return this.upsert(document, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D upsert(D document, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.upsert(document).single(), timeout, timeUnit));
    }

    @Override
    public <D extends Document<?>> D upsert(D document, PersistTo persistTo, ReplicateTo replicateTo) {
        return this.upsert(document, persistTo, replicateTo, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D upsert(D document, PersistTo persistTo, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.upsert(document, persistTo, replicateTo).single(), timeout, timeUnit));
    }

    @Override
    public <D extends Document<?>> D upsert(D document, PersistTo persistTo) {
        return this.upsert(document, persistTo, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D upsert(D document, PersistTo persistTo, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.upsert(document, persistTo).single(), timeout, timeUnit));
    }

    @Override
    public <D extends Document<?>> D upsert(D document, ReplicateTo replicateTo) {
        return this.upsert(document, replicateTo, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D upsert(D document, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.upsert(document, replicateTo).single(), timeout, timeUnit));
    }

    @Override
    public <D extends Document<?>> D replace(D document) {
        return this.replace(document, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D replace(D document, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.replace(document).single(), timeout, timeUnit));
    }

    @Override
    public <D extends Document<?>> D replace(D document, PersistTo persistTo, ReplicateTo replicateTo) {
        return this.replace(document, persistTo, replicateTo, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D replace(D document, PersistTo persistTo, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.replace(document, persistTo, replicateTo).single(), timeout, timeUnit));
    }

    @Override
    public <D extends Document<?>> D replace(D document, PersistTo persistTo) {
        return this.replace(document, persistTo, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D replace(D document, PersistTo persistTo, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.replace(document, persistTo).single(), timeout, timeUnit));
    }

    @Override
    public <D extends Document<?>> D replace(D document, ReplicateTo replicateTo) {
        return this.replace(document, replicateTo, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D replace(D document, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.replace(document, replicateTo).single(), timeout, timeUnit));
    }

    @Override
    public <D extends Document<?>> D remove(D document) {
        return this.remove(document, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D remove(D document, PersistTo persistTo, ReplicateTo replicateTo) {
        return this.remove(document, persistTo, replicateTo, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D remove(D document, PersistTo persistTo) {
        return this.remove(document, persistTo, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D remove(D document, ReplicateTo replicateTo) {
        return this.remove(document, replicateTo, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D remove(D document, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.remove(document).singleOrDefault(null), timeout, timeUnit));
    }

    @Override
    public <D extends Document<?>> D remove(D document, PersistTo persistTo, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.remove(document, persistTo, replicateTo).singleOrDefault(null), timeout, timeUnit));
    }

    @Override
    public <D extends Document<?>> D remove(D document, PersistTo persistTo, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.remove(document, persistTo).singleOrDefault(null), timeout, timeUnit));
    }

    @Override
    public <D extends Document<?>> D remove(D document, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.remove(document, replicateTo).singleOrDefault(null), timeout, timeUnit));
    }

    @Override
    public JsonDocument remove(String id) {
        return this.remove(id, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public JsonDocument remove(String id, PersistTo persistTo, ReplicateTo replicateTo) {
        return this.remove(id, persistTo, replicateTo, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public JsonDocument remove(String id, PersistTo persistTo) {
        return this.remove(id, persistTo, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public JsonDocument remove(String id, ReplicateTo replicateTo) {
        return this.remove(id, replicateTo, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public JsonDocument remove(String id, long timeout, TimeUnit timeUnit) {
        return (JsonDocument)Blocking.blockForSingle(this.asyncBucket.remove(id).singleOrDefault(null), timeout, timeUnit);
    }

    @Override
    public JsonDocument remove(String id, PersistTo persistTo, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return (JsonDocument)Blocking.blockForSingle(this.asyncBucket.remove(id, persistTo, replicateTo).singleOrDefault(null), timeout, timeUnit);
    }

    @Override
    public JsonDocument remove(String id, PersistTo persistTo, long timeout, TimeUnit timeUnit) {
        return (JsonDocument)Blocking.blockForSingle(this.asyncBucket.remove(id, persistTo).singleOrDefault(null), timeout, timeUnit);
    }

    @Override
    public JsonDocument remove(String id, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return (JsonDocument)Blocking.blockForSingle(this.asyncBucket.remove(id, replicateTo).singleOrDefault(null), timeout, timeUnit);
    }

    @Override
    public <D extends Document<?>> D remove(String id, Class<D> target) {
        return this.remove(id, target, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D remove(String id, PersistTo persistTo, ReplicateTo replicateTo, Class<D> target) {
        return this.remove(id, persistTo, replicateTo, target, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D remove(String id, PersistTo persistTo, Class<D> target) {
        return this.remove(id, persistTo, target, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D remove(String id, ReplicateTo replicateTo, Class<D> target) {
        return this.remove(id, replicateTo, target, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D remove(String id, Class<D> target, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.remove(id, target).singleOrDefault(null), timeout, timeUnit));
    }

    @Override
    public <D extends Document<?>> D remove(String id, PersistTo persistTo, ReplicateTo replicateTo, Class<D> target, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.remove(id, persistTo, replicateTo, target).singleOrDefault(null), timeout, timeUnit));
    }

    @Override
    public <D extends Document<?>> D remove(String id, PersistTo persistTo, Class<D> target, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.remove(id, persistTo, target).singleOrDefault(null), timeout, timeUnit));
    }

    @Override
    public <D extends Document<?>> D remove(String id, ReplicateTo replicateTo, Class<D> target, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.remove(id, replicateTo, target).singleOrDefault(null), timeout, timeUnit));
    }

    @Override
    public ViewResult query(ViewQuery query) {
        return this.query(query, this.environment.viewTimeout(), TIMEOUT_UNIT);
    }

    @Override
    public N1qlQueryResult query(Statement statement) {
        return this.query(statement, this.environment.queryTimeout(), TIMEOUT_UNIT);
    }

    @Override
    public N1qlQueryResult query(N1qlQuery query) {
        return this.query(query, this.environment.queryTimeout(), TIMEOUT_UNIT);
    }

    @Override
    public SearchQueryResult query(SearchQuery query) {
        return this.query(query, this.environment.searchTimeout(), TIMEOUT_UNIT);
    }

    @Override
    public SearchQueryResult query(SearchQuery query, long timeout, TimeUnit timeUnit) {
        return (SearchQueryResult)Blocking.blockForSingle(this.asyncBucket.query(query).flatMap(DefaultSearchQueryResult.FROM_ASYNC).single(), timeout, timeUnit);
    }

    @Override
    public AnalyticsQueryResult query(AnalyticsQuery query) {
        return this.query(query, this.environment.analyticsTimeout(), TIMEOUT_UNIT);
    }

    @Override
    public AnalyticsQueryResult query(AnalyticsQuery query, long timeout, TimeUnit timeUnit) {
        return (AnalyticsQueryResult)Blocking.blockForSingle(this.asyncBucket.query(query).flatMap(AnalyticsQueryExecutor.ASYNC_RESULT_TO_SYNC).single(), timeout, timeUnit);
    }

    @Override
    public SpatialViewResult query(SpatialViewQuery query) {
        return this.query(query, this.environment.viewTimeout(), TIMEOUT_UNIT);
    }

    @Override
    public ViewResult query(ViewQuery query, long timeout, TimeUnit timeUnit) {
        return (ViewResult)Blocking.blockForSingle(this.asyncBucket.query(query).map((Func1)new Func1<AsyncViewResult, ViewResult>(){

            public ViewResult call(AsyncViewResult asyncViewResult) {
                return new DefaultViewResult(CouchbaseBucket.this.environment, CouchbaseBucket.this, asyncViewResult.rows(), asyncViewResult.totalRows(), asyncViewResult.success(), asyncViewResult.error(), asyncViewResult.debug());
            }
        }).single(), timeout, timeUnit);
    }

    @Override
    public SpatialViewResult query(SpatialViewQuery query, long timeout, TimeUnit timeUnit) {
        return (SpatialViewResult)Blocking.blockForSingle(this.asyncBucket.query(query).map((Func1)new Func1<AsyncSpatialViewResult, SpatialViewResult>(){

            public SpatialViewResult call(AsyncSpatialViewResult asyncSpatialViewResult) {
                return new DefaultSpatialViewResult(CouchbaseBucket.this.environment, CouchbaseBucket.this, asyncSpatialViewResult.rows(), asyncSpatialViewResult.success(), asyncSpatialViewResult.error(), asyncSpatialViewResult.debug());
            }
        }).single(), timeout, timeUnit);
    }

    @Override
    public N1qlQueryResult query(Statement statement, long timeout, TimeUnit timeUnit) {
        return this.query(N1qlQuery.simple(statement), timeout, timeUnit);
    }

    @Override
    public N1qlQueryResult query(N1qlQuery query, long timeout, TimeUnit timeUnit) {
        if (!query.params().hasServerSideTimeout()) {
            query.params().serverSideTimeout(timeout, timeUnit);
        }
        return (N1qlQueryResult)Blocking.blockForSingle(this.asyncBucket.query(query).flatMap(N1qlQueryExecutor.ASYNC_RESULT_TO_SYNC).single(), timeout, timeUnit);
    }

    @Override
    public Boolean unlock(String id, long cas) {
        return this.unlock(id, cas, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> Boolean unlock(D document) {
        return this.unlock(document, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public Boolean unlock(String id, long cas, long timeout, TimeUnit timeUnit) {
        return (Boolean)Blocking.blockForSingle(this.asyncBucket.unlock(id, cas).single(), timeout, timeUnit);
    }

    @Override
    public <D extends Document<?>> Boolean unlock(D document, long timeout, TimeUnit timeUnit) {
        return (Boolean)Blocking.blockForSingle(this.asyncBucket.unlock(document).single(), timeout, timeUnit);
    }

    @Override
    public Boolean touch(String id, int expiry) {
        return this.touch(id, expiry, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> Boolean touch(D document) {
        return this.touch(document, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public Boolean touch(String id, int expiry, long timeout, TimeUnit timeUnit) {
        return (Boolean)Blocking.blockForSingle(this.asyncBucket.touch(id, expiry).single(), timeout, timeUnit);
    }

    @Override
    public <D extends Document<?>> Boolean touch(D document, long timeout, TimeUnit timeUnit) {
        return (Boolean)Blocking.blockForSingle(this.asyncBucket.touch(document).single(), timeout, timeUnit);
    }

    @Override
    public JsonLongDocument counter(String id, long delta) {
        return this.counter(id, delta, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public JsonLongDocument counter(String id, long delta, long initial) {
        return this.counter(id, delta, initial, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public JsonLongDocument counter(String id, long delta, long initial, int expiry) {
        return this.counter(id, delta, initial, expiry, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public JsonLongDocument counter(String id, long delta, long timeout, TimeUnit timeUnit) {
        return (JsonLongDocument)Blocking.blockForSingle(this.asyncBucket.counter(id, delta).single(), timeout, timeUnit);
    }

    @Override
    public JsonLongDocument counter(String id, long delta, long initial, long timeout, TimeUnit timeUnit) {
        return (JsonLongDocument)Blocking.blockForSingle(this.asyncBucket.counter(id, delta, initial).single(), timeout, timeUnit);
    }

    @Override
    public JsonLongDocument counter(String id, long delta, long initial, int expiry, long timeout, TimeUnit timeUnit) {
        return (JsonLongDocument)Blocking.blockForSingle(this.asyncBucket.counter(id, delta, initial, expiry).single(), timeout, timeUnit);
    }

    @Override
    public BucketManager bucketManager() {
        return (BucketManager)this.asyncBucket.bucketManager().map((Func1)new Func1<AsyncBucketManager, BucketManager>(){

            public BucketManager call(AsyncBucketManager asyncBucketManager) {
                return DefaultBucketManager.create(CouchbaseBucket.this.environment, CouchbaseBucket.this.name, CouchbaseBucket.this.password, CouchbaseBucket.this.core);
            }
        }).toBlocking().single();
    }

    @Override
    public <D extends Document<?>> D append(D document) {
        return this.append(document, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D prepend(D document) {
        return this.prepend(document, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D append(D document, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.append(document).single(), timeout, timeUnit));
    }

    @Override
    public <D extends Document<?>> D prepend(D document, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.prepend(document).single(), timeout, timeUnit));
    }

    @Override
    public JsonLongDocument counter(String id, long delta, PersistTo persistTo) {
        return this.counter(id, delta, persistTo, ReplicateTo.NONE);
    }

    @Override
    public JsonLongDocument counter(String id, long delta, ReplicateTo replicateTo) {
        return this.counter(id, delta, PersistTo.NONE, replicateTo);
    }

    @Override
    public JsonLongDocument counter(String id, long delta, PersistTo persistTo, ReplicateTo replicateTo) {
        return this.counter(id, delta, persistTo, replicateTo, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public JsonLongDocument counter(String id, long delta, PersistTo persistTo, long timeout, TimeUnit timeUnit) {
        return this.counter(id, delta, persistTo, ReplicateTo.NONE, timeout, timeUnit);
    }

    @Override
    public JsonLongDocument counter(String id, long delta, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return this.counter(id, delta, PersistTo.NONE, replicateTo, timeout, timeUnit);
    }

    @Override
    public JsonLongDocument counter(String id, long delta, long initial, PersistTo persistTo) {
        return this.counter(id, delta, initial, persistTo, ReplicateTo.NONE);
    }

    @Override
    public JsonLongDocument counter(String id, long delta, long initial, ReplicateTo replicateTo) {
        return this.counter(id, delta, initial, PersistTo.NONE, replicateTo);
    }

    @Override
    public JsonLongDocument counter(String id, long delta, long initial, PersistTo persistTo, ReplicateTo replicateTo) {
        return this.counter(id, delta, initial, persistTo, replicateTo, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public JsonLongDocument counter(String id, long delta, long initial, PersistTo persistTo, long timeout, TimeUnit timeUnit) {
        return this.counter(id, delta, initial, persistTo, ReplicateTo.NONE, timeout, timeUnit);
    }

    @Override
    public JsonLongDocument counter(String id, long delta, long initial, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return this.counter(id, delta, initial, PersistTo.NONE, replicateTo, timeout, timeUnit);
    }

    @Override
    public JsonLongDocument counter(String id, long delta, long initial, int expiry, PersistTo persistTo) {
        return this.counter(id, delta, initial, expiry, persistTo, ReplicateTo.NONE);
    }

    @Override
    public JsonLongDocument counter(String id, long delta, long initial, int expiry, ReplicateTo replicateTo) {
        return this.counter(id, delta, initial, expiry, PersistTo.NONE, replicateTo);
    }

    @Override
    public JsonLongDocument counter(String id, long delta, long initial, int expiry, PersistTo persistTo, ReplicateTo replicateTo) {
        return this.counter(id, delta, initial, expiry, persistTo, replicateTo, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public JsonLongDocument counter(String id, long delta, long initial, int expiry, PersistTo persistTo, long timeout, TimeUnit timeUnit) {
        return this.counter(id, delta, initial, expiry, persistTo, ReplicateTo.NONE, timeout, timeUnit);
    }

    @Override
    public JsonLongDocument counter(String id, long delta, long initial, int expiry, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return this.counter(id, delta, initial, expiry, PersistTo.NONE, replicateTo, timeout, timeUnit);
    }

    @Override
    public JsonLongDocument counter(String id, long delta, PersistTo persistTo, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncBucket.counter(id, delta, persistTo, replicateTo), timeout, timeUnit);
    }

    @Override
    public JsonLongDocument counter(String id, long delta, long initial, PersistTo persistTo, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncBucket.counter(id, delta, initial, persistTo, replicateTo), timeout, timeUnit);
    }

    @Override
    public JsonLongDocument counter(String id, long delta, long initial, int expiry, PersistTo persistTo, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncBucket.counter(id, delta, initial, expiry, persistTo, replicateTo), timeout, timeUnit);
    }

    @Override
    public <D extends Document<?>> D append(D document, PersistTo persistTo) {
        return this.append(document, persistTo, ReplicateTo.NONE);
    }

    @Override
    public <D extends Document<?>> D append(D document, ReplicateTo replicateTo) {
        return this.append(document, PersistTo.NONE, replicateTo);
    }

    @Override
    public <D extends Document<?>> D append(D document, PersistTo persistTo, ReplicateTo replicateTo) {
        return this.append(document, persistTo, replicateTo, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D append(D document, PersistTo persistTo, long timeout, TimeUnit timeUnit) {
        return this.append(document, persistTo, ReplicateTo.NONE, timeout, timeUnit);
    }

    @Override
    public <D extends Document<?>> D append(D document, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return this.append(document, PersistTo.NONE, replicateTo, timeout, timeUnit);
    }

    @Override
    public <D extends Document<?>> D append(D document, PersistTo persistTo, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncBucket.append(document, persistTo, replicateTo), timeout, timeUnit);
    }

    @Override
    public <D extends Document<?>> D prepend(D document, PersistTo persistTo) {
        return this.prepend(document, persistTo, ReplicateTo.NONE);
    }

    @Override
    public <D extends Document<?>> D prepend(D document, ReplicateTo replicateTo) {
        return this.prepend(document, PersistTo.NONE, replicateTo);
    }

    @Override
    public <D extends Document<?>> D prepend(D document, PersistTo persistTo, ReplicateTo replicateTo) {
        return this.prepend(document, persistTo, replicateTo, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D prepend(D document, PersistTo persistTo, long timeout, TimeUnit timeUnit) {
        return this.prepend(document, persistTo, ReplicateTo.NONE, timeout, timeUnit);
    }

    @Override
    public <D extends Document<?>> D prepend(D document, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return this.prepend(document, PersistTo.NONE, replicateTo, timeout, timeUnit);
    }

    @Override
    public <D extends Document<?>> D prepend(D document, PersistTo persistTo, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncBucket.prepend(document, persistTo, replicateTo), timeout, timeUnit);
    }

    @Override
    public LookupInBuilder lookupIn(String docId) {
        AsyncLookupInBuilder asyncBuilder = this.asyncBucket.lookupIn(docId);
        return new LookupInBuilder(asyncBuilder, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public MutateInBuilder mutateIn(String docId) {
        AsyncMutateInBuilder asyncBuilder = this.asyncBucket.mutateIn(docId);
        return new MutateInBuilder(asyncBuilder, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <V> boolean mapAdd(String docId, String key, V value) {
        return this.mapAdd(docId, key, value, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <V> boolean mapAdd(String docId, String key, V value, long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncBucket.mapAdd(docId, key, value), timeout, timeUnit);
    }

    @Override
    public <V> boolean mapAdd(String docId, String key, V value, MutationOptionBuilder mutationOptionBuilder) {
        return this.mapAdd(docId, key, value, mutationOptionBuilder, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <V> boolean mapAdd(String docId, String key, V value, MutationOptionBuilder mutationOptionBuilder, long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncBucket.mapAdd(docId, key, value, mutationOptionBuilder), timeout, timeUnit);
    }

    @Override
    public <V> V mapGet(String docId, String key, Class<V> valueType) {
        return this.mapGet(docId, key, valueType, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <V> V mapGet(String docId, String key, Class<V> valueType, long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncBucket.mapGet(docId, key, valueType), timeout, timeUnit);
    }

    @Override
    public boolean mapRemove(String docId, String key) {
        return this.mapRemove(docId, key, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public boolean mapRemove(String docId, String key, long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncBucket.mapRemove(docId, key), timeout, timeUnit);
    }

    @Override
    public boolean mapRemove(String docId, String key, MutationOptionBuilder mutationOptionBuilder) {
        return this.mapRemove(docId, key, mutationOptionBuilder, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public boolean mapRemove(String docId, String key, MutationOptionBuilder mutationOptionBuilder, long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncBucket.mapRemove(docId, key, mutationOptionBuilder), timeout, timeUnit);
    }

    @Override
    public int mapSize(String docId) {
        return this.mapSize(docId, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public int mapSize(String docId, long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncBucket.mapSize(docId), timeout, timeUnit);
    }

    @Override
    public <E> E listGet(String docId, int index, Class<E> elementType) {
        return this.listGet(docId, index, elementType, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <E> E listGet(String docId, int index, Class<E> elementType, long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncBucket.listGet(docId, index, elementType), timeout, timeUnit);
    }

    @Override
    public <E> boolean listAppend(String docId, E element) {
        return this.listAppend(docId, element, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <E> boolean listAppend(String docId, E element, long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncBucket.listAppend(docId, element), timeout, timeUnit);
    }

    @Override
    public <E> boolean listAppend(String docId, E element, MutationOptionBuilder mutationOptionBuilder) {
        return this.listAppend(docId, element, mutationOptionBuilder, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <E> boolean listAppend(String docId, E element, MutationOptionBuilder mutationOptionBuilder, long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncBucket.listAppend(docId, element, mutationOptionBuilder), timeout, timeUnit);
    }

    @Override
    public <E> boolean listPrepend(String docId, E element) {
        return this.listPrepend(docId, element, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <E> boolean listPrepend(String docId, E element, long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncBucket.listPrepend(docId, element), timeout, timeUnit);
    }

    @Override
    public <E> boolean listPrepend(String docId, E element, MutationOptionBuilder mutationOptionBuilder) {
        return this.listPrepend(docId, element, mutationOptionBuilder, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <E> boolean listPrepend(String docId, E element, MutationOptionBuilder mutationOptionBuilder, long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncBucket.listPrepend(docId, element, mutationOptionBuilder), timeout, timeUnit);
    }

    @Override
    public boolean listRemove(String docId, int index) {
        return this.listRemove(docId, index, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public boolean listRemove(String docId, int index, long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncBucket.listRemove(docId, index), timeout, timeUnit);
    }

    @Override
    public boolean listRemove(String docId, int index, MutationOptionBuilder mutationOptionBuilder) {
        return this.listRemove(docId, index, mutationOptionBuilder, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public boolean listRemove(String docId, int index, MutationOptionBuilder mutationOptionBuilder, long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncBucket.listRemove(docId, index, mutationOptionBuilder), timeout, timeUnit);
    }

    @Override
    public <E> boolean listSet(String docId, int index, E element) {
        return this.listSet(docId, index, element, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <E> boolean listSet(String docId, int index, E element, long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncBucket.listSet(docId, index, element), timeout, timeUnit);
    }

    @Override
    public <E> boolean listSet(String docId, int index, E element, MutationOptionBuilder mutationOptionBuilder) {
        return this.listSet(docId, index, element, mutationOptionBuilder, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <E> boolean listSet(String docId, int index, E element, MutationOptionBuilder mutationOptionBuilder, long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncBucket.listSet(docId, index, element, mutationOptionBuilder), timeout, timeUnit);
    }

    @Override
    public int listSize(String docId) {
        return this.listSize(docId, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public int listSize(String docId, long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncBucket.listSize(docId), timeout, timeUnit);
    }

    @Override
    public <E> boolean setAdd(String docId, E element) {
        return this.setAdd(docId, element, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <E> boolean setAdd(String docId, E element, long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncBucket.setAdd(docId, element), timeout, timeUnit);
    }

    @Override
    public <E> boolean setAdd(String docId, E element, MutationOptionBuilder mutationOptionBuilder) {
        return this.setAdd(docId, element, mutationOptionBuilder, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <E> boolean setAdd(String docId, E element, MutationOptionBuilder mutationOptionBuilder, long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncBucket.setAdd(docId, element, mutationOptionBuilder), timeout, timeUnit);
    }

    @Override
    public <E> boolean setContains(String docId, E element) {
        return this.setContains(docId, element, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <E> boolean setContains(String docId, E element, long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncBucket.setContains(docId, element), timeout, timeUnit);
    }

    @Override
    public <E> E setRemove(String docId, E element) {
        return this.setRemove(docId, element, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <E> E setRemove(String docId, E element, long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncBucket.setRemove(docId, element), timeout, timeUnit);
    }

    @Override
    public <E> E setRemove(String docId, E element, MutationOptionBuilder mutationOptionBuilder) {
        return this.setRemove(docId, element, mutationOptionBuilder, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <E> E setRemove(String docId, E element, MutationOptionBuilder mutationOptionBuilder, long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncBucket.setRemove(docId, element, mutationOptionBuilder), timeout, timeUnit);
    }

    @Override
    public int setSize(String docId) {
        return this.setSize(docId, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public int setSize(String docId, long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncBucket.setSize(docId), timeout, timeUnit);
    }

    @Override
    public <E> boolean queuePush(String docId, E element) {
        return this.queuePush(docId, element, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <E> boolean queuePush(String docId, E element, long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncBucket.queuePush(docId, element), timeout, timeUnit);
    }

    @Override
    public <E> boolean queuePush(String docId, E element, MutationOptionBuilder mutationOptionBuilder) {
        return this.queuePush(docId, element, mutationOptionBuilder, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <E> boolean queuePush(String docId, E element, MutationOptionBuilder mutationOptionBuilder, long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncBucket.queuePush(docId, element, mutationOptionBuilder), timeout, timeUnit);
    }

    @Override
    public <E> E queuePop(String docId, Class<E> elementType) {
        return this.queuePop(docId, elementType, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <E> E queuePop(String docId, Class<E> elementType, long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncBucket.queuePop(docId, elementType), timeout, timeUnit);
    }

    @Override
    public <E> E queuePop(String docId, Class<E> elementType, MutationOptionBuilder mutationOptionBuilder) {
        return this.queuePop(docId, elementType, mutationOptionBuilder, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <E> E queuePop(String docId, Class<E> elementType, MutationOptionBuilder mutationOptionBuilder, long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncBucket.queuePop(docId, elementType, mutationOptionBuilder), timeout, timeUnit);
    }

    @Override
    public int queueSize(String docId) {
        return this.queueSize(docId, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public int queueSize(String docId, long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncBucket.queueSize(docId), timeout, timeUnit);
    }

    @Override
    public Boolean close() {
        return this.close(this.environment.disconnectTimeout(), TIMEOUT_UNIT);
    }

    @Override
    public Boolean close(long timeout, TimeUnit timeUnit) {
        return (Boolean)Blocking.blockForSingle(this.asyncBucket.close().single(), timeout, timeUnit);
    }

    @Override
    public boolean isClosed() {
        return this.asyncBucket.isClosed();
    }

    public String toString() {
        return "Bucket[" + this.name() + "]";
    }

    @Override
    public int invalidateQueryCache() {
        return Blocking.blockForSingle(this.asyncBucket.invalidateQueryCache(), this.environment.managementTimeout(), TIMEOUT_UNIT);
    }
}

