/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.core.CouchbaseException;
import com.couchbase.client.core.lang.Tuple2;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.core.message.cluster.CloseBucketRequest;
import com.couchbase.client.core.message.cluster.CloseBucketResponse;
import com.couchbase.client.core.message.kv.AppendRequest;
import com.couchbase.client.core.message.kv.AppendResponse;
import com.couchbase.client.core.message.kv.CounterRequest;
import com.couchbase.client.core.message.kv.CounterResponse;
import com.couchbase.client.core.message.kv.GetRequest;
import com.couchbase.client.core.message.kv.GetResponse;
import com.couchbase.client.core.message.kv.InsertRequest;
import com.couchbase.client.core.message.kv.InsertResponse;
import com.couchbase.client.core.message.kv.MutationToken;
import com.couchbase.client.core.message.kv.ObserveRequest;
import com.couchbase.client.core.message.kv.ObserveResponse;
import com.couchbase.client.core.message.kv.PrependRequest;
import com.couchbase.client.core.message.kv.PrependResponse;
import com.couchbase.client.core.message.kv.RemoveRequest;
import com.couchbase.client.core.message.kv.RemoveResponse;
import com.couchbase.client.core.message.kv.ReplaceRequest;
import com.couchbase.client.core.message.kv.ReplaceResponse;
import com.couchbase.client.core.message.kv.TouchRequest;
import com.couchbase.client.core.message.kv.TouchResponse;
import com.couchbase.client.core.message.kv.UnlockRequest;
import com.couchbase.client.core.message.kv.UnlockResponse;
import com.couchbase.client.core.message.kv.UpsertRequest;
import com.couchbase.client.core.message.kv.UpsertResponse;
import com.couchbase.client.core.message.kv.subdoc.multi.Lookup;
import com.couchbase.client.core.message.kv.subdoc.multi.Mutation;
import com.couchbase.client.core.message.observe.Observe;
import com.couchbase.client.core.message.search.SearchQueryRequest;
import com.couchbase.client.core.message.search.SearchQueryResponse;
import com.couchbase.client.core.message.view.ViewQueryRequest;
import com.couchbase.client.core.message.view.ViewQueryResponse;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.time.Delay;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.java.AsyncBucket;
import com.couchbase.client.java.PersistTo;
import com.couchbase.client.java.ReplicaMode;
import com.couchbase.client.java.ReplicateTo;
import com.couchbase.client.java.bucket.AsyncBucketManager;
import com.couchbase.client.java.bucket.DefaultAsyncBucketManager;
import com.couchbase.client.java.bucket.ReplicaReader;
import com.couchbase.client.java.datastructures.MutationOptionBuilder;
import com.couchbase.client.java.datastructures.ResultMappingUtils;
import com.couchbase.client.java.document.Document;
import com.couchbase.client.java.document.JsonArrayDocument;
import com.couchbase.client.java.document.JsonDocument;
import com.couchbase.client.java.document.JsonLongDocument;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.error.CASMismatchException;
import com.couchbase.client.java.error.CouchbaseOutOfMemoryException;
import com.couchbase.client.java.error.DocumentAlreadyExistsException;
import com.couchbase.client.java.error.DocumentDoesNotExistException;
import com.couchbase.client.java.error.DurabilityException;
import com.couchbase.client.java.error.RequestTooBigException;
import com.couchbase.client.java.error.TemporaryFailureException;
import com.couchbase.client.java.error.TemporaryLockFailureException;
import com.couchbase.client.java.error.subdoc.MultiMutationException;
import com.couchbase.client.java.error.subdoc.PathNotFoundException;
import com.couchbase.client.java.query.AsyncN1qlQueryResult;
import com.couchbase.client.java.query.N1qlQuery;
import com.couchbase.client.java.query.Statement;
import com.couchbase.client.java.query.core.N1qlQueryExecutor;
import com.couchbase.client.java.repository.AsyncRepository;
import com.couchbase.client.java.repository.CouchbaseAsyncRepository;
import com.couchbase.client.java.search.SearchQuery;
import com.couchbase.client.java.search.result.AsyncSearchQueryResult;
import com.couchbase.client.java.search.result.impl.DefaultAsyncSearchQueryResult;
import com.couchbase.client.java.subdoc.AsyncLookupInBuilder;
import com.couchbase.client.java.subdoc.AsyncMutateInBuilder;
import com.couchbase.client.java.subdoc.DocumentFragment;
import com.couchbase.client.java.transcoder.BinaryTranscoder;
import com.couchbase.client.java.transcoder.JacksonTransformers;
import com.couchbase.client.java.transcoder.JsonArrayTranscoder;
import com.couchbase.client.java.transcoder.JsonBooleanTranscoder;
import com.couchbase.client.java.transcoder.JsonDoubleTranscoder;
import com.couchbase.client.java.transcoder.JsonLongTranscoder;
import com.couchbase.client.java.transcoder.JsonStringTranscoder;
import com.couchbase.client.java.transcoder.JsonTranscoder;
import com.couchbase.client.java.transcoder.LegacyTranscoder;
import com.couchbase.client.java.transcoder.RawJsonTranscoder;
import com.couchbase.client.java.transcoder.SerializableTranscoder;
import com.couchbase.client.java.transcoder.StringTranscoder;
import com.couchbase.client.java.transcoder.Transcoder;
import com.couchbase.client.java.transcoder.subdoc.FragmentTranscoder;
import com.couchbase.client.java.transcoder.subdoc.JacksonFragmentTranscoder;
import com.couchbase.client.java.util.OnSubscribeDeferAndWatch;
import com.couchbase.client.java.view.AsyncSpatialViewResult;
import com.couchbase.client.java.view.AsyncViewResult;
import com.couchbase.client.java.view.SpatialViewQuery;
import com.couchbase.client.java.view.ViewQuery;
import com.couchbase.client.java.view.ViewQueryResponseMapper;
import com.couchbase.client.java.view.ViewRetryHandler;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.functions.Func0;
import rx.functions.Func1;

public class CouchbaseAsyncBucket
implements AsyncBucket {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(CouchbaseAsyncBucket.class);
    private static final int COUNTER_NOT_EXISTS_EXPIRY = -1;
    private static final int MAX_CAS_RETRIES_DATASTRUCTURES = Integer.parseInt(System.getProperty("com.couchbase.datastructureCASRetryLimit", "10"));
    public static final String CURRENT_BUCKET_IDENTIFIER = "#CURRENT_BUCKET#";
    public static final JsonTranscoder JSON_OBJECT_TRANSCODER = new JsonTranscoder();
    public static final JsonArrayTranscoder JSON_ARRAY_TRANSCODER = new JsonArrayTranscoder();
    public static final JsonBooleanTranscoder JSON_BOOLEAN_TRANSCODER = new JsonBooleanTranscoder();
    public static final JsonDoubleTranscoder JSON_DOUBLE_TRANSCODER = new JsonDoubleTranscoder();
    public static final JsonLongTranscoder JSON_LONG_TRANSCODER = new JsonLongTranscoder();
    public static final JsonStringTranscoder JSON_STRING_TRANSCODER = new JsonStringTranscoder();
    public static final RawJsonTranscoder RAW_JSON_TRANSCODER = new RawJsonTranscoder();
    public static final LegacyTranscoder LEGACY_TRANSCODER = new LegacyTranscoder();
    public static final BinaryTranscoder BINARY_TRANSCODER = new BinaryTranscoder();
    public static final StringTranscoder STRING_TRANSCODER = new StringTranscoder();
    public static final SerializableTranscoder SERIALIZABLE_TRANSCODER = new SerializableTranscoder();
    private final String bucket;
    private final String password;
    private final ClusterFacade core;
    private final Map<Class<? extends Document>, Transcoder<? extends Document, ?>> transcoders;
    private final FragmentTranscoder subdocumentTranscoder = new JacksonFragmentTranscoder(JacksonTransformers.MAPPER);
    private final AsyncBucketManager bucketManager;
    private final CouchbaseEnvironment environment;
    private final N1qlQueryExecutor n1qlQueryExecutor;
    private volatile boolean closed;

    public CouchbaseAsyncBucket(ClusterFacade core, CouchbaseEnvironment environment, String name, String password, List<Transcoder<? extends Document, ?>> customTranscoders) {
        this.bucket = name;
        this.password = password;
        this.core = core;
        this.environment = environment;
        this.closed = false;
        this.transcoders = new ConcurrentHashMap();
        this.transcoders.put(JSON_OBJECT_TRANSCODER.documentType(), JSON_OBJECT_TRANSCODER);
        this.transcoders.put(JSON_ARRAY_TRANSCODER.documentType(), JSON_ARRAY_TRANSCODER);
        this.transcoders.put(JSON_BOOLEAN_TRANSCODER.documentType(), JSON_BOOLEAN_TRANSCODER);
        this.transcoders.put(JSON_DOUBLE_TRANSCODER.documentType(), JSON_DOUBLE_TRANSCODER);
        this.transcoders.put(JSON_LONG_TRANSCODER.documentType(), JSON_LONG_TRANSCODER);
        this.transcoders.put(JSON_STRING_TRANSCODER.documentType(), JSON_STRING_TRANSCODER);
        this.transcoders.put(RAW_JSON_TRANSCODER.documentType(), RAW_JSON_TRANSCODER);
        this.transcoders.put(LEGACY_TRANSCODER.documentType(), LEGACY_TRANSCODER);
        this.transcoders.put(BINARY_TRANSCODER.documentType(), BINARY_TRANSCODER);
        this.transcoders.put(STRING_TRANSCODER.documentType(), STRING_TRANSCODER);
        this.transcoders.put(SERIALIZABLE_TRANSCODER.documentType(), SERIALIZABLE_TRANSCODER);
        for (Transcoder<Document, ?> custom : customTranscoders) {
            this.transcoders.put(custom.documentType(), custom);
        }
        this.bucketManager = DefaultAsyncBucketManager.create(this.bucket, password, core);
        boolean n1qlPreparedEncodedPlanEnabled = "true".equalsIgnoreCase(System.getProperty("com.couchbase.query.encodedPlanEnabled", "true"));
        this.n1qlQueryExecutor = new N1qlQueryExecutor(core, this.bucket, password, n1qlPreparedEncodedPlanEnabled);
    }

    @Override
    public String name() {
        return this.bucket;
    }

    @Override
    public Observable<ClusterFacade> core() {
        return Observable.just((Object)this.core);
    }

    @Override
    public FragmentTranscoder subdocumentTranscoder() {
        return this.subdocumentTranscoder;
    }

    protected N1qlQueryExecutor n1qlQueryExecutor() {
        return this.n1qlQueryExecutor;
    }

    @Override
    public CouchbaseEnvironment environment() {
        return this.environment;
    }

    @Override
    public Observable<AsyncRepository> repository() {
        return Observable.just((Object)new CouchbaseAsyncRepository(this));
    }

    @Override
    public Observable<JsonDocument> get(String id) {
        return this.get(id, JsonDocument.class);
    }

    @Override
    public <D extends Document<?>> Observable<D> get(D document) {
        return this.get(document.id(), document.getClass());
    }

    @Override
    public <D extends Document<?>> Observable<D> get(final String id, final Class<D> target) {
        return OnSubscribeDeferAndWatch.deferAndWatch(new Func0<Observable<GetResponse>>(){

            public Observable<GetResponse> call() {
                return CouchbaseAsyncBucket.this.core.send((CouchbaseRequest)new GetRequest(id, CouchbaseAsyncBucket.this.bucket));
            }
        }).filter((Func1)new Func1<GetResponse, Boolean>(){

            public Boolean call(GetResponse response) {
                if (response.status().isSuccess()) {
                    return true;
                }
                ByteBuf content = response.content();
                if (content != null && content.refCnt() > 0) {
                    content.release();
                }
                switch (response.status()) {
                    case NOT_EXISTS: {
                        return false;
                    }
                    case TEMPORARY_FAILURE: 
                    case SERVER_BUSY: {
                        throw new TemporaryFailureException();
                    }
                    case OUT_OF_MEMORY: {
                        throw new CouchbaseOutOfMemoryException();
                    }
                }
                throw new CouchbaseException(response.status().toString());
            }
        }).map(new Func1<GetResponse, D>(){

            public D call(GetResponse response) {
                Transcoder transcoder = (Transcoder)CouchbaseAsyncBucket.this.transcoders.get(target);
                return transcoder.decode(id, response.content(), response.cas(), 0, response.flags(), response.status());
            }
        });
    }

    @Override
    public Observable<Boolean> exists(final String id) {
        return OnSubscribeDeferAndWatch.deferAndWatch(new Func0<Observable<ObserveResponse>>(){

            public Observable<ObserveResponse> call() {
                return CouchbaseAsyncBucket.this.core.send((CouchbaseRequest)new ObserveRequest(id, 0L, true, 0, CouchbaseAsyncBucket.this.bucket));
            }
        }).map((Func1)new Func1<ObserveResponse, Boolean>(){

            public Boolean call(ObserveResponse response) {
                ObserveResponse.ObserveStatus foundStatus;
                ByteBuf content = response.content();
                if (content != null && content.refCnt() > 0) {
                    content.release();
                }
                if ((foundStatus = response.observeStatus()) == ObserveResponse.ObserveStatus.FOUND_PERSISTED || foundStatus == ObserveResponse.ObserveStatus.FOUND_NOT_PERSISTED) {
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    public <D extends Document<?>> Observable<Boolean> exists(D document) {
        return this.exists((D)((Object)document.id()));
    }

    @Override
    public Observable<JsonDocument> getAndLock(String id, int lockTime) {
        return this.getAndLock(id, lockTime, JsonDocument.class);
    }

    @Override
    public <D extends Document<?>> Observable<D> getAndLock(D document, int lockTime) {
        return this.getAndLock(document.id(), lockTime, document.getClass());
    }

    @Override
    public <D extends Document<?>> Observable<D> getAndLock(final String id, final int lockTime, final Class<D> target) {
        return OnSubscribeDeferAndWatch.deferAndWatch(new Func0<Observable<GetResponse>>(){

            public Observable<GetResponse> call() {
                return CouchbaseAsyncBucket.this.core.send((CouchbaseRequest)new GetRequest(id, CouchbaseAsyncBucket.this.bucket, true, false, lockTime));
            }
        }).filter((Func1)new Func1<GetResponse, Boolean>(){

            public Boolean call(GetResponse response) {
                if (response.status().isSuccess()) {
                    return true;
                }
                ByteBuf content = response.content();
                if (content != null && content.refCnt() > 0) {
                    content.release();
                }
                switch (response.status()) {
                    case NOT_EXISTS: {
                        return false;
                    }
                    case TEMPORARY_FAILURE: {
                        throw new TemporaryLockFailureException();
                    }
                    case SERVER_BUSY: {
                        throw new TemporaryFailureException();
                    }
                    case OUT_OF_MEMORY: {
                        throw new CouchbaseOutOfMemoryException();
                    }
                }
                throw new CouchbaseException(response.status().toString());
            }
        }).map(new Func1<GetResponse, D>(){

            public D call(GetResponse response) {
                Transcoder transcoder = (Transcoder)CouchbaseAsyncBucket.this.transcoders.get(target);
                return transcoder.decode(id, response.content(), response.cas(), 0, response.flags(), response.status());
            }
        });
    }

    @Override
    public Observable<JsonDocument> getAndTouch(String id, int expiry) {
        return this.getAndTouch(id, expiry, JsonDocument.class);
    }

    @Override
    public <D extends Document<?>> Observable<D> getAndTouch(D document) {
        return this.getAndTouch(document.id(), document.expiry(), document.getClass());
    }

    @Override
    public <D extends Document<?>> Observable<D> getAndTouch(final String id, final int expiry, final Class<D> target) {
        return OnSubscribeDeferAndWatch.deferAndWatch(new Func0<Observable<GetResponse>>(){

            public Observable<GetResponse> call() {
                return CouchbaseAsyncBucket.this.core.send((CouchbaseRequest)new GetRequest(id, CouchbaseAsyncBucket.this.bucket, false, true, expiry));
            }
        }).filter((Func1)new Func1<GetResponse, Boolean>(){

            public Boolean call(GetResponse response) {
                if (response.status().isSuccess()) {
                    return true;
                }
                ByteBuf content = response.content();
                if (content != null && content.refCnt() > 0) {
                    content.release();
                }
                switch (response.status()) {
                    case NOT_EXISTS: {
                        return false;
                    }
                    case TEMPORARY_FAILURE: 
                    case SERVER_BUSY: {
                        throw new TemporaryFailureException();
                    }
                    case OUT_OF_MEMORY: {
                        throw new CouchbaseOutOfMemoryException();
                    }
                }
                throw new CouchbaseException(response.status().toString());
            }
        }).map(new Func1<GetResponse, D>(){

            public D call(GetResponse response) {
                Transcoder transcoder = (Transcoder)CouchbaseAsyncBucket.this.transcoders.get(target);
                return transcoder.decode(id, response.content(), response.cas(), 0, response.flags(), response.status());
            }
        });
    }

    @Override
    public Observable<JsonDocument> getFromReplica(String id, ReplicaMode type) {
        return this.getFromReplica(id, type, JsonDocument.class);
    }

    @Override
    public <D extends Document<?>> Observable<D> getFromReplica(D document, ReplicaMode type) {
        return this.getFromReplica(document.id(), type, document.getClass());
    }

    @Override
    public <D extends Document<?>> Observable<D> getFromReplica(final String id, ReplicaMode type, final Class<D> target) {
        return ReplicaReader.read(this.core, id, type, this.bucket).map(new Func1<GetResponse, D>(){

            public D call(GetResponse response) {
                Transcoder transcoder = (Transcoder)CouchbaseAsyncBucket.this.transcoders.get(target);
                return transcoder.decode(id, response.content(), response.cas(), 0, response.flags(), response.status());
            }
        }).cache(type.maxAffectedNodes());
    }

    @Override
    public <D extends Document<?>> Observable<D> insert(final D document) {
        final Transcoder<? extends Document, ?> transcoder = this.transcoders.get(document.getClass());
        return OnSubscribeDeferAndWatch.deferAndWatch(new Func0<Observable<InsertResponse>>(){

            public Observable<InsertResponse> call() {
                Tuple2<ByteBuf, Integer> encoded = transcoder.encode(document);
                return CouchbaseAsyncBucket.this.core.send((CouchbaseRequest)new InsertRequest(document.id(), (ByteBuf)encoded.value1(), document.expiry(), ((Integer)encoded.value2()).intValue(), CouchbaseAsyncBucket.this.bucket));
            }
        }).map(new Func1<InsertResponse, D>(){

            public D call(InsertResponse response) {
                if (response.content() != null && response.content().refCnt() > 0) {
                    response.content().release();
                }
                if (response.status().isSuccess()) {
                    return transcoder.newDocument(document.id(), document.expiry(), document.content(), response.cas(), response.mutationToken());
                }
                switch (response.status()) {
                    case TOO_BIG: {
                        throw new RequestTooBigException();
                    }
                    case EXISTS: {
                        throw new DocumentAlreadyExistsException();
                    }
                    case TEMPORARY_FAILURE: 
                    case SERVER_BUSY: {
                        throw new TemporaryFailureException();
                    }
                    case OUT_OF_MEMORY: {
                        throw new CouchbaseOutOfMemoryException();
                    }
                }
                throw new CouchbaseException(response.status().toString());
            }
        });
    }

    @Override
    public <D extends Document<?>> Observable<D> insert(D document, final PersistTo persistTo, final ReplicateTo replicateTo) {
        Observable<D> insertResult = this.insert(document);
        if (persistTo == PersistTo.NONE && replicateTo == ReplicateTo.NONE) {
            return insertResult;
        }
        return insertResult.flatMap(new Func1<D, Observable<D>>(){

            public Observable<D> call(D doc) {
                return Observe.call((ClusterFacade)CouchbaseAsyncBucket.this.core, (String)CouchbaseAsyncBucket.this.bucket, (String)doc.id(), (long)doc.cas(), (boolean)false, (MutationToken)doc.mutationToken(), (Observe.PersistTo)persistTo.value(), (Observe.ReplicateTo)replicateTo.value(), (Delay)CouchbaseAsyncBucket.this.environment.observeIntervalDelay(), (RetryStrategy)CouchbaseAsyncBucket.this.environment.retryStrategy()).map(new Func1<Boolean, D>((Document)doc){
                    final /* synthetic */ Document val$doc;
                    {
                        this.val$doc = document;
                    }

                    public D call(Boolean aBoolean) {
                        return this.val$doc;
                    }
                }).onErrorResumeNext(new Func1<Throwable, Observable<? extends D>>(){

                    public Observable<? extends D> call(Throwable throwable) {
                        return Observable.error((Throwable)((Object)new DurabilityException("Durability requirement failed: " + throwable.getMessage(), throwable)));
                    }
                });
            }
        });
    }

    @Override
    public <D extends Document<?>> Observable<D> upsert(final D document) {
        final Transcoder<? extends Document, ?> transcoder = this.transcoders.get(document.getClass());
        return OnSubscribeDeferAndWatch.deferAndWatch(new Func0<Observable<UpsertResponse>>(){

            public Observable<UpsertResponse> call() {
                Tuple2<ByteBuf, Integer> encoded = transcoder.encode(document);
                return CouchbaseAsyncBucket.this.core.send((CouchbaseRequest)new UpsertRequest(document.id(), (ByteBuf)encoded.value1(), document.expiry(), ((Integer)encoded.value2()).intValue(), CouchbaseAsyncBucket.this.bucket));
            }
        }).map(new Func1<UpsertResponse, D>(){

            public D call(UpsertResponse response) {
                if (response.content() != null && response.content().refCnt() > 0) {
                    response.content().release();
                }
                if (response.status().isSuccess()) {
                    return transcoder.newDocument(document.id(), document.expiry(), document.content(), response.cas(), response.mutationToken());
                }
                switch (response.status()) {
                    case TOO_BIG: {
                        throw new RequestTooBigException();
                    }
                    case EXISTS: {
                        throw new CASMismatchException();
                    }
                    case TEMPORARY_FAILURE: 
                    case SERVER_BUSY: {
                        throw new TemporaryFailureException();
                    }
                    case OUT_OF_MEMORY: {
                        throw new CouchbaseOutOfMemoryException();
                    }
                }
                throw new CouchbaseException(response.status().toString());
            }
        });
    }

    @Override
    public <D extends Document<?>> Observable<D> upsert(D document, final PersistTo persistTo, final ReplicateTo replicateTo) {
        Observable<D> upsertResult = this.upsert(document);
        if (persistTo == PersistTo.NONE && replicateTo == ReplicateTo.NONE) {
            return upsertResult;
        }
        return upsertResult.flatMap(new Func1<D, Observable<D>>(){

            public Observable<D> call(D doc) {
                return Observe.call((ClusterFacade)CouchbaseAsyncBucket.this.core, (String)CouchbaseAsyncBucket.this.bucket, (String)doc.id(), (long)doc.cas(), (boolean)false, (MutationToken)doc.mutationToken(), (Observe.PersistTo)persistTo.value(), (Observe.ReplicateTo)replicateTo.value(), (Delay)CouchbaseAsyncBucket.this.environment.observeIntervalDelay(), (RetryStrategy)CouchbaseAsyncBucket.this.environment.retryStrategy()).map(new Func1<Boolean, D>((Document)doc){
                    final /* synthetic */ Document val$doc;
                    {
                        this.val$doc = document;
                    }

                    public D call(Boolean aBoolean) {
                        return this.val$doc;
                    }
                }).onErrorResumeNext(new Func1<Throwable, Observable<? extends D>>(){

                    public Observable<? extends D> call(Throwable throwable) {
                        return Observable.error((Throwable)((Object)new DurabilityException("Durability requirement failed: " + throwable.getMessage(), throwable)));
                    }
                });
            }
        });
    }

    @Override
    public <D extends Document<?>> Observable<D> replace(final D document) {
        final Transcoder<? extends Document, ?> transcoder = this.transcoders.get(document.getClass());
        return OnSubscribeDeferAndWatch.deferAndWatch(new Func0<Observable<ReplaceResponse>>(){

            public Observable<ReplaceResponse> call() {
                Tuple2<ByteBuf, Integer> encoded = transcoder.encode(document);
                return CouchbaseAsyncBucket.this.core.send((CouchbaseRequest)new ReplaceRequest(document.id(), (ByteBuf)encoded.value1(), document.cas(), document.expiry(), ((Integer)encoded.value2()).intValue(), CouchbaseAsyncBucket.this.bucket));
            }
        }).map(new Func1<ReplaceResponse, D>(){

            public D call(ReplaceResponse response) {
                if (response.content() != null && response.content().refCnt() > 0) {
                    response.content().release();
                }
                if (response.status().isSuccess()) {
                    return transcoder.newDocument(document.id(), document.expiry(), document.content(), response.cas(), response.mutationToken());
                }
                switch (response.status()) {
                    case TOO_BIG: {
                        throw new RequestTooBigException();
                    }
                    case NOT_EXISTS: {
                        throw new DocumentDoesNotExistException();
                    }
                    case EXISTS: {
                        throw new CASMismatchException();
                    }
                    case TEMPORARY_FAILURE: 
                    case SERVER_BUSY: {
                        throw new TemporaryFailureException();
                    }
                    case OUT_OF_MEMORY: {
                        throw new CouchbaseOutOfMemoryException();
                    }
                }
                throw new CouchbaseException(response.status().toString());
            }
        });
    }

    @Override
    public <D extends Document<?>> Observable<D> replace(D document, final PersistTo persistTo, final ReplicateTo replicateTo) {
        Observable<D> replaceResult = this.replace(document);
        if (persistTo == PersistTo.NONE && replicateTo == ReplicateTo.NONE) {
            return replaceResult;
        }
        return replaceResult.flatMap(new Func1<D, Observable<D>>(){

            public Observable<D> call(D doc) {
                return Observe.call((ClusterFacade)CouchbaseAsyncBucket.this.core, (String)CouchbaseAsyncBucket.this.bucket, (String)doc.id(), (long)doc.cas(), (boolean)false, (MutationToken)doc.mutationToken(), (Observe.PersistTo)persistTo.value(), (Observe.ReplicateTo)replicateTo.value(), (Delay)CouchbaseAsyncBucket.this.environment.observeIntervalDelay(), (RetryStrategy)CouchbaseAsyncBucket.this.environment.retryStrategy()).map(new Func1<Boolean, D>((Document)doc){
                    final /* synthetic */ Document val$doc;
                    {
                        this.val$doc = document;
                    }

                    public D call(Boolean aBoolean) {
                        return this.val$doc;
                    }
                }).onErrorResumeNext(new Func1<Throwable, Observable<? extends D>>(){

                    public Observable<? extends D> call(Throwable throwable) {
                        return Observable.error((Throwable)((Object)new DurabilityException("Durability requirement failed: " + throwable.getMessage(), throwable)));
                    }
                });
            }
        });
    }

    @Override
    public <D extends Document<?>> Observable<D> remove(final D document) {
        final Transcoder<? extends Document, ?> transcoder = this.transcoders.get(document.getClass());
        return OnSubscribeDeferAndWatch.deferAndWatch(new Func0<Observable<RemoveResponse>>(){

            public Observable<RemoveResponse> call() {
                return CouchbaseAsyncBucket.this.core.send((CouchbaseRequest)new RemoveRequest(document.id(), document.cas(), CouchbaseAsyncBucket.this.bucket));
            }
        }).map(new Func1<RemoveResponse, D>(){

            public D call(RemoveResponse response) {
                if (response.content() != null && response.content().refCnt() > 0) {
                    response.content().release();
                }
                if (response.status().isSuccess()) {
                    return transcoder.newDocument(document.id(), 0, null, response.cas(), response.mutationToken());
                }
                switch (response.status()) {
                    case NOT_EXISTS: {
                        throw new DocumentDoesNotExistException();
                    }
                    case EXISTS: {
                        throw new CASMismatchException();
                    }
                    case TEMPORARY_FAILURE: 
                    case SERVER_BUSY: {
                        throw new TemporaryFailureException();
                    }
                    case OUT_OF_MEMORY: {
                        throw new CouchbaseOutOfMemoryException();
                    }
                }
                throw new CouchbaseException(response.status().toString());
            }
        });
    }

    @Override
    public Observable<JsonDocument> remove(String id) {
        return this.remove(id, JsonDocument.class);
    }

    @Override
    public <D extends Document<?>> Observable<D> remove(String id, Class<D> target) {
        Transcoder<Document, ?> transcoder = this.transcoders.get(target);
        return this.remove(transcoder.newDocument(id, 0, null, 0L));
    }

    @Override
    public <D extends Document<?>> Observable<D> remove(D document, PersistTo persistTo, ReplicateTo replicateTo) {
        return this.observeRemove(this.remove(document), persistTo, replicateTo);
    }

    @Override
    public Observable<JsonDocument> remove(String id, PersistTo persistTo, ReplicateTo replicateTo) {
        return this.remove(id, persistTo, replicateTo, JsonDocument.class);
    }

    @Override
    public <D extends Document<?>> Observable<D> remove(String id, PersistTo persistTo, ReplicateTo replicateTo, Class<D> target) {
        return this.observeRemove(this.remove(id, target), persistTo, replicateTo);
    }

    private <D extends Document<?>> Observable<D> observeRemove(Observable<D> removeResult, final PersistTo persistTo, final ReplicateTo replicateTo) {
        if (persistTo == PersistTo.NONE && replicateTo == ReplicateTo.NONE) {
            return removeResult;
        }
        return removeResult.flatMap(new Func1<D, Observable<D>>(){

            public Observable<D> call(D doc) {
                return Observe.call((ClusterFacade)CouchbaseAsyncBucket.this.core, (String)CouchbaseAsyncBucket.this.bucket, (String)doc.id(), (long)doc.cas(), (boolean)true, (MutationToken)doc.mutationToken(), (Observe.PersistTo)persistTo.value(), (Observe.ReplicateTo)replicateTo.value(), (Delay)CouchbaseAsyncBucket.this.environment.observeIntervalDelay(), (RetryStrategy)CouchbaseAsyncBucket.this.environment.retryStrategy()).map(new Func1<Boolean, D>((Document)doc){
                    final /* synthetic */ Document val$doc;
                    {
                        this.val$doc = document;
                    }

                    public D call(Boolean aBoolean) {
                        return this.val$doc;
                    }
                }).onErrorResumeNext(new Func1<Throwable, Observable<? extends D>>(){

                    public Observable<? extends D> call(Throwable throwable) {
                        return Observable.error((Throwable)((Object)new DurabilityException("Durability requirement failed: " + throwable.getMessage(), throwable)));
                    }
                });
            }
        });
    }

    @Override
    public Observable<AsyncViewResult> query(final ViewQuery query) {
        Observable source = Observable.defer((Func0)new Func0<Observable<ViewQueryResponse>>(){

            public Observable<ViewQueryResponse> call() {
                ViewQueryRequest request = new ViewQueryRequest(query.getDesign(), query.getView(), query.isDevelopment(), query.toQueryString(), query.getKeys(), CouchbaseAsyncBucket.this.bucket, CouchbaseAsyncBucket.this.password);
                return CouchbaseAsyncBucket.this.core.send((CouchbaseRequest)request);
            }
        });
        return ViewRetryHandler.retryOnCondition((Observable<ViewQueryResponse>)source).flatMap((Func1)new Func1<ViewQueryResponse, Observable<AsyncViewResult>>(){

            public Observable<AsyncViewResult> call(ViewQueryResponse response) {
                return ViewQueryResponseMapper.mapToViewResult(CouchbaseAsyncBucket.this, query, response);
            }
        });
    }

    @Override
    public Observable<AsyncSearchQueryResult> query(final SearchQuery query) {
        final String indexName = query.indexName();
        if (query.getServerSideTimeout() == null) {
            query.serverSideTimeout(this.environment().searchTimeout(), TimeUnit.MILLISECONDS);
        }
        Observable source = Observable.defer((Func0)new Func0<Observable<SearchQueryResponse>>(){

            public Observable<SearchQueryResponse> call() {
                SearchQueryRequest request = new SearchQueryRequest(indexName, query.export().toString(), CouchbaseAsyncBucket.this.bucket, CouchbaseAsyncBucket.this.password);
                return CouchbaseAsyncBucket.this.core.send((CouchbaseRequest)request);
            }
        });
        return source.map((Func1)new Func1<SearchQueryResponse, AsyncSearchQueryResult>(){

            public AsyncSearchQueryResult call(SearchQueryResponse response) {
                if (response.status().isSuccess()) {
                    JsonObject json = JsonObject.fromJson(response.payload());
                    return DefaultAsyncSearchQueryResult.fromJson(json);
                }
                if (response.payload().contains("index not found")) {
                    return DefaultAsyncSearchQueryResult.fromIndexNotFound(indexName);
                }
                if (response.status() == ResponseStatus.INVALID_ARGUMENTS) {
                    return DefaultAsyncSearchQueryResult.fromHttp400(response.payload());
                }
                if (response.status() == ResponseStatus.FAILURE) {
                    return DefaultAsyncSearchQueryResult.fromHttp412();
                }
                throw new CouchbaseException("Could not query search index, " + response.status() + ": " + response.payload());
            }
        });
    }

    @Override
    public Observable<AsyncSpatialViewResult> query(final SpatialViewQuery query) {
        Observable source = Observable.defer((Func0)new Func0<Observable<ViewQueryResponse>>(){

            public Observable<ViewQueryResponse> call() {
                ViewQueryRequest request = new ViewQueryRequest(query.getDesign(), query.getView(), query.isDevelopment(), true, query.toString(), null, CouchbaseAsyncBucket.this.bucket, CouchbaseAsyncBucket.this.password);
                return CouchbaseAsyncBucket.this.core.send((CouchbaseRequest)request);
            }
        });
        return ViewRetryHandler.retryOnCondition((Observable<ViewQueryResponse>)source).flatMap((Func1)new Func1<ViewQueryResponse, Observable<AsyncSpatialViewResult>>(){

            public Observable<AsyncSpatialViewResult> call(ViewQueryResponse response) {
                return ViewQueryResponseMapper.mapToSpatialViewResult(CouchbaseAsyncBucket.this, query, response);
            }
        });
    }

    @Override
    public Observable<AsyncN1qlQueryResult> query(Statement statement) {
        return this.query(N1qlQuery.simple(statement));
    }

    @Override
    public Observable<AsyncN1qlQueryResult> query(N1qlQuery query) {
        if (!query.params().hasServerSideTimeout()) {
            query.params().serverSideTimeout(this.environment().queryTimeout(), TimeUnit.MILLISECONDS);
        }
        return this.n1qlQueryExecutor.execute(query);
    }

    @Override
    public Observable<JsonLongDocument> counter(String id, long delta) {
        return this.counter(id, delta, 0L, -1);
    }

    @Override
    public Observable<JsonLongDocument> counter(String id, long delta, long initial) {
        return this.counter(id, delta, initial, 0);
    }

    @Override
    public Observable<JsonLongDocument> counter(final String id, final long delta, final long initial, final int expiry) {
        return OnSubscribeDeferAndWatch.deferAndWatch(new Func0<Observable<CounterResponse>>(){

            public Observable<CounterResponse> call() {
                return CouchbaseAsyncBucket.this.core.send((CouchbaseRequest)new CounterRequest(id, initial, delta, expiry, CouchbaseAsyncBucket.this.bucket));
            }
        }).map((Func1)new Func1<CounterResponse, JsonLongDocument>(){

            public JsonLongDocument call(CounterResponse response) {
                if (response.content() != null && response.content().refCnt() > 0) {
                    response.content().release();
                }
                if (response.status().isSuccess()) {
                    int returnedExpiry = expiry == -1 ? 0 : expiry;
                    return JsonLongDocument.create(id, returnedExpiry, response.value(), response.cas(), response.mutationToken());
                }
                switch (response.status()) {
                    case NOT_EXISTS: {
                        throw new DocumentDoesNotExistException();
                    }
                    case TEMPORARY_FAILURE: 
                    case SERVER_BUSY: {
                        throw new TemporaryFailureException();
                    }
                    case OUT_OF_MEMORY: {
                        throw new CouchbaseOutOfMemoryException();
                    }
                }
                throw new CouchbaseException(response.status().toString());
            }
        });
    }

    @Override
    public Observable<Boolean> unlock(final String id, final long cas) {
        return OnSubscribeDeferAndWatch.deferAndWatch(new Func0<Observable<UnlockResponse>>(){

            public Observable<UnlockResponse> call() {
                return CouchbaseAsyncBucket.this.core.send((CouchbaseRequest)new UnlockRequest(id, cas, CouchbaseAsyncBucket.this.bucket));
            }
        }).map((Func1)new Func1<UnlockResponse, Boolean>(){

            public Boolean call(UnlockResponse response) {
                if (response.content() != null && response.content().refCnt() > 0) {
                    response.content().release();
                }
                if (response.status().isSuccess()) {
                    return true;
                }
                switch (response.status()) {
                    case NOT_EXISTS: {
                        throw new DocumentDoesNotExistException();
                    }
                    case TEMPORARY_FAILURE: {
                        throw new TemporaryLockFailureException();
                    }
                    case SERVER_BUSY: {
                        throw new TemporaryFailureException();
                    }
                    case OUT_OF_MEMORY: {
                        throw new CouchbaseOutOfMemoryException();
                    }
                }
                throw new CouchbaseException(response.status().toString());
            }
        });
    }

    @Override
    public <D extends Document<?>> Observable<Boolean> unlock(D document) {
        return this.unlock(document.id(), document.cas());
    }

    @Override
    public Observable<Boolean> touch(final String id, final int expiry) {
        return OnSubscribeDeferAndWatch.deferAndWatch(new Func0<Observable<TouchResponse>>(){

            public Observable<TouchResponse> call() {
                return CouchbaseAsyncBucket.this.core.send((CouchbaseRequest)new TouchRequest(id, expiry, CouchbaseAsyncBucket.this.bucket));
            }
        }).map((Func1)new Func1<TouchResponse, Boolean>(){

            public Boolean call(TouchResponse response) {
                if (response.content() != null && response.content().refCnt() > 0) {
                    response.content().release();
                }
                if (response.status().isSuccess()) {
                    return true;
                }
                switch (response.status()) {
                    case NOT_EXISTS: {
                        throw new DocumentDoesNotExistException();
                    }
                    case TEMPORARY_FAILURE: 
                    case SERVER_BUSY: {
                        throw new TemporaryFailureException();
                    }
                    case OUT_OF_MEMORY: {
                        throw new CouchbaseOutOfMemoryException();
                    }
                }
                throw new CouchbaseException(response.status().toString());
            }
        });
    }

    @Override
    public <D extends Document<?>> Observable<Boolean> touch(D document) {
        return this.touch(document.id(), document.expiry());
    }

    @Override
    public <D extends Document<?>> Observable<D> append(final D document) {
        final Transcoder<? extends Document, ?> transcoder = this.transcoders.get(document.getClass());
        return OnSubscribeDeferAndWatch.deferAndWatch(new Func0<Observable<AppendResponse>>(){

            public Observable<AppendResponse> call() {
                Tuple2<ByteBuf, Integer> encoded = transcoder.encode(document);
                return CouchbaseAsyncBucket.this.core.send((CouchbaseRequest)new AppendRequest(document.id(), document.cas(), (ByteBuf)encoded.value1(), CouchbaseAsyncBucket.this.bucket));
            }
        }).map(new Func1<AppendResponse, D>(){

            public D call(AppendResponse response) {
                if (response.content() != null && response.content().refCnt() > 0) {
                    response.content().release();
                }
                if (response.status().isSuccess()) {
                    return transcoder.newDocument(document.id(), 0, null, response.cas(), response.mutationToken());
                }
                switch (response.status()) {
                    case TOO_BIG: {
                        throw new RequestTooBigException();
                    }
                    case NOT_STORED: {
                        throw new DocumentDoesNotExistException();
                    }
                    case TEMPORARY_FAILURE: 
                    case SERVER_BUSY: {
                        throw new TemporaryFailureException();
                    }
                    case OUT_OF_MEMORY: {
                        throw new CouchbaseOutOfMemoryException();
                    }
                    case EXISTS: {
                        throw new CASMismatchException();
                    }
                }
                throw new CouchbaseException(response.status().toString());
            }
        });
    }

    @Override
    public <D extends Document<?>> Observable<D> prepend(final D document) {
        final Transcoder<? extends Document, ?> transcoder = this.transcoders.get(document.getClass());
        return OnSubscribeDeferAndWatch.deferAndWatch(new Func0<Observable<PrependResponse>>(){

            public Observable<PrependResponse> call() {
                Tuple2<ByteBuf, Integer> encoded = transcoder.encode(document);
                return CouchbaseAsyncBucket.this.core.send((CouchbaseRequest)new PrependRequest(document.id(), document.cas(), (ByteBuf)encoded.value1(), CouchbaseAsyncBucket.this.bucket));
            }
        }).map(new Func1<PrependResponse, D>(){

            public D call(PrependResponse response) {
                if (response.content() != null && response.content().refCnt() > 0) {
                    response.content().release();
                }
                if (response.status().isSuccess()) {
                    return transcoder.newDocument(document.id(), 0, null, response.cas(), response.mutationToken());
                }
                switch (response.status()) {
                    case TOO_BIG: {
                        throw new RequestTooBigException();
                    }
                    case NOT_STORED: {
                        throw new DocumentDoesNotExistException();
                    }
                    case TEMPORARY_FAILURE: 
                    case SERVER_BUSY: {
                        throw new TemporaryFailureException();
                    }
                    case OUT_OF_MEMORY: {
                        throw new CouchbaseOutOfMemoryException();
                    }
                    case EXISTS: {
                        throw new CASMismatchException();
                    }
                }
                throw new CouchbaseException(response.status().toString());
            }
        });
    }

    @Override
    public Observable<AsyncBucketManager> bucketManager() {
        return Observable.just((Object)this.bucketManager);
    }

    @Override
    public <D extends Document<?>> Observable<D> insert(D document, PersistTo persistTo) {
        return this.insert(document, persistTo, ReplicateTo.NONE);
    }

    @Override
    public <D extends Document<?>> Observable<D> insert(D document, ReplicateTo replicateTo) {
        return this.insert(document, PersistTo.NONE, replicateTo);
    }

    @Override
    public <D extends Document<?>> Observable<D> upsert(D document, PersistTo persistTo) {
        return this.upsert(document, persistTo, ReplicateTo.NONE);
    }

    @Override
    public <D extends Document<?>> Observable<D> upsert(D document, ReplicateTo replicateTo) {
        return this.upsert(document, PersistTo.NONE, replicateTo);
    }

    @Override
    public <D extends Document<?>> Observable<D> replace(D document, PersistTo persistTo) {
        return this.replace(document, persistTo, ReplicateTo.NONE);
    }

    @Override
    public <D extends Document<?>> Observable<D> replace(D document, ReplicateTo replicateTo) {
        return this.replace(document, PersistTo.NONE, replicateTo);
    }

    @Override
    public <D extends Document<?>> Observable<D> remove(D document, PersistTo persistTo) {
        return this.remove(document, persistTo, ReplicateTo.NONE);
    }

    @Override
    public <D extends Document<?>> Observable<D> remove(D document, ReplicateTo replicateTo) {
        return this.remove(document, PersistTo.NONE, replicateTo);
    }

    @Override
    public Observable<JsonDocument> remove(String id, PersistTo persistTo) {
        return this.remove(id, persistTo, ReplicateTo.NONE);
    }

    @Override
    public Observable<JsonDocument> remove(String id, ReplicateTo replicateTo) {
        return this.remove(id, PersistTo.NONE, replicateTo);
    }

    @Override
    public <D extends Document<?>> Observable<D> remove(String id, PersistTo persistTo, Class<D> target) {
        return this.remove(id, persistTo, ReplicateTo.NONE, target);
    }

    @Override
    public <D extends Document<?>> Observable<D> remove(String id, ReplicateTo replicateTo, Class<D> target) {
        return this.remove(id, PersistTo.NONE, replicateTo, target);
    }

    @Override
    public Observable<JsonLongDocument> counter(String id, long delta, PersistTo persistTo) {
        return this.counter(id, delta, persistTo, ReplicateTo.NONE);
    }

    @Override
    public Observable<JsonLongDocument> counter(String id, long delta, ReplicateTo replicateTo) {
        return this.counter(id, delta, PersistTo.NONE, replicateTo);
    }

    @Override
    public Observable<JsonLongDocument> counter(String id, long delta, long initial, PersistTo persistTo) {
        return this.counter(id, delta, initial, persistTo, ReplicateTo.NONE);
    }

    @Override
    public Observable<JsonLongDocument> counter(String id, long delta, long initial, ReplicateTo replicateTo) {
        return this.counter(id, delta, initial, PersistTo.NONE, replicateTo);
    }

    @Override
    public Observable<JsonLongDocument> counter(String id, long delta, long initial, int expiry, PersistTo persistTo) {
        return this.counter(id, delta, initial, expiry, persistTo, ReplicateTo.NONE);
    }

    @Override
    public Observable<JsonLongDocument> counter(String id, long delta, long initial, int expiry, ReplicateTo replicateTo) {
        return this.counter(id, delta, initial, expiry, PersistTo.NONE, replicateTo);
    }

    @Override
    public Observable<JsonLongDocument> counter(String id, long delta, long initial, PersistTo persistTo, ReplicateTo replicateTo) {
        return this.counter(id, delta, initial, 0, persistTo, replicateTo);
    }

    @Override
    public Observable<JsonLongDocument> counter(String id, long delta, PersistTo persistTo, ReplicateTo replicateTo) {
        return this.counter(id, delta, 0L, -1, persistTo, replicateTo);
    }

    @Override
    public Observable<JsonLongDocument> counter(String id, long delta, long initial, int expiry, final PersistTo persistTo, final ReplicateTo replicateTo) {
        Observable<JsonLongDocument> counterResult = this.counter(id, delta, initial, expiry);
        if (persistTo == PersistTo.NONE && replicateTo == ReplicateTo.NONE) {
            return counterResult;
        }
        return counterResult.flatMap((Func1)new Func1<JsonLongDocument, Observable<JsonLongDocument>>(){

            public Observable<JsonLongDocument> call(final JsonLongDocument doc) {
                return Observe.call((ClusterFacade)CouchbaseAsyncBucket.this.core, (String)CouchbaseAsyncBucket.this.bucket, (String)doc.id(), (long)doc.cas(), (boolean)false, (MutationToken)doc.mutationToken(), (Observe.PersistTo)persistTo.value(), (Observe.ReplicateTo)replicateTo.value(), (Delay)CouchbaseAsyncBucket.this.environment.observeIntervalDelay(), (RetryStrategy)CouchbaseAsyncBucket.this.environment.retryStrategy()).map((Func1)new Func1<Boolean, JsonLongDocument>(){

                    public JsonLongDocument call(Boolean aBoolean) {
                        return doc;
                    }
                }).onErrorResumeNext((Func1)new Func1<Throwable, Observable<? extends JsonLongDocument>>(){

                    public Observable<? extends JsonLongDocument> call(Throwable throwable) {
                        return Observable.error((Throwable)((Object)new DurabilityException("Durability requirement failed: " + throwable.getMessage(), throwable)));
                    }
                });
            }
        });
    }

    @Override
    public <D extends Document<?>> Observable<D> append(D document, PersistTo persistTo) {
        return this.append(document, persistTo, ReplicateTo.NONE);
    }

    @Override
    public <D extends Document<?>> Observable<D> append(D document, ReplicateTo replicateTo) {
        return this.append(document, PersistTo.NONE, replicateTo);
    }

    @Override
    public <D extends Document<?>> Observable<D> append(D document, final PersistTo persistTo, final ReplicateTo replicateTo) {
        Observable<D> appendResult = this.append(document);
        if (persistTo == PersistTo.NONE && replicateTo == ReplicateTo.NONE) {
            return appendResult;
        }
        return appendResult.flatMap(new Func1<D, Observable<D>>(){

            public Observable<D> call(D doc) {
                return Observe.call((ClusterFacade)CouchbaseAsyncBucket.this.core, (String)CouchbaseAsyncBucket.this.bucket, (String)doc.id(), (long)doc.cas(), (boolean)false, (MutationToken)doc.mutationToken(), (Observe.PersistTo)persistTo.value(), (Observe.ReplicateTo)replicateTo.value(), (Delay)CouchbaseAsyncBucket.this.environment.observeIntervalDelay(), (RetryStrategy)CouchbaseAsyncBucket.this.environment.retryStrategy()).map(new Func1<Boolean, D>((Document)doc){
                    final /* synthetic */ Document val$doc;
                    {
                        this.val$doc = document;
                    }

                    public D call(Boolean aBoolean) {
                        return this.val$doc;
                    }
                }).onErrorResumeNext(new Func1<Throwable, Observable<? extends D>>(){

                    public Observable<? extends D> call(Throwable throwable) {
                        return Observable.error((Throwable)((Object)new DurabilityException("Durability requirement failed: " + throwable.getMessage(), throwable)));
                    }
                });
            }
        });
    }

    @Override
    public <D extends Document<?>> Observable<D> prepend(D document, PersistTo persistTo) {
        return this.prepend(document, persistTo, ReplicateTo.NONE);
    }

    @Override
    public <D extends Document<?>> Observable<D> prepend(D document, ReplicateTo replicateTo) {
        return this.prepend(document, PersistTo.NONE, replicateTo);
    }

    @Override
    public <D extends Document<?>> Observable<D> prepend(D document, final PersistTo persistTo, final ReplicateTo replicateTo) {
        Observable<D> prependResult = this.prepend(document);
        if (persistTo == PersistTo.NONE && replicateTo == ReplicateTo.NONE) {
            return prependResult;
        }
        return prependResult.flatMap(new Func1<D, Observable<D>>(){

            public Observable<D> call(D doc) {
                return Observe.call((ClusterFacade)CouchbaseAsyncBucket.this.core, (String)CouchbaseAsyncBucket.this.bucket, (String)doc.id(), (long)doc.cas(), (boolean)false, (MutationToken)doc.mutationToken(), (Observe.PersistTo)persistTo.value(), (Observe.ReplicateTo)replicateTo.value(), (Delay)CouchbaseAsyncBucket.this.environment.observeIntervalDelay(), (RetryStrategy)CouchbaseAsyncBucket.this.environment.retryStrategy()).map(new Func1<Boolean, D>((Document)doc){
                    final /* synthetic */ Document val$doc;
                    {
                        this.val$doc = document;
                    }

                    public D call(Boolean aBoolean) {
                        return this.val$doc;
                    }
                }).onErrorResumeNext(new Func1<Throwable, Observable<? extends D>>(){

                    public Observable<? extends D> call(Throwable throwable) {
                        return Observable.error((Throwable)((Object)new DurabilityException("Durability requirement failed: " + throwable.getMessage(), throwable)));
                    }
                });
            }
        });
    }

    @Override
    public AsyncLookupInBuilder lookupIn(String docId) {
        return new AsyncLookupInBuilder(this.core, this.bucket, this.environment, this.subdocumentTranscoder, docId);
    }

    @Override
    public AsyncMutateInBuilder mutateIn(String docId) {
        return new AsyncMutateInBuilder(this.core, this.bucket, this.environment, this.subdocumentTranscoder, docId);
    }

    @Override
    public <V> Observable<V> mapGet(String docId, String key, Class<V> valueType) {
        Func1 mapResult = new Func1<DocumentFragment<Lookup>, V>(){

            public V call(DocumentFragment<Lookup> documentFragment) {
                ResponseStatus status = documentFragment.status(0);
                if (status == ResponseStatus.SUCCESS) {
                    return documentFragment.content(0);
                }
                if (status == ResponseStatus.SUBDOC_PATH_NOT_FOUND) {
                    throw new PathNotFoundException("Key not found in map");
                }
                throw new CouchbaseException(status.toString());
            }
        };
        return this.lookupIn(docId).get(key).execute().map(mapResult);
    }

    @Override
    public <V> Observable<Boolean> mapAdd(String docId, String key, V value) {
        return this.mapAdd(docId, key, value, MutationOptionBuilder.builder());
    }

    @Override
    public <V> Observable<Boolean> mapAdd(String docId, String key, V value, MutationOptionBuilder mutationOptionBuilder) {
        return this.mapSubdocAdd(docId, key, value, mutationOptionBuilder).map(ResultMappingUtils.getMapResultFnForSubdocMutationToBoolean());
    }

    private <V> Observable<DocumentFragment<Mutation>> mapSubdocAdd(final String docId, final String key, final V value, final MutationOptionBuilder mutationOptionBuilder) {
        final Mutation mutationOperation = Mutation.DICT_UPSERT;
        Func1<Throwable, Observable<? extends DocumentFragment<Mutation>>> retryAddIfDocExists = new Func1<Throwable, Observable<? extends DocumentFragment<Mutation>>>(){

            public Observable<? extends DocumentFragment<Mutation>> call(Throwable throwable) {
                if (throwable instanceof DocumentAlreadyExistsException) {
                    return CouchbaseAsyncBucket.this.mapSubdocAdd(docId, key, value, mutationOptionBuilder);
                }
                return Observable.error((Throwable)throwable);
            }
        };
        return this.mutateIn(docId).upsert(key, value, false).withCas(mutationOptionBuilder.cas()).withDurability(mutationOptionBuilder.persistTo(), mutationOptionBuilder.replicateTo()).withExpiry(mutationOptionBuilder.expiry()).execute().onErrorResumeNext((Func1)new Func1<Throwable, Observable<? extends DocumentFragment<Mutation>>>((Func1)retryAddIfDocExists){
            final /* synthetic */ Func1 val$retryAddIfDocExists;
            {
                this.val$retryAddIfDocExists = func1;
            }

            public Observable<? extends DocumentFragment<Mutation>> call(Throwable throwable) {
                if (throwable instanceof DocumentDoesNotExistException) {
                    if (mutationOptionBuilder.createDocument()) {
                        return CouchbaseAsyncBucket.this.insert(JsonDocument.create(docId, mutationOptionBuilder.expiry(), JsonObject.create().put(key, value)), mutationOptionBuilder.persistTo(), mutationOptionBuilder.replicateTo()).map(ResultMappingUtils.getMapFullDocResultToSubDocFn(mutationOperation)).onErrorResumeNext(this.val$retryAddIfDocExists);
                    }
                    return Observable.error((Throwable)throwable);
                }
                if (throwable instanceof MultiMutationException) {
                    ResponseStatus status = ((MultiMutationException)((Object)throwable)).firstFailureStatus();
                    return Observable.just(ResultMappingUtils.convertToSubDocumentResult(status, mutationOperation, value));
                }
                return Observable.error((Throwable)throwable);
            }
        });
    }

    @Override
    public Observable<Boolean> mapRemove(String docId, String key) {
        return this.mapRemove(docId, key, MutationOptionBuilder.builder());
    }

    @Override
    public Observable<Boolean> mapRemove(String docId, String key, MutationOptionBuilder mutationOptionBuilder) {
        Func1<Throwable, Observable<? extends Boolean>> handleSubdocException = new Func1<Throwable, Observable<? extends Boolean>>(){

            public Observable<? extends Boolean> call(Throwable throwable) {
                ResponseStatus status = ((MultiMutationException)((Object)throwable)).firstFailureStatus();
                if (status == ResponseStatus.SUBDOC_PATH_NOT_FOUND) {
                    return Observable.just((Object)true);
                }
                throw new CouchbaseException(status.toString());
            }
        };
        return this.mutateIn(docId).remove(key).withCas(mutationOptionBuilder.cas()).withDurability(mutationOptionBuilder.persistTo(), mutationOptionBuilder.replicateTo()).withExpiry(mutationOptionBuilder.expiry()).execute().map(ResultMappingUtils.getMapResultFnForSubdocMutationToBoolean()).onErrorResumeNext((Func1)handleSubdocException);
    }

    @Override
    public Observable<Integer> mapSize(String docId) {
        return this.get(docId, JsonDocument.class).toList().map((Func1)new Func1<List<JsonDocument>, Integer>(){

            public Integer call(List<JsonDocument> documents) {
                if (documents.size() == 0) {
                    throw new DocumentDoesNotExistException();
                }
                return ((JsonObject)documents.get(0).content()).size();
            }
        });
    }

    @Override
    public <E> Observable<E> listGet(String docId, int index, Class<E> elementType) {
        Func1 mapResult = new Func1<DocumentFragment<Lookup>, E>(){

            public E call(DocumentFragment<Lookup> documentFragment) {
                ResponseStatus status = documentFragment.status(0);
                if (status == ResponseStatus.SUCCESS) {
                    return documentFragment.content(0);
                }
                if (status == ResponseStatus.SUBDOC_PATH_NOT_FOUND) {
                    throw new PathNotFoundException("Index not found in list");
                }
                throw new CouchbaseException(status.toString());
            }
        };
        return this.lookupIn(docId).get("[" + index + "]").execute().map(mapResult);
    }

    @Override
    public <E> Observable<Boolean> listAppend(String docId, E element) {
        return this.listAppend(docId, element, MutationOptionBuilder.builder());
    }

    @Override
    public <E> Observable<Boolean> listAppend(String docId, E element, MutationOptionBuilder mutationOptionBuilder) {
        return this.listSubdocPushLast(docId, element, mutationOptionBuilder).map(ResultMappingUtils.getMapResultFnForSubdocMutationToBoolean());
    }

    private <E> Observable<DocumentFragment<Mutation>> listSubdocPushLast(final String docId, final E element, final MutationOptionBuilder mutationOptionBuilder) {
        final Mutation mutationOperation = Mutation.ARRAY_PUSH_LAST;
        Func1<Throwable, Observable<? extends DocumentFragment<Mutation>>> retryIfDocExists = new Func1<Throwable, Observable<? extends DocumentFragment<Mutation>>>(){

            public Observable<? extends DocumentFragment<Mutation>> call(Throwable throwable) {
                if (throwable instanceof DocumentAlreadyExistsException) {
                    return CouchbaseAsyncBucket.this.listSubdocPushLast(docId, element, mutationOptionBuilder);
                }
                return Observable.error((Throwable)throwable);
            }
        };
        return this.mutateIn(docId).arrayAppend("", element, false).withCas(mutationOptionBuilder.cas()).withDurability(mutationOptionBuilder.persistTo(), mutationOptionBuilder.replicateTo()).withExpiry(mutationOptionBuilder.expiry()).execute().onErrorResumeNext((Func1)new Func1<Throwable, Observable<? extends DocumentFragment<Mutation>>>((Func1)retryIfDocExists){
            final /* synthetic */ Func1 val$retryIfDocExists;
            {
                this.val$retryIfDocExists = func1;
            }

            public Observable<? extends DocumentFragment<Mutation>> call(Throwable throwable) {
                if (throwable instanceof DocumentDoesNotExistException) {
                    if (mutationOptionBuilder.createDocument()) {
                        return CouchbaseAsyncBucket.this.insert(JsonArrayDocument.create(docId, mutationOptionBuilder.expiry(), JsonArray.create().add(element)), mutationOptionBuilder.persistTo(), mutationOptionBuilder.replicateTo()).map(ResultMappingUtils.getMapFullArrayDocResultToSubDocFn(mutationOperation)).onErrorResumeNext(this.val$retryIfDocExists);
                    }
                    return Observable.error((Throwable)throwable);
                }
                if (throwable instanceof MultiMutationException) {
                    ResponseStatus status = ((MultiMutationException)((Object)throwable)).firstFailureStatus();
                    return Observable.just(ResultMappingUtils.convertToSubDocumentResult(status, mutationOperation, element));
                }
                return Observable.error((Throwable)throwable);
            }
        });
    }

    @Override
    public Observable<Boolean> listRemove(String docId, int index) {
        return this.listRemove(docId, index, MutationOptionBuilder.builder());
    }

    @Override
    public Observable<Boolean> listRemove(String docId, int index, MutationOptionBuilder mutationOptionBuilder) {
        return this.listSubdocRemove(docId, index, mutationOptionBuilder).map(ResultMappingUtils.getMapResultFnForSubdocMutationToBoolean());
    }

    private Observable<DocumentFragment<Mutation>> listSubdocRemove(String docId, int index, MutationOptionBuilder mutationOptionBuilder) {
        return this.mutateIn(docId).remove("[" + index + "]").withCas(mutationOptionBuilder.cas()).withExpiry(mutationOptionBuilder.expiry()).withDurability(mutationOptionBuilder.persistTo(), mutationOptionBuilder.replicateTo()).execute();
    }

    @Override
    public <E> Observable<Boolean> listSet(String docId, int index, E element) {
        return this.listSet(docId, index, element, MutationOptionBuilder.builder());
    }

    @Override
    public <E> Observable<Boolean> listSet(String docId, int index, E element, MutationOptionBuilder mutationOptionBuilder) {
        return this.listSubdocInsert(docId, index, element, mutationOptionBuilder).map(ResultMappingUtils.getMapResultFnForSubdocMutationToBoolean());
    }

    private <E> Observable<DocumentFragment<Mutation>> listSubdocInsert(final String docId, final int index, final E element, final MutationOptionBuilder mutationOptionBuilder) {
        final Mutation mutationOperation = Mutation.ARRAY_INSERT;
        Func1<Throwable, Observable<? extends DocumentFragment<Mutation>>> retryIfDocExists = new Func1<Throwable, Observable<? extends DocumentFragment<Mutation>>>(){

            public Observable<? extends DocumentFragment<Mutation>> call(Throwable throwable) {
                if (throwable instanceof DocumentAlreadyExistsException) {
                    return CouchbaseAsyncBucket.this.listSubdocInsert(docId, index, element, mutationOptionBuilder);
                }
                return Observable.error((Throwable)throwable);
            }
        };
        return this.mutateIn(docId).arrayInsert("[" + index + "]", element).withCas(mutationOptionBuilder.cas()).withDurability(mutationOptionBuilder.persistTo(), mutationOptionBuilder.replicateTo()).withExpiry(mutationOptionBuilder.expiry()).execute().onErrorResumeNext((Func1)new Func1<Throwable, Observable<? extends DocumentFragment<Mutation>>>((Func1)retryIfDocExists){
            final /* synthetic */ Func1 val$retryIfDocExists;
            {
                this.val$retryIfDocExists = func1;
            }

            public Observable<? extends DocumentFragment<Mutation>> call(Throwable throwable) {
                if (throwable instanceof DocumentDoesNotExistException) {
                    if (mutationOptionBuilder.createDocument()) {
                        return CouchbaseAsyncBucket.this.insert(JsonArrayDocument.create(docId, mutationOptionBuilder.expiry(), JsonArray.create().add(element)), mutationOptionBuilder.persistTo(), mutationOptionBuilder.replicateTo()).map(ResultMappingUtils.getMapFullArrayDocResultToSubDocFn(mutationOperation)).onErrorResumeNext(this.val$retryIfDocExists);
                    }
                    return Observable.error((Throwable)throwable);
                }
                if (throwable instanceof MultiMutationException) {
                    ResponseStatus status = ((MultiMutationException)((Object)throwable)).firstFailureStatus();
                    return Observable.just(ResultMappingUtils.convertToSubDocumentResult(status, mutationOperation, element));
                }
                return Observable.error((Throwable)throwable);
            }
        });
    }

    @Override
    public <E> Observable<Boolean> listPrepend(String docId, E element) {
        return this.listPrepend(docId, element, MutationOptionBuilder.builder());
    }

    @Override
    public <E> Observable<Boolean> listPrepend(String docId, E element, MutationOptionBuilder mutationOptionBuilder) {
        return this.listSubdocPushFirst(docId, element, mutationOptionBuilder).map(ResultMappingUtils.getMapResultFnForSubdocMutationToBoolean());
    }

    private <E> Observable<DocumentFragment<Mutation>> listSubdocPushFirst(final String docId, final E element, final MutationOptionBuilder mutationOptionBuilder) {
        final Mutation mutationOperation = Mutation.ARRAY_PUSH_FIRST;
        Func1<Throwable, Observable<? extends DocumentFragment<Mutation>>> retryIfDocExists = new Func1<Throwable, Observable<? extends DocumentFragment<Mutation>>>(){

            public Observable<? extends DocumentFragment<Mutation>> call(Throwable throwable) {
                return CouchbaseAsyncBucket.this.listSubdocPushFirst(docId, element, mutationOptionBuilder);
            }
        };
        return this.mutateIn(docId).arrayPrepend("", element, false).withCas(mutationOptionBuilder.cas()).withDurability(mutationOptionBuilder.persistTo(), mutationOptionBuilder.replicateTo()).withExpiry(mutationOptionBuilder.expiry()).execute().onErrorResumeNext((Func1)new Func1<Throwable, Observable<? extends DocumentFragment<Mutation>>>((Func1)retryIfDocExists){
            final /* synthetic */ Func1 val$retryIfDocExists;
            {
                this.val$retryIfDocExists = func1;
            }

            public Observable<? extends DocumentFragment<Mutation>> call(Throwable throwable) {
                if (throwable instanceof DocumentDoesNotExistException) {
                    if (mutationOptionBuilder.createDocument()) {
                        return CouchbaseAsyncBucket.this.insert(JsonArrayDocument.create(docId, mutationOptionBuilder.expiry(), JsonArray.create().add(element)), mutationOptionBuilder.persistTo(), mutationOptionBuilder.replicateTo()).map(ResultMappingUtils.getMapFullArrayDocResultToSubDocFn(mutationOperation)).onErrorResumeNext(this.val$retryIfDocExists);
                    }
                    return Observable.error((Throwable)throwable);
                }
                if (throwable instanceof MultiMutationException) {
                    ResponseStatus status = ((MultiMutationException)((Object)throwable)).firstFailureStatus();
                    return Observable.just(ResultMappingUtils.convertToSubDocumentResult(status, mutationOperation, element));
                }
                return Observable.error((Throwable)throwable);
            }
        });
    }

    @Override
    public Observable<Integer> listSize(String docId) {
        return this.get(docId, JsonArrayDocument.class).toList().map((Func1)new Func1<List<JsonArrayDocument>, Integer>(){

            public Integer call(List<JsonArrayDocument> documents) {
                if (documents.size() == 0) {
                    throw new DocumentDoesNotExistException();
                }
                return ((JsonArray)documents.get(0).content()).size();
            }
        });
    }

    @Override
    public <E> Observable<Boolean> setAdd(String docId, E element) {
        return this.setAdd(docId, element, MutationOptionBuilder.builder());
    }

    @Override
    public <E> Observable<Boolean> setAdd(String docId, E element, MutationOptionBuilder mutationOptionBuilder) {
        Func1<DocumentFragment<Mutation>, Boolean> mapResult = new Func1<DocumentFragment<Mutation>, Boolean>(){

            public Boolean call(DocumentFragment<Mutation> documentFragment) {
                ResponseStatus status = documentFragment.status(0);
                if (status == ResponseStatus.SUCCESS) {
                    return true;
                }
                if (status == ResponseStatus.SUBDOC_PATH_EXISTS) {
                    return false;
                }
                throw new CouchbaseException(status.toString());
            }
        };
        return this.setSubdocAddUnique(docId, element, mutationOptionBuilder).map((Func1)mapResult);
    }

    private <E> Observable<DocumentFragment<Mutation>> setSubdocAddUnique(final String docId, final E element, final MutationOptionBuilder mutationOptionBuilder) {
        final Mutation mutationOperation = Mutation.ARRAY_ADD_UNIQUE;
        Func1<Throwable, Observable<? extends DocumentFragment<Mutation>>> retryIfDocExists = new Func1<Throwable, Observable<? extends DocumentFragment<Mutation>>>(){

            public Observable<? extends DocumentFragment<Mutation>> call(Throwable throwable) {
                if (throwable instanceof DocumentAlreadyExistsException) {
                    return CouchbaseAsyncBucket.this.setSubdocAddUnique(docId, element, mutationOptionBuilder);
                }
                return Observable.error((Throwable)throwable);
            }
        };
        return this.mutateIn(docId).arrayAddUnique("", element, false).withCas(mutationOptionBuilder.cas()).withDurability(mutationOptionBuilder.persistTo(), mutationOptionBuilder.replicateTo()).withExpiry(mutationOptionBuilder.expiry()).execute().onErrorResumeNext((Func1)new Func1<Throwable, Observable<? extends DocumentFragment<Mutation>>>((Func1)retryIfDocExists){
            final /* synthetic */ Func1 val$retryIfDocExists;
            {
                this.val$retryIfDocExists = func1;
            }

            public Observable<? extends DocumentFragment<Mutation>> call(Throwable throwable) {
                if (throwable instanceof DocumentDoesNotExistException) {
                    if (mutationOptionBuilder.createDocument()) {
                        return CouchbaseAsyncBucket.this.insert(JsonArrayDocument.create(docId, mutationOptionBuilder.expiry(), JsonArray.create().add(element)), mutationOptionBuilder.persistTo(), mutationOptionBuilder.replicateTo()).map(ResultMappingUtils.getMapFullArrayDocResultToSubDocFn(mutationOperation)).onErrorResumeNext(this.val$retryIfDocExists);
                    }
                    return Observable.error((Throwable)throwable);
                }
                if (throwable instanceof MultiMutationException) {
                    ResponseStatus status = ((MultiMutationException)((Object)throwable)).firstFailureStatus();
                    return Observable.just(ResultMappingUtils.convertToSubDocumentResult(status, mutationOperation, element));
                }
                return Observable.error((Throwable)throwable);
            }
        });
    }

    @Override
    public <E> Observable<Boolean> setContains(String docId, final E element) {
        return this.get(docId, JsonArrayDocument.class).toList().map((Func1)new Func1<List<JsonArrayDocument>, Boolean>(){

            public Boolean call(List<JsonArrayDocument> documents) {
                if (documents.size() == 0) {
                    throw new DocumentDoesNotExistException();
                }
                JsonArrayDocument document = documents.get(0);
                JsonArray jsonArray = (JsonArray)document.content();
                for (Object next : jsonArray) {
                    if (next == null && element == null) {
                        return true;
                    }
                    if (next == null || !next.equals(element)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    public <E> Observable<E> setRemove(String docId, E element) {
        return this.setRemove(docId, element, MutationOptionBuilder.builder());
    }

    @Override
    public <E> Observable<E> setRemove(String docId, E element, MutationOptionBuilder mutationOptionBuilder) {
        return this.setSubdocRemove(docId, element, mutationOptionBuilder, MAX_CAS_RETRIES_DATASTRUCTURES);
    }

    private <E> Observable<E> setSubdocRemove(final String docId, final E element, final MutationOptionBuilder mutationOptionBuilder, final int retryCount) {
        final Mutation mutationOperation = Mutation.DELETE;
        if (retryCount <= 0) {
            return Observable.error((Throwable)((Object)new CASMismatchException()));
        }
        return this.get(docId, JsonArrayDocument.class).toList().flatMap(new Func1<List<JsonArrayDocument>, Observable<E>>(){

            public Observable<E> call(List<JsonArrayDocument> documents) {
                if (documents.size() == 0) {
                    throw new DocumentDoesNotExistException();
                }
                JsonArrayDocument jsonArrayDocument = documents.get(0);
                Iterator<Object> iterator = ((JsonArray)jsonArrayDocument.content()).iterator();
                int ii = 0;
                int index = -1;
                while (iterator.hasNext()) {
                    Object next = iterator.next();
                    if (next == null && element == null) {
                        index = ii;
                        break;
                    }
                    if (next != null && next.equals(element)) {
                        index = ii;
                        break;
                    }
                    ++ii;
                }
                if (index == -1) {
                    return Observable.just((Object)element);
                }
                Func1<Throwable, Observable<? extends DocumentFragment<Mutation>>> handleCASMismatch = new Func1<Throwable, Observable<? extends DocumentFragment<Mutation>>>(){

                    public Observable<? extends DocumentFragment<Mutation>> call(Throwable throwable) {
                        if (throwable instanceof CASMismatchException) {
                            return CouchbaseAsyncBucket.this.setSubdocRemove(docId, element, mutationOptionBuilder, retryCount - 1).map(new Func1<E, DocumentFragment<Mutation>>(){

                                public DocumentFragment<Mutation> call(E element) {
                                    return ResultMappingUtils.convertToSubDocumentResult(ResponseStatus.SUCCESS, mutationOperation, element);
                                }
                            });
                        }
                        return Observable.error((Throwable)throwable);
                    }
                };
                return CouchbaseAsyncBucket.this.mutateIn(docId).remove("[" + index + "]").withCas(jsonArrayDocument.cas()).withExpiry(mutationOptionBuilder.expiry()).withDurability(mutationOptionBuilder.persistTo(), mutationOptionBuilder.replicateTo()).execute().onErrorResumeNext((Func1)handleCASMismatch).map(new Func1<DocumentFragment<Mutation>, E>(){

                    public E call(DocumentFragment<Mutation> documentFragment) {
                        ResponseStatus status = documentFragment.status(0);
                        if (status == ResponseStatus.SUCCESS) {
                            return element;
                        }
                        if (status == ResponseStatus.SUBDOC_PATH_NOT_FOUND || status == ResponseStatus.SUBDOC_PATH_INVALID) {
                            return element;
                        }
                        throw new CouchbaseException(status.toString());
                    }
                });
            }
        });
    }

    @Override
    public Observable<Integer> setSize(String docId) {
        return this.get(docId, JsonArrayDocument.class).toList().map((Func1)new Func1<List<JsonArrayDocument>, Integer>(){

            public Integer call(List<JsonArrayDocument> documents) {
                if (documents.size() == 0) {
                    throw new DocumentDoesNotExistException();
                }
                return ((JsonArray)documents.get(0).content()).size();
            }
        });
    }

    @Override
    public <E> Observable<Boolean> queuePush(String docId, E element) {
        return this.queuePush(docId, element, MutationOptionBuilder.builder());
    }

    @Override
    public <E> Observable<Boolean> queuePush(String docId, E element, MutationOptionBuilder mutationOptionBuilder) {
        return this.queueSubdocAddFirst(docId, element, mutationOptionBuilder).map(ResultMappingUtils.getMapResultFnForSubdocMutationToBoolean());
    }

    private <E> Observable<DocumentFragment<Mutation>> queueSubdocAddFirst(final String docId, final E element, final MutationOptionBuilder mutationOptionBuilder) {
        final Mutation mutationOperation = Mutation.ARRAY_PUSH_FIRST;
        Func1<Throwable, Observable<? extends DocumentFragment<Mutation>>> retryIfDocExists = new Func1<Throwable, Observable<? extends DocumentFragment<Mutation>>>(){

            public Observable<? extends DocumentFragment<Mutation>> call(Throwable throwable) {
                if (throwable instanceof DocumentAlreadyExistsException) {
                    return CouchbaseAsyncBucket.this.queueSubdocAddFirst(docId, element, mutationOptionBuilder);
                }
                return Observable.error((Throwable)throwable);
            }
        };
        return this.mutateIn(docId).arrayPrepend("", element, false).withCas(mutationOptionBuilder.cas()).withDurability(mutationOptionBuilder.persistTo(), mutationOptionBuilder.replicateTo()).withExpiry(mutationOptionBuilder.expiry()).execute().onErrorResumeNext((Func1)new Func1<Throwable, Observable<? extends DocumentFragment<Mutation>>>((Func1)retryIfDocExists){
            final /* synthetic */ Func1 val$retryIfDocExists;
            {
                this.val$retryIfDocExists = func1;
            }

            public Observable<? extends DocumentFragment<Mutation>> call(Throwable throwable) {
                if (throwable instanceof DocumentDoesNotExistException) {
                    if (mutationOptionBuilder.createDocument()) {
                        return CouchbaseAsyncBucket.this.insert(JsonArrayDocument.create(docId, mutationOptionBuilder.expiry(), JsonArray.create().add(element)), mutationOptionBuilder.persistTo(), mutationOptionBuilder.replicateTo()).map(ResultMappingUtils.getMapFullArrayDocResultToSubDocFn(mutationOperation)).onErrorResumeNext(this.val$retryIfDocExists);
                    }
                    return Observable.error((Throwable)throwable);
                }
                if (throwable instanceof MultiMutationException) {
                    ResponseStatus status = ((MultiMutationException)((Object)throwable)).firstFailureStatus();
                    return Observable.just(ResultMappingUtils.convertToSubDocumentResult(status, mutationOperation, element));
                }
                return Observable.error((Throwable)throwable);
            }
        });
    }

    @Override
    public <E> Observable<E> queuePop(String docId, Class<E> elementType) {
        return this.queuePop(docId, elementType, MutationOptionBuilder.builder());
    }

    @Override
    public <E> Observable<E> queuePop(String docId, Class<E> elementType, MutationOptionBuilder mutationOptionBuilder) {
        return this.queueSubdocRemove(docId, mutationOptionBuilder, elementType, MAX_CAS_RETRIES_DATASTRUCTURES);
    }

    private <E> Observable<E> queueSubdocRemove(final String docId, final MutationOptionBuilder mutationOptionBuilder, final Class<E> elementType, final int retryCount) {
        if (retryCount <= 0) {
            return Observable.error((Throwable)((Object)new CASMismatchException()));
        }
        final Mutation mutationOperation = Mutation.DELETE;
        return this.get(docId, JsonArrayDocument.class).toList().flatMap(new Func1<List<JsonArrayDocument>, Observable<E>>(){

            public Observable<E> call(List<JsonArrayDocument> jsonArrayDocuments) {
                if (jsonArrayDocuments.size() == 0) {
                    throw new DocumentDoesNotExistException();
                }
                JsonArrayDocument jsonArrayDocument = jsonArrayDocuments.get(0);
                int size = ((JsonArray)jsonArrayDocument.content()).size();
                if (size <= 0) {
                    return Observable.just(null);
                }
                final Object val = ((JsonArray)jsonArrayDocument.content()).get(size - 1);
                if (mutationOptionBuilder.cas() != 0L && jsonArrayDocument.cas() != mutationOptionBuilder.cas()) {
                    throw new CASMismatchException();
                }
                Func1<Throwable, Observable<? extends DocumentFragment<Mutation>>> handleCASMismatch = new Func1<Throwable, Observable<? extends DocumentFragment<Mutation>>>(){

                    public Observable<? extends DocumentFragment<Mutation>> call(Throwable throwable) {
                        if (throwable instanceof CASMismatchException) {
                            return CouchbaseAsyncBucket.this.queueSubdocRemove(docId, mutationOptionBuilder, elementType, retryCount - 1).map(new Func1<E, DocumentFragment<Mutation>>(){

                                public DocumentFragment<Mutation> call(E element) {
                                    return ResultMappingUtils.convertToSubDocumentResult(ResponseStatus.SUCCESS, mutationOperation, element);
                                }
                            });
                        }
                        return Observable.error((Throwable)throwable);
                    }
                };
                return CouchbaseAsyncBucket.this.mutateIn(docId).remove("[-1]").withCas(jsonArrayDocument.cas()).withExpiry(mutationOptionBuilder.expiry()).withDurability(mutationOptionBuilder.persistTo(), mutationOptionBuilder.replicateTo()).execute().onErrorResumeNext((Func1)handleCASMismatch).map(new Func1<DocumentFragment<Mutation>, E>(){

                    public E call(DocumentFragment<Mutation> documentFragment) {
                        ResponseStatus status = documentFragment.status(0);
                        if (status == ResponseStatus.SUCCESS) {
                            if (documentFragment.content(0) != null) {
                                return documentFragment.content(0);
                            }
                            return val;
                        }
                        throw new CouchbaseException(status.toString());
                    }
                });
            }
        });
    }

    @Override
    public Observable<Integer> queueSize(String docId) {
        return this.get(docId, JsonArrayDocument.class).toList().map((Func1)new Func1<List<JsonArrayDocument>, Integer>(){

            public Integer call(List<JsonArrayDocument> documents) {
                if (documents.size() == 0) {
                    throw new DocumentDoesNotExistException();
                }
                return ((JsonArray)documents.get(0).content()).size();
            }
        });
    }

    @Override
    public Observable<Boolean> close() {
        return Observable.defer((Func0)new Func0<Observable<CloseBucketResponse>>(){

            public Observable<CloseBucketResponse> call() {
                return CouchbaseAsyncBucket.this.core.send((CouchbaseRequest)new CloseBucketRequest(CouchbaseAsyncBucket.this.bucket));
            }
        }).map((Func1)new Func1<CloseBucketResponse, Boolean>(){

            public Boolean call(CloseBucketResponse response) {
                CouchbaseAsyncBucket.this.closed = true;
                return response.status().isSuccess();
            }
        });
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public String toString() {
        return "AsyncBucket[" + this.name() + "]";
    }

    @Override
    public Observable<Integer> invalidateQueryCache() {
        return Observable.just((Object)this.n1qlQueryExecutor.invalidateQueryCache());
    }
}

