/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.utils.Blocking;
import com.couchbase.client.core.utils.ConnectionString;
import com.couchbase.client.java.AsyncBucket;
import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.CouchbaseAsyncCluster;
import com.couchbase.client.java.CouchbaseBucket;
import com.couchbase.client.java.auth.Authenticator;
import com.couchbase.client.java.auth.Credential;
import com.couchbase.client.java.auth.CredentialContext;
import com.couchbase.client.java.cluster.AsyncClusterManager;
import com.couchbase.client.java.cluster.ClusterManager;
import com.couchbase.client.java.cluster.DefaultClusterManager;
import com.couchbase.client.java.document.Document;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.env.DefaultCouchbaseEnvironment;
import com.couchbase.client.java.error.AuthenticatorException;
import com.couchbase.client.java.query.N1qlQuery;
import com.couchbase.client.java.query.N1qlQueryResult;
import com.couchbase.client.java.query.core.N1qlQueryExecutor;
import com.couchbase.client.java.transcoder.Transcoder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.functions.Action1;
import rx.functions.Func1;

public class CouchbaseCluster
implements Cluster {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(CouchbaseCluster.class);
    private static final TimeUnit TIMEOUT_UNIT = TimeUnit.MILLISECONDS;
    private final CouchbaseAsyncCluster couchbaseAsyncCluster;
    private final CouchbaseEnvironment environment;
    private final ConnectionString connectionString;
    private final Map<String, Bucket> bucketCache;

    public static CouchbaseCluster create() {
        return CouchbaseCluster.create("127.0.0.1");
    }

    public static CouchbaseCluster create(CouchbaseEnvironment environment) {
        return CouchbaseCluster.create(environment, "127.0.0.1");
    }

    public static CouchbaseCluster create(String ... nodes) {
        return CouchbaseCluster.create(Arrays.asList(nodes));
    }

    public static CouchbaseCluster create(List<String> nodes) {
        return new CouchbaseCluster(DefaultCouchbaseEnvironment.create(), ConnectionString.fromHostnames(nodes), false);
    }

    public static CouchbaseCluster create(CouchbaseEnvironment environment, String ... nodes) {
        return CouchbaseCluster.create(environment, Arrays.asList(nodes));
    }

    public static CouchbaseCluster create(CouchbaseEnvironment environment, List<String> nodes) {
        return new CouchbaseCluster(environment, ConnectionString.fromHostnames(nodes), true);
    }

    public static CouchbaseCluster fromConnectionString(String connectionString) {
        return new CouchbaseCluster(DefaultCouchbaseEnvironment.create(), ConnectionString.create((String)connectionString), false);
    }

    public static CouchbaseCluster fromConnectionString(CouchbaseEnvironment environment, String connectionString) {
        return new CouchbaseCluster(environment, ConnectionString.create((String)connectionString), true);
    }

    CouchbaseCluster(CouchbaseEnvironment environment, ConnectionString connectionString, boolean sharedEnvironment) {
        this.couchbaseAsyncCluster = new CouchbaseAsyncCluster(environment, connectionString, sharedEnvironment);
        this.environment = environment;
        this.connectionString = connectionString;
        this.bucketCache = new ConcurrentHashMap<String, Bucket>();
    }

    @Override
    public Bucket openBucket() {
        return this.openBucket("default", null);
    }

    @Override
    public Bucket openBucket(long timeout, TimeUnit timeUnit) {
        return this.openBucket("default", null, timeout, timeUnit);
    }

    @Override
    public Bucket openBucket(String name) {
        return this.openBucket(name, this.environment.connectTimeout(), TIMEOUT_UNIT);
    }

    @Override
    public Bucket openBucket(String name, long timeout, TimeUnit timeUnit) {
        Credential cred;
        block2: {
            cred = new Credential(name, null);
            try {
                cred = this.couchbaseAsyncCluster.getSingleCredential(CredentialContext.BUCKET_KV, name);
            }
            catch (AuthenticatorException e) {
                if (e.foundCredentials() <= 1) break block2;
                throw e;
            }
        }
        return this.openBucket(cred.login(), cred.password(), timeout, timeUnit);
    }

    @Override
    public Bucket openBucket(String name, String password) {
        return this.openBucket(name, password, null);
    }

    @Override
    public Bucket openBucket(String name, String password, long timeout, TimeUnit timeUnit) {
        return this.openBucket(name, password, null, timeout, timeUnit);
    }

    @Override
    public Bucket openBucket(String name, String password, List<Transcoder<? extends Document, ?>> transcoders) {
        return this.openBucket(name, password, transcoders, this.environment.connectTimeout(), TIMEOUT_UNIT);
    }

    @Override
    public Bucket openBucket(final String name, final String password, List<Transcoder<? extends Document, ?>> transcoders, long timeout, TimeUnit timeUnit) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Bucket name is not allowed to be null or empty.");
        }
        Bucket cachedBucket = this.getCachedBucket(name);
        if (cachedBucket != null) {
            return cachedBucket;
        }
        return (Bucket)Blocking.blockForSingle((Observable)this.couchbaseAsyncCluster.openBucket(name, password, transcoders).map((Func1)new Func1<AsyncBucket, Bucket>(){

            public Bucket call(AsyncBucket asyncBucket) {
                CouchbaseBucket bucket = new CouchbaseBucket(asyncBucket, CouchbaseCluster.this.environment, CouchbaseCluster.this.core(), name, password);
                CouchbaseCluster.this.bucketCache.put(name, bucket);
                return bucket;
            }
        }).single(), (long)timeout, (TimeUnit)timeUnit);
    }

    private Bucket getCachedBucket(String name) {
        Bucket cachedBucket = this.bucketCache.get(name);
        if (cachedBucket != null) {
            if (cachedBucket.isClosed()) {
                LOGGER.debug("Not returning cached bucket \"{}\", because it is closed.", (Object)name);
                this.bucketCache.remove(name);
            } else {
                LOGGER.debug("Returning still open, cached bucket \"{}\"", (Object)name);
                return cachedBucket;
            }
        }
        return null;
    }

    @Override
    public ClusterManager clusterManager(final String username, final String password) {
        return (ClusterManager)this.couchbaseAsyncCluster.clusterManager(username, password).map((Func1)new Func1<AsyncClusterManager, ClusterManager>(){

            public ClusterManager call(AsyncClusterManager asyncClusterManager) {
                return DefaultClusterManager.create(username, password, CouchbaseCluster.this.connectionString, CouchbaseCluster.this.environment, CouchbaseCluster.this.core());
            }
        }).toBlocking().single();
    }

    @Override
    public ClusterManager clusterManager() {
        final Credential cred = this.couchbaseAsyncCluster.getSingleCredential(CredentialContext.CLUSTER_MANAGEMENT, null);
        return (ClusterManager)this.couchbaseAsyncCluster.clusterManager(cred.login(), cred.password()).map((Func1)new Func1<AsyncClusterManager, ClusterManager>(){

            public ClusterManager call(AsyncClusterManager asyncClusterManager) {
                return DefaultClusterManager.create(cred.login(), cred.password(), CouchbaseCluster.this.connectionString, CouchbaseCluster.this.environment, CouchbaseCluster.this.core());
            }
        }).toBlocking().single();
    }

    @Override
    public Boolean disconnect() {
        return this.disconnect(this.environment.disconnectTimeout(), TIMEOUT_UNIT);
    }

    @Override
    public Boolean disconnect(long timeout, TimeUnit timeUnit) {
        return (Boolean)Blocking.blockForSingle((Observable)this.couchbaseAsyncCluster.disconnect().doOnNext((Action1)new Action1<Boolean>(){

            public void call(Boolean aBoolean) {
                CouchbaseCluster.this.bucketCache.clear();
            }
        }), (long)timeout, (TimeUnit)timeUnit);
    }

    @Override
    public ClusterFacade core() {
        return (ClusterFacade)this.couchbaseAsyncCluster.core().toBlocking().single();
    }

    @Override
    public CouchbaseCluster authenticate(Authenticator auth) {
        this.couchbaseAsyncCluster.authenticate(auth);
        return this;
    }

    @InterfaceStability.Uncommitted
    @InterfaceAudience.Private
    public Authenticator authenticator() {
        return this.couchbaseAsyncCluster.authenticator();
    }

    @Override
    public N1qlQueryResult query(N1qlQuery query) {
        return this.query(query, this.environment.queryTimeout(), TIMEOUT_UNIT);
    }

    @Override
    public N1qlQueryResult query(N1qlQuery query, long timeout, TimeUnit timeUnit) {
        return (N1qlQueryResult)Blocking.blockForSingle((Observable)this.couchbaseAsyncCluster.query(query).flatMap(N1qlQueryExecutor.ASYNC_RESULT_TO_SYNC), (long)timeout, (TimeUnit)timeUnit);
    }
}

