/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.subdoc;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.message.kv.subdoc.multi.Lookup;
import com.couchbase.client.java.subdoc.AsyncLookupInBuilder;
import com.couchbase.client.java.subdoc.DocumentFragment;
import com.couchbase.client.java.util.Blocking;
import java.util.concurrent.TimeUnit;

@InterfaceStability.Committed
@InterfaceAudience.Public
public class LookupInBuilder {
    private final AsyncLookupInBuilder async;
    private final long defaultTimeout;
    private final TimeUnit defaultTimeUnit;

    @InterfaceAudience.Private
    public LookupInBuilder(AsyncLookupInBuilder async, long defaultTimeout, TimeUnit defaultTimeUnit) {
        this.async = async;
        this.defaultTimeout = defaultTimeout;
        this.defaultTimeUnit = defaultTimeUnit;
    }

    public DocumentFragment<Lookup> execute() {
        return this.execute(this.defaultTimeout, this.defaultTimeUnit);
    }

    public DocumentFragment<Lookup> execute(long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.async.execute(), timeout, timeUnit);
    }

    public LookupInBuilder get(String ... paths) {
        this.async.get(paths);
        return this;
    }

    public LookupInBuilder exists(String ... paths) {
        this.async.exists(paths);
        return this;
    }

    public LookupInBuilder includeRaw(boolean includeRaw) {
        this.async.includeRaw(includeRaw);
        return this;
    }

    public boolean isIncludeRaw() {
        return this.async.isIncludeRaw();
    }

    public String toString() {
        return this.async.toString();
    }
}

