/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.view;

import com.couchbase.client.core.CouchbaseException;
import com.couchbase.client.core.RequestCancelledException;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.view.ViewQueryResponse;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.functions.Func1;

public class ViewRetryHandler {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(ViewRetryHandler.class);
    private static final ShouldRetryViewRequestException SHOULD_RETRY = new ShouldRetryViewRequestException();

    public static Observable<ViewQueryResponse> retryOnCondition(Observable<ViewQueryResponse> input) {
        return input.flatMap((Func1)new Func1<ViewQueryResponse, Observable<ViewQueryResponse>>(){

            public Observable<ViewQueryResponse> call(ViewQueryResponse response) {
                return ViewRetryHandler.passThroughOrThrow(response);
            }
        }).retryWhen(new Func1<Observable<? extends Throwable>, Observable<?>>(){

            public Observable<?> call(Observable<? extends Throwable> observable) {
                return observable.flatMap(new Func1<Throwable, Observable<?>>(){

                    public Observable<?> call(Throwable throwable) {
                        if (throwable instanceof ShouldRetryViewRequestException || throwable instanceof RequestCancelledException) {
                            return Observable.timer((long)10L, (TimeUnit)TimeUnit.MILLISECONDS);
                        }
                        return Observable.error((Throwable)throwable);
                    }
                });
            }
        }).last();
    }

    private static Observable<ViewQueryResponse> passThroughOrThrow(final ViewQueryResponse response) {
        final int responseCode = response.responseCode();
        if (responseCode == 200) {
            return Observable.just((Object)response);
        }
        return response.error().map((Func1)new Func1<String, ViewQueryResponse>(){

            public ViewQueryResponse call(String error) {
                if (ViewRetryHandler.shouldRetry(responseCode, error)) {
                    throw SHOULD_RETRY;
                }
                return response;
            }
        }).singleOrDefault((Object)response);
    }

    private static boolean shouldRetry(int status, String content) {
        switch (status) {
            case 200: {
                return false;
            }
            case 404: {
                return ViewRetryHandler.analyse404Response(content);
            }
            case 500: {
                return ViewRetryHandler.analyse500Response(content);
            }
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 307: 
            case 401: 
            case 408: 
            case 409: 
            case 412: 
            case 416: 
            case 417: 
            case 501: 
            case 502: 
            case 503: 
            case 504: {
                return true;
            }
        }
        LOGGER.info("Received a View HTTP response code ({}) I did not expect, not retrying.", (Object)status);
        return false;
    }

    private static boolean analyse404Response(String content) {
        if (content.contains("\"reason\":\"missing\"")) {
            return true;
        }
        LOGGER.debug("Design document not found, error is {}", (Object)content);
        return false;
    }

    private static boolean analyse500Response(String content) {
        if (content.contains("error") && content.contains("{not_found, missing_named_view}")) {
            LOGGER.debug("Design document not found, error is {}", (Object)content);
            return false;
        }
        if (content.contains("error") && content.contains("\"badarg\"")) {
            LOGGER.debug("Malformed view query");
            return false;
        }
        return true;
    }

    static {
        SHOULD_RETRY.setStackTrace(new StackTraceElement[0]);
    }

    private static class ShouldRetryViewRequestException
    extends CouchbaseException {
        private ShouldRetryViewRequestException() {
        }
    }
}

