/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.result.impl;

import com.couchbase.client.core.CouchbaseException;
import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.search.result.AsyncSearchQueryResult;
import com.couchbase.client.java.search.result.SearchMetrics;
import com.couchbase.client.java.search.result.SearchQueryRow;
import com.couchbase.client.java.search.result.SearchStatus;
import com.couchbase.client.java.search.result.facets.DateRange;
import com.couchbase.client.java.search.result.facets.DefaultDateRangeFacetResult;
import com.couchbase.client.java.search.result.facets.DefaultNumericRangeFacetResult;
import com.couchbase.client.java.search.result.facets.DefaultTermFacetResult;
import com.couchbase.client.java.search.result.facets.FacetResult;
import com.couchbase.client.java.search.result.facets.NumericRange;
import com.couchbase.client.java.search.result.facets.TermRange;
import com.couchbase.client.java.search.result.hits.DefaultHitLocations;
import com.couchbase.client.java.search.result.hits.HitLocations;
import com.couchbase.client.java.search.result.impl.DefaultSearchMetrics;
import com.couchbase.client.java.search.result.impl.DefaultSearchQueryRow;
import com.couchbase.client.java.search.result.impl.DefaultSearchStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import rx.Observable;
import rx.exceptions.CompositeException;

@InterfaceStability.Experimental
@InterfaceAudience.Public
public class DefaultAsyncSearchQueryResult
implements AsyncSearchQueryResult {
    private final SearchStatus status;
    private final Observable<SearchQueryRow> hits;
    private final Observable<FacetResult> facets;
    private final Observable<SearchMetrics> metrics;

    public DefaultAsyncSearchQueryResult(SearchStatus status, Observable<SearchQueryRow> hits, Observable<FacetResult> facets, Observable<SearchMetrics> metrics) {
        this.status = status;
        this.hits = hits;
        this.facets = facets;
        this.metrics = metrics;
    }

    @Override
    public SearchStatus status() {
        return this.status;
    }

    @Override
    public Observable<SearchQueryRow> hits() {
        return this.hits;
    }

    @Override
    public Observable<FacetResult> facets() {
        return this.facets;
    }

    @Override
    public Observable<SearchMetrics> metrics() {
        return this.metrics;
    }

    @Deprecated
    public static AsyncSearchQueryResult fromJson(JsonObject json) {
        Observable errors;
        JsonArray errorsJson;
        List facets;
        JsonObject jsonStatus = json.getObject("status");
        DefaultSearchStatus status = new DefaultSearchStatus(jsonStatus.getLong("total"), jsonStatus.getLong("failed"), jsonStatus.getLong("successful"));
        long totalHits = json.getLong("total_hits");
        long took = json.getLong("took");
        double maxScore = json.getDouble("max_score");
        DefaultSearchMetrics metrics = new DefaultSearchMetrics(took, totalHits, maxScore);
        ArrayList<DefaultSearchQueryRow> hits = new ArrayList<DefaultSearchQueryRow>();
        for (Object rawHit : json.getArray("hits")) {
            Map<String, String> fields;
            JsonObject fieldsJson;
            Map<String, List<String>> fragments;
            JsonObject hit = (JsonObject)rawHit;
            String index = hit.getString("index");
            String id = hit.getString("id");
            double score = hit.getDouble("score");
            JsonObject explanationJson = hit.getObject("explanation");
            if (explanationJson == null) {
                explanationJson = JsonObject.empty();
            }
            HitLocations locations = DefaultHitLocations.from(hit.getObject("locations"));
            JsonObject fragmentsJson = hit.getObject("fragments");
            if (fragmentsJson != null) {
                fragments = new HashMap(fragmentsJson.size());
                for (String field : fragmentsJson.getNames()) {
                    ArrayList<String> fragment;
                    JsonArray fragmentJson = fragmentsJson.getArray(field);
                    if (fragmentJson != null) {
                        fragment = new ArrayList<String>(fragmentJson.size());
                        for (int i = 0; i < fragmentJson.size(); ++i) {
                            fragment.add(fragmentJson.getString(i));
                        }
                    } else {
                        fragment = Collections.emptyList();
                    }
                    fragments.put(field, fragment);
                }
            } else {
                fragments = Collections.emptyMap();
            }
            if ((fieldsJson = hit.getObject("fields")) != null) {
                fields = new HashMap(fieldsJson.size());
                for (String f : fieldsJson.getNames()) {
                    fields.put(f, String.valueOf(fieldsJson.get(f)));
                }
            } else {
                fields = Collections.emptyMap();
            }
            hits.add(new DefaultSearchQueryRow(index, id, score, explanationJson, locations, fragments, fields));
        }
        JsonObject facetsJson = json.getObject("facets");
        if (facetsJson != null) {
            facets = new ArrayList(facetsJson.size());
            for (String facetName : facetsJson.getNames()) {
                List<TermRange> tr;
                JsonObject r;
                JsonArray rangesJson;
                JsonObject facetJson = facetsJson.getObject(facetName);
                String field = facetJson.getString("field");
                long total = facetJson.getLong("total");
                long missing = facetJson.getLong("missing");
                long other = facetJson.getLong("other");
                if (facetJson.containsKey("numeric_ranges")) {
                    rangesJson = facetJson.getArray("numeric_ranges");
                    ArrayList<NumericRange> nr = new ArrayList<NumericRange>(rangesJson.size());
                    for (Object o : rangesJson) {
                        r = (JsonObject)o;
                        nr.add(new NumericRange(r.getString("name"), r.getDouble("min"), r.getDouble("max"), r.getLong("count")));
                    }
                    facets.add(new DefaultNumericRangeFacetResult(facetName, field, total, missing, other, nr));
                    continue;
                }
                if (facetJson.containsKey("date_ranges")) {
                    rangesJson = facetJson.getArray("date_ranges");
                    ArrayList<DateRange> dr = new ArrayList<DateRange>(rangesJson.size());
                    for (Object o : rangesJson) {
                        r = (JsonObject)o;
                        dr.add(new DateRange(r.getString("name"), r.getString("start"), r.getString("end"), r.getLong("count")));
                    }
                    facets.add(new DefaultDateRangeFacetResult(facetName, field, total, missing, other, dr));
                    continue;
                }
                JsonArray rangesJson2 = facetJson.getArray("terms");
                if (rangesJson2 == null) {
                    tr = Collections.emptyList();
                } else {
                    tr = new ArrayList(rangesJson2.size());
                    for (Object o : rangesJson2) {
                        r = (JsonObject)o;
                        tr.add(new TermRange(r.getString("term"), r.getLong("count")));
                    }
                }
                facets.add(new DefaultTermFacetResult(facetName, field, total, missing, other, tr));
            }
        } else {
            facets = Collections.emptyList();
        }
        if ((errorsJson = jsonStatus.getArray("errors")) != null) {
            ArrayList<RuntimeException> exceptions = new ArrayList<RuntimeException>(errorsJson.size());
            for (Object o : errorsJson) {
                exceptions.add(new RuntimeException(String.valueOf(o)));
            }
            errors = Observable.error((Throwable)new CompositeException(exceptions));
        } else {
            errors = Observable.empty();
        }
        return new DefaultAsyncSearchQueryResult(status, (Observable<SearchQueryRow>)Observable.from(hits).concatWith(errors), (Observable<FacetResult>)Observable.from(facets), (Observable<SearchMetrics>)Observable.just((Object)metrics));
    }

    @Deprecated
    public static AsyncSearchQueryResult fromHttp400(String payload) {
        DefaultSearchStatus status = new DefaultSearchStatus(1L, 1L, 0L);
        DefaultSearchMetrics metrics = new DefaultSearchMetrics(0L, 0L, 0.0);
        return new DefaultAsyncSearchQueryResult(status, (Observable<SearchQueryRow>)Observable.error((Throwable)new CouchbaseException(payload)), (Observable<FacetResult>)Observable.empty(), (Observable<SearchMetrics>)Observable.just((Object)metrics));
    }
}

