/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.queries;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.search.queries.AbstractFtsQuery;

@InterfaceStability.Experimental
@InterfaceAudience.Public
public class NumericRangeQuery
extends AbstractFtsQuery {
    private Double min;
    private Double max;
    private Boolean inclusiveMin = null;
    private Boolean inclusiveMax = null;
    private String field;

    public NumericRangeQuery min(double min, boolean inclusive) {
        this.min = min;
        this.inclusiveMin = inclusive;
        return this;
    }

    public NumericRangeQuery min(double min) {
        this.min = min;
        this.inclusiveMin = null;
        return this;
    }

    public NumericRangeQuery max(double max, boolean inclusive) {
        this.max = max;
        this.inclusiveMax = inclusive;
        return this;
    }

    public NumericRangeQuery max(double max) {
        this.max = max;
        this.inclusiveMax = null;
        return this;
    }

    public NumericRangeQuery field(String field) {
        this.field = field;
        return this;
    }

    @Override
    public NumericRangeQuery boost(double boost) {
        super.boost(boost);
        return this;
    }

    @Override
    protected void injectParams(JsonObject input) {
        if (this.min == null && this.max == null) {
            throw new NullPointerException("NumericRangeQuery needs at least one of min or max");
        }
        if (this.min != null) {
            input.put("min", this.min);
            if (this.inclusiveMin != null) {
                input.put("inclusive_min", this.inclusiveMin);
            }
        }
        if (this.max != null) {
            input.put("max", this.max);
            if (this.inclusiveMax != null) {
                input.put("inclusive_max", this.inclusiveMax);
            }
        }
        if (this.field != null) {
            input.put("field", this.field);
        }
    }
}

