/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.query.dsl.functions;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.query.dsl.Expression;

@InterfaceStability.Experimental
@InterfaceAudience.Public
public class ArrayFunctions {
    public static Expression arrayAppend(Expression expression, Expression value) {
        return Expression.x("ARRAY_APPEND(" + expression.toString() + ", " + value.toString() + ")");
    }

    public static Expression arrayAppend(String expression, Expression value) {
        return ArrayFunctions.arrayAppend(Expression.x(expression), value);
    }

    public static Expression arrayAppend(JsonArray array, Expression value) {
        return ArrayFunctions.arrayAppend(Expression.x(array), value);
    }

    public static Expression arrayAvg(Expression expression) {
        return Expression.x("ARRAY_AVG(" + expression.toString() + ")");
    }

    public static Expression arrayAvg(String expression) {
        return ArrayFunctions.arrayAvg(Expression.x(expression));
    }

    public static Expression arrayAvg(JsonArray array) {
        return ArrayFunctions.arrayAvg(Expression.x(array));
    }

    public static Expression arrayConcat(Expression expression1, Expression expression2) {
        return Expression.x("ARRAY_CONCAT(" + expression1.toString() + ", " + expression2.toString() + ")");
    }

    public static Expression arrayConcat(String expression1, String expression2) {
        return ArrayFunctions.arrayConcat(Expression.x(expression1), Expression.x(expression2));
    }

    public static Expression arrayConcat(JsonArray array1, JsonArray array2) {
        return ArrayFunctions.arrayConcat(Expression.x(array1), Expression.x(array2));
    }

    public static Expression arrayContains(Expression expression, Expression value) {
        return Expression.x("ARRAY_CONTAINS(" + expression.toString() + ", " + value.toString() + ")");
    }

    public static Expression arrayContains(String expression, Expression value) {
        return ArrayFunctions.arrayContains(Expression.x(expression), value);
    }

    public static Expression arrayContains(JsonArray array, Expression value) {
        return ArrayFunctions.arrayContains(Expression.x(array), value);
    }

    public static Expression arrayCount(Expression expression) {
        return Expression.x("ARRAY_COUNT(" + expression.toString() + ")");
    }

    public static Expression arrayCount(String expression) {
        return ArrayFunctions.arrayCount(Expression.x(expression));
    }

    public static Expression arrayCount(JsonArray array) {
        return ArrayFunctions.arrayCount(Expression.x(array));
    }

    public static Expression arrayDistinct(Expression expression) {
        return Expression.x("ARRAY_DISTINCT(" + expression.toString() + ")");
    }

    public static Expression arrayDistinct(String expression) {
        return ArrayFunctions.arrayDistinct(Expression.x(expression));
    }

    public static Expression arrayDistinct(JsonArray array) {
        return ArrayFunctions.arrayDistinct(Expression.x(array));
    }

    public static Expression arrayIfNull(Expression expression) {
        return Expression.x("ARRAY_IFNULL(" + expression.toString() + ")");
    }

    public static Expression arrayIfNull(String expression) {
        return ArrayFunctions.arrayIfNull(Expression.x(expression));
    }

    public static Expression arrayIfNull(JsonArray array) {
        return ArrayFunctions.arrayIfNull(Expression.x(array));
    }

    public static Expression arrayLength(Expression expression) {
        return Expression.x("ARRAY_LENGTH(" + expression.toString() + ")");
    }

    public static Expression arrayLength(String expression) {
        return ArrayFunctions.arrayLength(Expression.x(expression));
    }

    public static Expression arrayLength(JsonArray array) {
        return ArrayFunctions.arrayLength(Expression.x(array));
    }

    public static Expression arrayMax(Expression expression) {
        return Expression.x("ARRAY_MAX(" + expression.toString() + ")");
    }

    public static Expression arrayMax(String expression) {
        return ArrayFunctions.arrayMax(Expression.x(expression));
    }

    public static Expression arrayMax(JsonArray array) {
        return ArrayFunctions.arrayMax(Expression.x(array));
    }

    public static Expression arrayMin(Expression expression) {
        return Expression.x("ARRAY_MIN(" + expression.toString() + ")");
    }

    public static Expression arrayMin(String expression) {
        return ArrayFunctions.arrayMin(Expression.x(expression));
    }

    public static Expression arrayMin(JsonArray array) {
        return ArrayFunctions.arrayMin(Expression.x(array));
    }

    public static Expression arrayPosition(Expression expression, Expression value) {
        return Expression.x("ARRAY_POSITION(" + expression.toString() + ", " + value.toString() + ")");
    }

    public static Expression arrayPosition(String expression, Expression value) {
        return ArrayFunctions.arrayPosition(Expression.x(expression), value);
    }

    public static Expression arrayPosition(JsonArray array, Expression value) {
        return ArrayFunctions.arrayPosition(Expression.x(array), value);
    }

    public static Expression arrayPrepend(Expression expression, Expression value) {
        return Expression.x("ARRAY_PREPEND(" + value.toString() + ", " + expression.toString() + ")");
    }

    public static Expression arrayPrepend(String expression, Expression value) {
        return ArrayFunctions.arrayPrepend(Expression.x(expression), value);
    }

    public static Expression arrayPrepend(JsonArray array, Expression value) {
        return ArrayFunctions.arrayPrepend(Expression.x(array), value);
    }

    public static Expression arrayPut(Expression expression, Expression value) {
        return Expression.x("ARRAY_PUT(" + expression.toString() + ", " + value.toString() + ")");
    }

    public static Expression arrayPut(String expression, Expression value) {
        return ArrayFunctions.arrayPut(Expression.x(expression), value);
    }

    public static Expression arrayPut(JsonArray array, Expression value) {
        return ArrayFunctions.arrayPut(Expression.x(array), value);
    }

    public static Expression arrayRange(long start, long end, long step) {
        return Expression.x("ARRAY_RANGE(" + start + ", " + end + ", " + step + ")");
    }

    public static Expression arrayRange(long start, long end) {
        return Expression.x("ARRAY_RANGE(" + start + ", " + end + ")");
    }

    public static Expression arrayRemove(Expression expression, Expression value) {
        return Expression.x("ARRAY_REMOVE(" + expression.toString() + ", " + value.toString() + ")");
    }

    public static Expression arrayRemove(String expression, Expression value) {
        return ArrayFunctions.arrayRemove(Expression.x(expression), value);
    }

    public static Expression arrayRemove(JsonArray array, Expression value) {
        return ArrayFunctions.arrayRemove(Expression.x(array), value);
    }

    public static Expression arrayRepeat(Expression value, long n) {
        return Expression.x("ARRAY_REPEAT(" + value.toString() + ", " + n + ")");
    }

    public static Expression arrayRepeat(String value, long n) {
        return ArrayFunctions.arrayRepeat(Expression.s(value), n);
    }

    public static Expression arrayRepeat(Number value, long n) {
        return ArrayFunctions.arrayRepeat(Expression.x(value), n);
    }

    public static Expression arrayRepeat(boolean value, long n) {
        return ArrayFunctions.arrayRepeat(Expression.x(value), n);
    }

    public static Expression arrayReplace(Expression expression, Expression value1, Expression value2) {
        return Expression.x("ARRAY_REPLACE(" + expression.toString() + ", " + value1 + ", " + value2 + ")");
    }

    public static Expression arrayReplace(String expression, Expression value1, Expression value2) {
        return ArrayFunctions.arrayReplace(Expression.x(expression), value1, value2);
    }

    public static Expression arrayReplace(JsonArray array, Expression value1, Expression value2) {
        return ArrayFunctions.arrayReplace(Expression.x(array), value1, value2);
    }

    public static Expression arrayReplace(Expression expression, Expression value1, Expression value2, long n) {
        return Expression.x("ARRAY_REPLACE(" + expression.toString() + ", " + value1 + ", " + value2 + ", " + n + ")");
    }

    public static Expression arrayReplace(String expression, Expression value1, Expression value2, long n) {
        return ArrayFunctions.arrayReplace(Expression.x(expression), value1, value2, n);
    }

    public static Expression arrayReplace(JsonArray array, Expression value1, Expression value2, long n) {
        return ArrayFunctions.arrayReplace(Expression.x(array), value1, value2, n);
    }

    public static Expression arrayReverse(Expression expression) {
        return Expression.x("ARRAY_REVERSE(" + expression.toString() + ")");
    }

    public static Expression arrayReverse(String expression) {
        return ArrayFunctions.arrayReverse(Expression.x(expression));
    }

    public static Expression arrayReverse(JsonArray array) {
        return ArrayFunctions.arrayReverse(Expression.x(array));
    }

    public static Expression arraySort(Expression expression) {
        return Expression.x("ARRAY_SORT(" + expression.toString() + ")");
    }

    public static Expression arraySort(String expression) {
        return ArrayFunctions.arraySort(Expression.x(expression));
    }

    public static Expression arraySort(JsonArray array) {
        return ArrayFunctions.arraySort(Expression.x(array));
    }

    public static Expression arraySum(Expression expression) {
        return Expression.x("ARRAY_SUM(" + expression.toString() + ")");
    }

    public static Expression arraySum(String expression) {
        return ArrayFunctions.arraySum(Expression.x(expression));
    }

    public static Expression arraySum(JsonArray array) {
        return ArrayFunctions.arraySum(Expression.x(array));
    }
}

