/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.query;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.query.dsl.path.index.BuildIndexPath;
import com.couchbase.client.java.query.dsl.path.index.DefaultBuildIndexPath;
import com.couchbase.client.java.query.dsl.path.index.DefaultCreateIndexPath;
import com.couchbase.client.java.query.dsl.path.index.DefaultDropPath;
import com.couchbase.client.java.query.dsl.path.index.OnPath;
import com.couchbase.client.java.query.dsl.path.index.OnPrimaryPath;
import com.couchbase.client.java.query.dsl.path.index.UsingPath;

@InterfaceStability.Experimental
@InterfaceAudience.Public
public class Index {
    public static final String PRIMARY_NAME = "#primary";

    public static OnPath createIndex(String indexName) {
        return new DefaultCreateIndexPath().create(indexName);
    }

    public static OnPrimaryPath createPrimaryIndex() {
        return new DefaultCreateIndexPath().createPrimary();
    }

    public static BuildIndexPath buildIndex() {
        return new DefaultBuildIndexPath();
    }

    public static UsingPath dropIndex(String namespace, String keyspace, String indexName) {
        return new DefaultDropPath().drop(namespace, keyspace, indexName);
    }

    public static UsingPath dropIndex(String keyspace, String indexName) {
        return new DefaultDropPath().drop(keyspace, indexName);
    }

    public static UsingPath dropPrimaryIndex(String namespace, String keyspace) {
        return new DefaultDropPath().dropPrimary(namespace, keyspace);
    }

    public static UsingPath dropPrimaryIndex(String keyspace) {
        return new DefaultDropPath().dropPrimary(keyspace);
    }
}

