/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.document.subdoc;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.message.kv.subdoc.multi.Mutation;
import com.couchbase.client.java.document.subdoc.ExtendDirection;

@InterfaceStability.Experimental
@InterfaceAudience.Public
public class MutationSpec<T> {
    private final Mutation type;
    private final String path;
    private final T fragment;
    private final boolean createParents;

    private MutationSpec(Mutation type, String path, T fragment, boolean createParents) {
        this.type = type;
        this.path = path;
        this.fragment = fragment;
        this.createParents = createParents;
    }

    public Mutation type() {
        return this.type;
    }

    public String path() {
        return this.path;
    }

    public T fragment() {
        return this.fragment;
    }

    public boolean createParents() {
        return this.createParents;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{").append(this.type());
        if (this.createParents) {
            sb.append(", createParents");
        }
        sb.append(':').append(this.path()).append('}');
        return sb.toString();
    }

    public static <T> MutationSpec replace(String path, T fragment) {
        return new MutationSpec<T>(Mutation.REPLACE, path, fragment, false);
    }

    public static <T> MutationSpec upsert(String path, T fragment, boolean createParents) {
        return new MutationSpec<T>(Mutation.DICT_UPSERT, path, fragment, createParents);
    }

    public static <T> MutationSpec insert(String path, T fragment, boolean createParents) {
        return new MutationSpec<T>(Mutation.DICT_ADD, path, fragment, createParents);
    }

    public static <T> MutationSpec extend(String path, T value, ExtendDirection direction, boolean createParents) {
        if (direction == ExtendDirection.FRONT) {
            return new MutationSpec<T>(Mutation.ARRAY_PUSH_FIRST, path, value, createParents);
        }
        return new MutationSpec<T>(Mutation.ARRAY_PUSH_LAST, path, value, createParents);
    }

    public static <T> MutationSpec arrayInsert(String path, T value) {
        return new MutationSpec<T>(Mutation.ARRAY_INSERT, path, value, false);
    }

    public static <T> MutationSpec addUnique(String path, T value, boolean createParents) {
        return new MutationSpec<T>(Mutation.ARRAY_ADD_UNIQUE, path, value, createParents);
    }

    public static MutationSpec<Long> counter(String path, long delta, boolean createParents) {
        return new MutationSpec<Long>(Mutation.COUNTER, path, delta, createParents);
    }

    public static <T> MutationSpec remove(String path) {
        return new MutationSpec<Object>(Mutation.DELETE, path, null, false);
    }
}

