/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.document.subdoc;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.core.message.kv.subdoc.multi.Lookup;

@InterfaceStability.Experimental
@InterfaceAudience.Public
public class LookupResult {
    private final String path;
    private final Lookup operation;
    private final ResponseStatus status;
    private final Object value;

    private LookupResult(String path, Lookup operation, ResponseStatus status, Object value) {
        this.path = path;
        this.operation = operation;
        this.status = status;
        this.value = value;
    }

    public static LookupResult createFatal(String path, Lookup operation, RuntimeException fatal) {
        return new LookupResult(path, operation, ResponseStatus.FAILURE, fatal);
    }

    public static LookupResult createGetResult(String path, ResponseStatus status, Object value) {
        return new LookupResult(path, Lookup.GET, status, value);
    }

    public static LookupResult createExistResult(String path, ResponseStatus status) {
        return new LookupResult(path, Lookup.EXIST, status, status.isSuccess());
    }

    public String path() {
        return this.path;
    }

    public Lookup operation() {
        return this.operation;
    }

    public ResponseStatus status() {
        return this.status;
    }

    public boolean exists() {
        return this.status.isSuccess();
    }

    public Object value() {
        return this.value;
    }

    public boolean isFatal() {
        return this.status == ResponseStatus.FAILURE;
    }

    public Object valueOrThrow() {
        if (this.isFatal()) {
            throw (RuntimeException)this.value;
        }
        return this.value;
    }
}

