/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.transcoder;

import com.couchbase.client.core.lang.Tuple;
import com.couchbase.client.core.lang.Tuple2;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.java.document.JsonArrayDocument;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.error.TranscodingException;
import com.couchbase.client.java.transcoder.AbstractTranscoder;
import com.couchbase.client.java.transcoder.JacksonTransformers;
import com.couchbase.client.java.transcoder.TranscoderUtils;

public class JsonArrayTranscoder
extends AbstractTranscoder<JsonArrayDocument, JsonArray> {
    @Override
    public Class<JsonArrayDocument> documentType() {
        return JsonArrayDocument.class;
    }

    @Override
    protected Tuple2<ByteBuf, Integer> doEncode(JsonArrayDocument document) throws Exception {
        return Tuple.create((Object)this.jsonArrayToByteBuf((JsonArray)document.content()), (Object)TranscoderUtils.JSON_COMMON_FLAGS);
    }

    @Override
    protected JsonArrayDocument doDecode(String id, ByteBuf content, long cas, int expiry, int flags, ResponseStatus status) throws Exception {
        if (!TranscoderUtils.hasJsonFlags(flags)) {
            throw new TranscodingException("Flags (0x" + Integer.toHexString(flags) + ") indicate non-JSON array document for " + "id " + id + ", could not decode.");
        }
        return this.newDocument(id, expiry, this.byteBufToJsonArray(content), cas);
    }

    @Override
    public JsonArrayDocument newDocument(String id, int expiry, JsonArray content, long cas) {
        return JsonArrayDocument.create(id, expiry, content, cas);
    }

    public String jsonArrayToString(JsonArray input) throws Exception {
        return JacksonTransformers.MAPPER.writeValueAsString((Object)input);
    }

    public ByteBuf jsonArrayToByteBuf(JsonArray input) throws Exception {
        return Unpooled.wrappedBuffer((byte[])JacksonTransformers.MAPPER.writeValueAsBytes((Object)input));
    }

    public JsonArray stringToJsonArray(String input) throws Exception {
        return (JsonArray)JacksonTransformers.MAPPER.readValue(input, JsonArray.class);
    }

    public JsonArray byteBufToJsonArray(ByteBuf input) throws Exception {
        byte[] inputBytes;
        int offset = 0;
        int length = input.readableBytes();
        if (input.hasArray()) {
            inputBytes = input.array();
            offset = input.arrayOffset() + input.readerIndex();
        } else {
            inputBytes = new byte[length];
            input.getBytes(input.readerIndex(), inputBytes);
        }
        return (JsonArray)JacksonTransformers.MAPPER.readValue(inputBytes, offset, length, JsonArray.class);
    }
}

