/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.view;

import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.view.DefaultView;
import com.couchbase.client.java.view.SpatialView;
import com.couchbase.client.java.view.View;
import java.util.ArrayList;
import java.util.List;

public class DesignDocument {
    private final String name;
    private final List<View> views;

    protected DesignDocument(String name, List<View> views) {
        this.name = name;
        this.views = views;
    }

    public static DesignDocument create(String name, List<View> views) {
        return new DesignDocument(name, views);
    }

    public static DesignDocument from(String name, JsonObject raw) {
        JsonObject spatialViews;
        String map;
        ArrayList<View> views = new ArrayList<View>();
        JsonObject rawViews = raw.getObject("views");
        if (rawViews != null) {
            for (String viewName : rawViews.getNames()) {
                JsonObject viewContent = rawViews.getObject(viewName);
                map = viewContent.getString("map");
                String reduce = viewContent.getString("reduce");
                views.add(DefaultView.create(viewName, map, reduce));
            }
        }
        if ((spatialViews = raw.getObject("spatial")) != null) {
            for (String viewName : spatialViews.getNames()) {
                map = spatialViews.getString(viewName);
                views.add(SpatialView.create(viewName, map));
            }
        }
        return new DesignDocument(name, views);
    }

    public String name() {
        return this.name;
    }

    public List<View> views() {
        return this.views;
    }

    public String toString() {
        return "DesignDocument{name='" + this.name + '\'' + ", views=" + this.views + '}';
    }

    public JsonObject toJsonObject() {
        JsonObject converted = JsonObject.empty();
        JsonObject views = JsonObject.empty();
        JsonObject spatialViews = JsonObject.empty();
        for (View view : this.views) {
            if (view instanceof SpatialView) {
                spatialViews.put(view.name(), view.map());
                continue;
            }
            JsonObject content = JsonObject.empty();
            content.put("map", view.map());
            if (view.hasReduce()) {
                content.put("reduce", view.reduce());
            }
            views.put(view.name(), content);
        }
        converted.put("views", views);
        converted.put("spatial", spatialViews);
        return converted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DesignDocument that = (DesignDocument)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.views != null ? !this.views.equals(that.views) : that.views != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.views != null ? this.views.hashCode() : 0);
        return result;
    }
}

