/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.document;

import com.couchbase.client.java.document.Document;

public abstract class AbstractDocument<T>
implements Document<T> {
    private final String id;
    private final long cas;
    private final int expiry;
    private final T content;

    protected AbstractDocument(String id, int expiry, T content, long cas) {
        this.id = id;
        this.cas = cas;
        this.expiry = expiry;
        this.content = content;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public long cas() {
        return this.cas;
    }

    @Override
    public int expiry() {
        return this.expiry;
    }

    @Override
    public T content() {
        return this.content;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName() + "{");
        sb.append("id='").append(this.id).append('\'');
        sb.append(", cas=").append(this.cas);
        sb.append(", expiry=").append(this.expiry);
        sb.append(", content=").append(this.content);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractDocument that = (AbstractDocument)o;
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.cas != that.cas) {
            return false;
        }
        if (this.expiry != that.expiry) {
            return false;
        }
        return !(this.content != null ? !this.content.equals(that.content) : that.content != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (int)(this.cas ^ this.cas >>> 32);
        result = 31 * result + this.expiry;
        result = 31 * result + (this.content != null ? this.content.hashCode() : 0);
        return result;
    }
}

