/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.bucket;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.java.bucket.AsyncBucketManager;
import com.couchbase.client.java.bucket.BucketInfo;
import com.couchbase.client.java.bucket.BucketManager;
import com.couchbase.client.java.bucket.DefaultAsyncBucketManager;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.view.DesignDocument;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DefaultBucketManager
implements BucketManager {
    private static final TimeUnit TIMEOUT_UNIT = TimeUnit.MILLISECONDS;
    private final AsyncBucketManager asyncBucketManager;
    private final long timeout;

    DefaultBucketManager(CouchbaseEnvironment environment, String bucket, String password, ClusterFacade core) {
        this.asyncBucketManager = DefaultAsyncBucketManager.create(bucket, password, core);
        this.timeout = environment.managementTimeout();
    }

    public static DefaultBucketManager create(CouchbaseEnvironment environment, String bucket, String password, ClusterFacade core) {
        return new DefaultBucketManager(environment, bucket, password, core);
    }

    @Override
    public AsyncBucketManager async() {
        return this.asyncBucketManager;
    }

    @Override
    public BucketInfo info() {
        return this.info(this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public Boolean flush() {
        return this.flush(this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public List<DesignDocument> getDesignDocuments() {
        return this.getDesignDocuments(this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public List<DesignDocument> getDesignDocuments(boolean development) {
        return this.getDesignDocuments(development, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public DesignDocument getDesignDocument(String name) {
        return this.getDesignDocument(name, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public DesignDocument getDesignDocument(String name, boolean development) {
        return this.getDesignDocument(name, development, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public DesignDocument insertDesignDocument(DesignDocument designDocument) {
        return this.insertDesignDocument(designDocument, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public DesignDocument insertDesignDocument(DesignDocument designDocument, boolean development) {
        return this.insertDesignDocument(designDocument, development, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public DesignDocument upsertDesignDocument(DesignDocument designDocument) {
        return this.upsertDesignDocument(designDocument, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public DesignDocument upsertDesignDocument(DesignDocument designDocument, boolean development) {
        return this.upsertDesignDocument(designDocument, development, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public Boolean removeDesignDocument(String name) {
        return this.removeDesignDocument(name, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public Boolean removeDesignDocument(String name, boolean development) {
        return this.removeDesignDocument(name, development, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public DesignDocument publishDesignDocument(String name) {
        return this.publishDesignDocument(name, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public DesignDocument publishDesignDocument(String name, boolean overwrite) {
        return this.publishDesignDocument(name, overwrite, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public BucketInfo info(long timeout, TimeUnit timeUnit) {
        return (BucketInfo)this.asyncBucketManager.info().timeout(timeout, timeUnit).toBlocking().single();
    }

    @Override
    public Boolean flush(long timeout, TimeUnit timeUnit) {
        return (Boolean)this.asyncBucketManager.flush().timeout(timeout, timeUnit).toBlocking().single();
    }

    @Override
    public List<DesignDocument> getDesignDocuments(long timeout, TimeUnit timeUnit) {
        return (List)this.asyncBucketManager.getDesignDocuments().timeout(timeout, timeUnit).toList().toBlocking().single();
    }

    @Override
    public List<DesignDocument> getDesignDocuments(boolean development, long timeout, TimeUnit timeUnit) {
        return (List)this.asyncBucketManager.getDesignDocuments(development).timeout(timeout, timeUnit).toList().toBlocking().single();
    }

    @Override
    public DesignDocument getDesignDocument(String name, long timeout, TimeUnit timeUnit) {
        return (DesignDocument)this.asyncBucketManager.getDesignDocument(name).timeout(timeout, timeUnit).toBlocking().singleOrDefault(null);
    }

    @Override
    public DesignDocument getDesignDocument(String name, boolean development, long timeout, TimeUnit timeUnit) {
        return (DesignDocument)this.asyncBucketManager.getDesignDocument(name, development).timeout(timeout, timeUnit).toBlocking().singleOrDefault(null);
    }

    @Override
    public DesignDocument insertDesignDocument(DesignDocument designDocument, long timeout, TimeUnit timeUnit) {
        return (DesignDocument)this.asyncBucketManager.insertDesignDocument(designDocument).timeout(timeout, timeUnit).toBlocking().single();
    }

    @Override
    public DesignDocument insertDesignDocument(DesignDocument designDocument, boolean development, long timeout, TimeUnit timeUnit) {
        return (DesignDocument)this.asyncBucketManager.insertDesignDocument(designDocument, development).timeout(timeout, timeUnit).toBlocking().single();
    }

    @Override
    public DesignDocument upsertDesignDocument(DesignDocument designDocument, long timeout, TimeUnit timeUnit) {
        return (DesignDocument)this.asyncBucketManager.upsertDesignDocument(designDocument).timeout(timeout, timeUnit).toBlocking().single();
    }

    @Override
    public DesignDocument upsertDesignDocument(DesignDocument designDocument, boolean development, long timeout, TimeUnit timeUnit) {
        return (DesignDocument)this.asyncBucketManager.upsertDesignDocument(designDocument, development).timeout(timeout, timeUnit).toBlocking().single();
    }

    @Override
    public Boolean removeDesignDocument(String name, long timeout, TimeUnit timeUnit) {
        return (Boolean)this.asyncBucketManager.removeDesignDocument(name).timeout(timeout, timeUnit).toBlocking().single();
    }

    @Override
    public Boolean removeDesignDocument(String name, boolean development, long timeout, TimeUnit timeUnit) {
        return (Boolean)this.asyncBucketManager.removeDesignDocument(name, development).timeout(timeout, timeUnit).toBlocking().single();
    }

    @Override
    public DesignDocument publishDesignDocument(String name, long timeout, TimeUnit timeUnit) {
        return (DesignDocument)this.asyncBucketManager.publishDesignDocument(name).timeout(timeout, timeUnit).toBlocking().single();
    }

    @Override
    public DesignDocument publishDesignDocument(String name, boolean overwrite, long timeout, TimeUnit timeUnit) {
        return (DesignDocument)this.asyncBucketManager.publishDesignDocument(name, overwrite).timeout(timeout, timeUnit).toBlocking().single();
    }
}

