/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.core.config.CouchbaseBucketConfig;
import com.couchbase.client.core.lang.Tuple2;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.core.message.cluster.CloseBucketRequest;
import com.couchbase.client.core.message.cluster.CloseBucketResponse;
import com.couchbase.client.core.message.cluster.GetClusterConfigRequest;
import com.couchbase.client.core.message.cluster.GetClusterConfigResponse;
import com.couchbase.client.core.message.kv.AppendRequest;
import com.couchbase.client.core.message.kv.AppendResponse;
import com.couchbase.client.core.message.kv.BinaryRequest;
import com.couchbase.client.core.message.kv.CounterRequest;
import com.couchbase.client.core.message.kv.CounterResponse;
import com.couchbase.client.core.message.kv.GetRequest;
import com.couchbase.client.core.message.kv.GetResponse;
import com.couchbase.client.core.message.kv.InsertRequest;
import com.couchbase.client.core.message.kv.InsertResponse;
import com.couchbase.client.core.message.kv.PrependRequest;
import com.couchbase.client.core.message.kv.PrependResponse;
import com.couchbase.client.core.message.kv.RemoveRequest;
import com.couchbase.client.core.message.kv.RemoveResponse;
import com.couchbase.client.core.message.kv.ReplaceRequest;
import com.couchbase.client.core.message.kv.ReplaceResponse;
import com.couchbase.client.core.message.kv.ReplicaGetRequest;
import com.couchbase.client.core.message.kv.TouchRequest;
import com.couchbase.client.core.message.kv.TouchResponse;
import com.couchbase.client.core.message.kv.UnlockRequest;
import com.couchbase.client.core.message.kv.UnlockResponse;
import com.couchbase.client.core.message.kv.UpsertRequest;
import com.couchbase.client.core.message.kv.UpsertResponse;
import com.couchbase.client.core.message.observe.Observe;
import com.couchbase.client.core.message.query.GenericQueryRequest;
import com.couchbase.client.core.message.query.GenericQueryResponse;
import com.couchbase.client.core.message.view.ViewQueryRequest;
import com.couchbase.client.core.message.view.ViewQueryResponse;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.java.AsyncBucket;
import com.couchbase.client.java.PersistTo;
import com.couchbase.client.java.ReplicaMode;
import com.couchbase.client.java.ReplicateTo;
import com.couchbase.client.java.bucket.AsyncBucketManager;
import com.couchbase.client.java.bucket.DefaultAsyncBucketManager;
import com.couchbase.client.java.document.Document;
import com.couchbase.client.java.document.JsonDocument;
import com.couchbase.client.java.document.JsonLongDocument;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.error.CASMismatchException;
import com.couchbase.client.java.error.DocumentAlreadyExistsException;
import com.couchbase.client.java.error.DocumentDoesNotExistException;
import com.couchbase.client.java.error.DurabilityException;
import com.couchbase.client.java.error.TranscodingException;
import com.couchbase.client.java.query.AsyncQueryResult;
import com.couchbase.client.java.query.AsyncQueryRow;
import com.couchbase.client.java.query.DefaultAsyncQueryResult;
import com.couchbase.client.java.query.DefaultAsyncQueryRow;
import com.couchbase.client.java.query.Query;
import com.couchbase.client.java.transcoder.BinaryTranscoder;
import com.couchbase.client.java.transcoder.JsonArrayTranscoder;
import com.couchbase.client.java.transcoder.JsonBooleanTranscoder;
import com.couchbase.client.java.transcoder.JsonDoubleTranscoder;
import com.couchbase.client.java.transcoder.JsonLongTranscoder;
import com.couchbase.client.java.transcoder.JsonStringTranscoder;
import com.couchbase.client.java.transcoder.JsonTranscoder;
import com.couchbase.client.java.transcoder.LegacyTranscoder;
import com.couchbase.client.java.transcoder.RawJsonTranscoder;
import com.couchbase.client.java.transcoder.SerializableTranscoder;
import com.couchbase.client.java.transcoder.StringTranscoder;
import com.couchbase.client.java.transcoder.Transcoder;
import com.couchbase.client.java.view.AsyncViewResult;
import com.couchbase.client.java.view.ViewQuery;
import com.couchbase.client.java.view.ViewQueryResponseMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import rx.Observable;
import rx.functions.Func1;

public class CouchbaseAsyncBucket
implements AsyncBucket {
    public static final JsonTranscoder JSON_OBJECT_TRANSCODER = new JsonTranscoder();
    public static final JsonArrayTranscoder JSON_ARRAY_TRANSCODER = new JsonArrayTranscoder();
    public static final JsonBooleanTranscoder JSON_BOOLEAN_TRANSCODER = new JsonBooleanTranscoder();
    public static final JsonDoubleTranscoder JSON_DOUBLE_TRANSCODER = new JsonDoubleTranscoder();
    public static final JsonLongTranscoder JSON_LONG_TRANSCODER = new JsonLongTranscoder();
    public static final JsonStringTranscoder JSON_STRING_TRANSCODER = new JsonStringTranscoder();
    public static final RawJsonTranscoder RAW_JSON_TRANSCODER = new RawJsonTranscoder();
    public static final LegacyTranscoder LEGACY_TRANSCODER = new LegacyTranscoder();
    public static final BinaryTranscoder BINARY_TRANSCODER = new BinaryTranscoder();
    public static final StringTranscoder STRING_TRANSCODER = new StringTranscoder();
    public static final SerializableTranscoder SERIALIZABLE_TRANSCODER = new SerializableTranscoder();
    private final String bucket;
    private final String password;
    private final ClusterFacade core;
    private final Map<Class<? extends Document>, Transcoder<? extends Document, ?>> transcoders;
    private final AsyncBucketManager bucketManager;

    public CouchbaseAsyncBucket(ClusterFacade core, String name, String password, List<Transcoder<? extends Document, ?>> customTranscoders) {
        this.bucket = name;
        this.password = password;
        this.core = core;
        this.transcoders = new ConcurrentHashMap();
        this.transcoders.put(JSON_OBJECT_TRANSCODER.documentType(), JSON_OBJECT_TRANSCODER);
        this.transcoders.put(JSON_ARRAY_TRANSCODER.documentType(), JSON_ARRAY_TRANSCODER);
        this.transcoders.put(JSON_BOOLEAN_TRANSCODER.documentType(), JSON_BOOLEAN_TRANSCODER);
        this.transcoders.put(JSON_DOUBLE_TRANSCODER.documentType(), JSON_DOUBLE_TRANSCODER);
        this.transcoders.put(JSON_LONG_TRANSCODER.documentType(), JSON_LONG_TRANSCODER);
        this.transcoders.put(JSON_STRING_TRANSCODER.documentType(), JSON_STRING_TRANSCODER);
        this.transcoders.put(RAW_JSON_TRANSCODER.documentType(), RAW_JSON_TRANSCODER);
        this.transcoders.put(LEGACY_TRANSCODER.documentType(), LEGACY_TRANSCODER);
        this.transcoders.put(BINARY_TRANSCODER.documentType(), BINARY_TRANSCODER);
        this.transcoders.put(STRING_TRANSCODER.documentType(), STRING_TRANSCODER);
        this.transcoders.put(SERIALIZABLE_TRANSCODER.documentType(), SERIALIZABLE_TRANSCODER);
        for (Transcoder<Document, ?> custom : customTranscoders) {
            this.transcoders.put(custom.documentType(), custom);
        }
        this.bucketManager = DefaultAsyncBucketManager.create(this.bucket, password, core);
    }

    @Override
    public String name() {
        return this.bucket;
    }

    @Override
    public Observable<JsonDocument> get(String id) {
        return this.get(id, JsonDocument.class);
    }

    @Override
    public <D extends Document<?>> Observable<D> get(D document) {
        return this.get(document.id(), document.getClass());
    }

    @Override
    public <D extends Document<?>> Observable<D> get(final String id, final Class<D> target) {
        return this.core.send((CouchbaseRequest)new GetRequest(id, this.bucket)).filter((Func1)new Func1<GetResponse, Boolean>(){

            public Boolean call(GetResponse getResponse) {
                return getResponse.status() == ResponseStatus.SUCCESS;
            }
        }).map(new Func1<GetResponse, D>(){

            public D call(GetResponse response) {
                Transcoder transcoder = (Transcoder)CouchbaseAsyncBucket.this.transcoders.get(target);
                return transcoder.decode(id, response.content(), response.cas(), 0, response.flags(), response.status());
            }
        });
    }

    @Override
    public Observable<JsonDocument> getAndLock(String id, int lockTime) {
        return this.getAndLock(id, lockTime, JsonDocument.class);
    }

    @Override
    public <D extends Document<?>> Observable<D> getAndLock(D document, int lockTime) {
        return this.getAndLock(document.id(), lockTime, document.getClass());
    }

    @Override
    public <D extends Document<?>> Observable<D> getAndLock(final String id, int lockTime, final Class<D> target) {
        return this.core.send((CouchbaseRequest)new GetRequest(id, this.bucket, true, false, lockTime)).filter((Func1)new Func1<GetResponse, Boolean>(){

            public Boolean call(GetResponse getResponse) {
                return getResponse.status() == ResponseStatus.SUCCESS;
            }
        }).map(new Func1<GetResponse, D>(){

            public D call(GetResponse response) {
                Transcoder transcoder = (Transcoder)CouchbaseAsyncBucket.this.transcoders.get(target);
                return transcoder.decode(id, response.content(), response.cas(), 0, response.flags(), response.status());
            }
        });
    }

    @Override
    public Observable<JsonDocument> getAndTouch(String id, int expiry) {
        return this.getAndTouch(id, expiry, JsonDocument.class);
    }

    @Override
    public <D extends Document<?>> Observable<D> getAndTouch(D document) {
        return this.getAndTouch(document.id(), document.expiry(), document.getClass());
    }

    @Override
    public <D extends Document<?>> Observable<D> getAndTouch(final String id, int expiry, final Class<D> target) {
        return this.core.send((CouchbaseRequest)new GetRequest(id, this.bucket, false, true, expiry)).filter((Func1)new Func1<GetResponse, Boolean>(){

            public Boolean call(GetResponse getResponse) {
                return getResponse.status() == ResponseStatus.SUCCESS;
            }
        }).map(new Func1<GetResponse, D>(){

            public D call(GetResponse response) {
                Transcoder transcoder = (Transcoder)CouchbaseAsyncBucket.this.transcoders.get(target);
                return transcoder.decode(id, response.content(), response.cas(), 0, response.flags(), response.status());
            }
        });
    }

    @Override
    public Observable<JsonDocument> getFromReplica(String id, ReplicaMode type) {
        return this.getFromReplica(id, type, JsonDocument.class);
    }

    @Override
    public <D extends Document<?>> Observable<D> getFromReplica(D document, ReplicaMode type) {
        return this.getFromReplica(document.id(), type, document.getClass());
    }

    @Override
    public <D extends Document<?>> Observable<D> getFromReplica(final String id, ReplicaMode type, final Class<D> target) {
        Observable incoming = type == ReplicaMode.ALL ? this.core.send((CouchbaseRequest)new GetClusterConfigRequest()).map((Func1)new Func1<GetClusterConfigResponse, Integer>(){

            public Integer call(GetClusterConfigResponse response) {
                CouchbaseBucketConfig conf = (CouchbaseBucketConfig)response.config().bucketConfig(CouchbaseAsyncBucket.this.bucket);
                return conf.numberOfReplicas();
            }
        }).flatMap((Func1)new Func1<Integer, Observable<BinaryRequest>>(){

            public Observable<BinaryRequest> call(Integer max) {
                ArrayList<Object> requests = new ArrayList<Object>();
                requests.add(new GetRequest(id, CouchbaseAsyncBucket.this.bucket));
                for (int i = 0; i < max; ++i) {
                    requests.add(new ReplicaGetRequest(id, CouchbaseAsyncBucket.this.bucket, (short)(i + 1)));
                }
                return Observable.from(requests);
            }
        }).flatMap((Func1)new Func1<BinaryRequest, Observable<GetResponse>>(){

            public Observable<GetResponse> call(BinaryRequest req) {
                return CouchbaseAsyncBucket.this.core.send((CouchbaseRequest)req);
            }
        }) : this.core.send((CouchbaseRequest)new ReplicaGetRequest(id, this.bucket, (short)type.ordinal()));
        return incoming.filter((Func1)new Func1<GetResponse, Boolean>(){

            public Boolean call(GetResponse getResponse) {
                return getResponse.status() == ResponseStatus.SUCCESS;
            }
        }).map(new Func1<GetResponse, D>(){

            public D call(GetResponse response) {
                Transcoder transcoder = (Transcoder)CouchbaseAsyncBucket.this.transcoders.get(target);
                return transcoder.decode(id, response.content(), response.cas(), 0, response.flags(), response.status());
            }
        });
    }

    @Override
    public <D extends Document<?>> Observable<D> insert(final D document) {
        final Transcoder<Document, ?> transcoder = this.transcoders.get(document.getClass());
        Tuple2<ByteBuf, Integer> encoded = transcoder.encode(document);
        return this.core.send((CouchbaseRequest)new InsertRequest(document.id(), (ByteBuf)encoded.value1(), document.expiry(), ((Integer)encoded.value2()).intValue(), this.bucket)).flatMap(new Func1<InsertResponse, Observable<? extends D>>(){

            public Observable<? extends D> call(InsertResponse response) {
                if (response.status() == ResponseStatus.EXISTS) {
                    return Observable.error((Throwable)((Object)new DocumentAlreadyExistsException()));
                }
                return Observable.just(transcoder.newDocument(document.id(), document.expiry(), document.content(), response.cas()));
            }
        });
    }

    @Override
    public <D extends Document<?>> Observable<D> insert(D document, final PersistTo persistTo, final ReplicateTo replicateTo) {
        return this.insert(document).flatMap(new Func1<D, Observable<D>>(){

            public Observable<D> call(D doc) {
                return Observe.call((ClusterFacade)CouchbaseAsyncBucket.this.core, (String)CouchbaseAsyncBucket.this.bucket, (String)doc.id(), (long)doc.cas(), (boolean)false, (Observe.PersistTo)persistTo.value(), (Observe.ReplicateTo)replicateTo.value()).map(new Func1<Boolean, D>((Document)doc){
                    final /* synthetic */ Document val$doc;
                    {
                        this.val$doc = document;
                    }

                    public D call(Boolean aBoolean) {
                        return this.val$doc;
                    }
                }).onErrorResumeNext(new Func1<Throwable, Observable<? extends D>>(){

                    public Observable<? extends D> call(Throwable throwable) {
                        return Observable.error((Throwable)((Object)new DurabilityException("Durability constraint failed.", throwable)));
                    }
                });
            }
        });
    }

    @Override
    public <D extends Document<?>> Observable<D> upsert(final D document) {
        final Transcoder<Document, ?> transcoder = this.transcoders.get(document.getClass());
        Tuple2<ByteBuf, Integer> encoded = transcoder.encode(document);
        return this.core.send((CouchbaseRequest)new UpsertRequest(document.id(), (ByteBuf)encoded.value1(), document.expiry(), ((Integer)encoded.value2()).intValue(), this.bucket)).flatMap(new Func1<UpsertResponse, Observable<D>>(){

            public Observable<D> call(UpsertResponse response) {
                if (response.status() == ResponseStatus.EXISTS) {
                    return Observable.error((Throwable)((Object)new CASMismatchException()));
                }
                return Observable.just(transcoder.newDocument(document.id(), document.expiry(), document.content(), response.cas()));
            }
        });
    }

    @Override
    public <D extends Document<?>> Observable<D> upsert(D document, final PersistTo persistTo, final ReplicateTo replicateTo) {
        return this.upsert(document).flatMap(new Func1<D, Observable<D>>(){

            public Observable<D> call(D doc) {
                return Observe.call((ClusterFacade)CouchbaseAsyncBucket.this.core, (String)CouchbaseAsyncBucket.this.bucket, (String)doc.id(), (long)doc.cas(), (boolean)false, (Observe.PersistTo)persistTo.value(), (Observe.ReplicateTo)replicateTo.value()).map(new Func1<Boolean, D>((Document)doc){
                    final /* synthetic */ Document val$doc;
                    {
                        this.val$doc = document;
                    }

                    public D call(Boolean aBoolean) {
                        return this.val$doc;
                    }
                });
            }
        });
    }

    @Override
    public <D extends Document<?>> Observable<D> replace(final D document) {
        final Transcoder<Document, ?> transcoder = this.transcoders.get(document.getClass());
        Tuple2<ByteBuf, Integer> encoded = transcoder.encode(document);
        return this.core.send((CouchbaseRequest)new ReplaceRequest(document.id(), (ByteBuf)encoded.value1(), document.cas(), document.expiry(), ((Integer)encoded.value2()).intValue(), this.bucket)).flatMap(new Func1<ReplaceResponse, Observable<D>>(){

            public Observable<D> call(ReplaceResponse response) {
                if (response.status() == ResponseStatus.NOT_EXISTS) {
                    return Observable.error((Throwable)((Object)new DocumentDoesNotExistException()));
                }
                if (response.status() == ResponseStatus.EXISTS) {
                    return Observable.error((Throwable)((Object)new CASMismatchException()));
                }
                return Observable.just(transcoder.newDocument(document.id(), document.expiry(), document.content(), response.cas()));
            }
        });
    }

    @Override
    public <D extends Document<?>> Observable<D> replace(D document, final PersistTo persistTo, final ReplicateTo replicateTo) {
        return this.replace(document).flatMap(new Func1<D, Observable<D>>(){

            public Observable<D> call(D doc) {
                return Observe.call((ClusterFacade)CouchbaseAsyncBucket.this.core, (String)CouchbaseAsyncBucket.this.bucket, (String)doc.id(), (long)doc.cas(), (boolean)false, (Observe.PersistTo)persistTo.value(), (Observe.ReplicateTo)replicateTo.value()).map(new Func1<Boolean, D>((Document)doc){
                    final /* synthetic */ Document val$doc;
                    {
                        this.val$doc = document;
                    }

                    public D call(Boolean aBoolean) {
                        return this.val$doc;
                    }
                });
            }
        });
    }

    @Override
    public <D extends Document<?>> Observable<D> remove(final D document) {
        final Transcoder<? extends Document, ?> transcoder = this.transcoders.get(document.getClass());
        RemoveRequest request = new RemoveRequest(document.id(), document.cas(), this.bucket);
        return this.core.send((CouchbaseRequest)request).map(new Func1<RemoveResponse, D>(){

            public D call(RemoveResponse response) {
                if (response.status() == ResponseStatus.EXISTS) {
                    throw new CASMismatchException();
                }
                return transcoder.newDocument(document.id(), 0, null, response.cas());
            }
        });
    }

    @Override
    public Observable<JsonDocument> remove(String id) {
        return this.remove(id, JsonDocument.class);
    }

    @Override
    public <D extends Document<?>> Observable<D> remove(String id, Class<D> target) {
        Transcoder<Document, ?> transcoder = this.transcoders.get(target);
        return this.remove(transcoder.newDocument(id, 0, null, 0L));
    }

    @Override
    public <D extends Document<?>> Observable<D> remove(D document, PersistTo persistTo, ReplicateTo replicateTo) {
        return this.remove(document.id(), persistTo, replicateTo, document.getClass());
    }

    @Override
    public Observable<JsonDocument> remove(String id, PersistTo persistTo, ReplicateTo replicateTo) {
        return this.remove(id, persistTo, replicateTo, JsonDocument.class);
    }

    @Override
    public <D extends Document<?>> Observable<D> remove(String id, final PersistTo persistTo, final ReplicateTo replicateTo, Class<D> target) {
        return this.remove(id, target).flatMap(new Func1<D, Observable<D>>(){

            public Observable<D> call(D doc) {
                return Observe.call((ClusterFacade)CouchbaseAsyncBucket.this.core, (String)CouchbaseAsyncBucket.this.bucket, (String)doc.id(), (long)doc.cas(), (boolean)true, (Observe.PersistTo)persistTo.value(), (Observe.ReplicateTo)replicateTo.value()).map(new Func1<Boolean, D>((Document)doc){
                    final /* synthetic */ Document val$doc;
                    {
                        this.val$doc = document;
                    }

                    public D call(Boolean aBoolean) {
                        return this.val$doc;
                    }
                });
            }
        });
    }

    @Override
    public Observable<AsyncViewResult> query(final ViewQuery query) {
        ViewQueryRequest request = new ViewQueryRequest(query.getDesign(), query.getView(), query.isDevelopment(), query.toString(), this.bucket, this.password);
        return this.core.send((CouchbaseRequest)request).flatMap((Func1)new Func1<ViewQueryResponse, Observable<AsyncViewResult>>(){

            public Observable<AsyncViewResult> call(ViewQueryResponse response) {
                return ViewQueryResponseMapper.mapToViewResult(CouchbaseAsyncBucket.this, query, response);
            }
        });
    }

    @Override
    public Observable<AsyncQueryResult> query(Query query) {
        return this.query(query.toString());
    }

    @Override
    public Observable<AsyncQueryResult> query(String query) {
        GenericQueryRequest request = new GenericQueryRequest(query, this.bucket, this.password);
        return this.core.send((CouchbaseRequest)request).flatMap((Func1)new Func1<GenericQueryResponse, Observable<AsyncQueryResult>>(){

            public Observable<AsyncQueryResult> call(final GenericQueryResponse response) {
                final Observable rows = response.rows().map((Func1)new Func1<ByteBuf, AsyncQueryRow>(){

                    public AsyncQueryRow call(ByteBuf byteBuf) {
                        try {
                            JsonObject value = JSON_OBJECT_TRANSCODER.byteBufToJsonObject(byteBuf);
                            return new DefaultAsyncQueryRow(value);
                        }
                        catch (Exception e) {
                            throw new TranscodingException("Could not decode View Info.", e);
                        }
                    }
                });
                final Observable info = response.info().map((Func1)new Func1<ByteBuf, JsonObject>(){

                    public JsonObject call(ByteBuf byteBuf) {
                        try {
                            return JSON_OBJECT_TRANSCODER.byteBufToJsonObject(byteBuf);
                        }
                        catch (Exception e) {
                            throw new TranscodingException("Could not decode View Info.", e);
                        }
                    }
                });
                if (response.status().isSuccess()) {
                    return Observable.just((Object)new DefaultAsyncQueryResult((Observable<AsyncQueryRow>)rows, (Observable<JsonObject>)info, null, response.status().isSuccess()));
                }
                return response.info().map((Func1)new Func1<ByteBuf, AsyncQueryResult>(){

                    public AsyncQueryResult call(ByteBuf byteBuf) {
                        try {
                            JsonObject error = JSON_OBJECT_TRANSCODER.byteBufToJsonObject(byteBuf);
                            return new DefaultAsyncQueryResult((Observable<AsyncQueryRow>)rows, (Observable<JsonObject>)info, error, response.status().isSuccess());
                        }
                        catch (Exception e) {
                            throw new TranscodingException("Could not decode View Info.", e);
                        }
                    }
                });
            }
        });
    }

    @Override
    public Observable<JsonLongDocument> counter(String id, long delta) {
        return this.counter(id, delta, delta);
    }

    @Override
    public Observable<JsonLongDocument> counter(String id, long delta, long initial) {
        return this.counter(id, delta, initial, 0);
    }

    @Override
    public Observable<JsonLongDocument> counter(final String id, long delta, long initial, final int expiry) {
        return this.core.send((CouchbaseRequest)new CounterRequest(id, initial, delta, expiry, this.bucket)).map((Func1)new Func1<CounterResponse, JsonLongDocument>(){

            public JsonLongDocument call(CounterResponse response) {
                return JsonLongDocument.create(id, expiry, response.value(), response.cas());
            }
        });
    }

    @Override
    public Observable<Boolean> unlock(String id, long cas) {
        return this.core.send((CouchbaseRequest)new UnlockRequest(id, cas, this.bucket)).map((Func1)new Func1<UnlockResponse, Boolean>(){

            public Boolean call(UnlockResponse response) {
                if (response.status() == ResponseStatus.NOT_EXISTS) {
                    throw new DocumentDoesNotExistException();
                }
                if (response.status() == ResponseStatus.FAILURE) {
                    throw new CASMismatchException();
                }
                return response.status().isSuccess();
            }
        });
    }

    @Override
    public <D extends Document<?>> Observable<Boolean> unlock(D document) {
        return this.unlock(document.id(), document.cas());
    }

    @Override
    public Observable<Boolean> touch(String id, int expiry) {
        return this.core.send((CouchbaseRequest)new TouchRequest(id, expiry, this.bucket)).map((Func1)new Func1<TouchResponse, Boolean>(){

            public Boolean call(TouchResponse touchResponse) {
                return touchResponse.status().isSuccess();
            }
        });
    }

    @Override
    public <D extends Document<?>> Observable<Boolean> touch(D document) {
        return this.touch(document.id(), document.expiry());
    }

    @Override
    public <D extends Document<?>> Observable<D> append(final D document) {
        final Transcoder<Document, ?> transcoder = this.transcoders.get(document.getClass());
        Tuple2<ByteBuf, Integer> encoded = transcoder.encode(document);
        return this.core.send((CouchbaseRequest)new AppendRequest(document.id(), document.cas(), (ByteBuf)encoded.value1(), this.bucket)).map(new Func1<AppendResponse, D>(){

            public D call(AppendResponse response) {
                if (response.status() == ResponseStatus.FAILURE) {
                    throw new DocumentDoesNotExistException();
                }
                return transcoder.newDocument(document.id(), 0, null, response.cas());
            }
        });
    }

    @Override
    public <D extends Document<?>> Observable<D> prepend(final D document) {
        final Transcoder<Document, ?> transcoder = this.transcoders.get(document.getClass());
        Tuple2<ByteBuf, Integer> encoded = transcoder.encode(document);
        return this.core.send((CouchbaseRequest)new PrependRequest(document.id(), document.cas(), (ByteBuf)encoded.value1(), this.bucket)).map(new Func1<PrependResponse, D>(){

            public D call(PrependResponse response) {
                if (response.status() == ResponseStatus.FAILURE) {
                    throw new DocumentDoesNotExistException();
                }
                return transcoder.newDocument(document.id(), 0, null, response.cas());
            }
        });
    }

    @Override
    public Observable<AsyncBucketManager> bucketManager() {
        return Observable.just((Object)this.bucketManager);
    }

    @Override
    public <D extends Document<?>> Observable<D> insert(D document, PersistTo persistTo) {
        return this.insert(document, persistTo, ReplicateTo.NONE);
    }

    @Override
    public <D extends Document<?>> Observable<D> insert(D document, ReplicateTo replicateTo) {
        return this.insert(document, PersistTo.NONE, replicateTo);
    }

    @Override
    public <D extends Document<?>> Observable<D> upsert(D document, PersistTo persistTo) {
        return this.upsert(document, persistTo, ReplicateTo.NONE);
    }

    @Override
    public <D extends Document<?>> Observable<D> upsert(D document, ReplicateTo replicateTo) {
        return this.upsert(document, PersistTo.NONE, replicateTo);
    }

    @Override
    public <D extends Document<?>> Observable<D> replace(D document, PersistTo persistTo) {
        return this.replace(document, persistTo, ReplicateTo.NONE);
    }

    @Override
    public <D extends Document<?>> Observable<D> replace(D document, ReplicateTo replicateTo) {
        return this.replace(document, PersistTo.NONE, replicateTo);
    }

    @Override
    public <D extends Document<?>> Observable<D> remove(D document, PersistTo persistTo) {
        return this.remove(document, persistTo, ReplicateTo.NONE);
    }

    @Override
    public <D extends Document<?>> Observable<D> remove(D document, ReplicateTo replicateTo) {
        return this.remove(document, PersistTo.NONE, replicateTo);
    }

    @Override
    public Observable<JsonDocument> remove(String id, PersistTo persistTo) {
        return this.remove(id, persistTo, ReplicateTo.NONE);
    }

    @Override
    public Observable<JsonDocument> remove(String id, ReplicateTo replicateTo) {
        return this.remove(id, PersistTo.NONE, replicateTo);
    }

    @Override
    public <D extends Document<?>> Observable<D> remove(String id, PersistTo persistTo, Class<D> target) {
        return this.remove(id, persistTo, ReplicateTo.NONE, target);
    }

    @Override
    public <D extends Document<?>> Observable<D> remove(String id, ReplicateTo replicateTo, Class<D> target) {
        return this.remove(id, PersistTo.NONE, replicateTo, target);
    }

    @Override
    public Observable<Boolean> close() {
        return this.core.send((CouchbaseRequest)new CloseBucketRequest(this.bucket)).map((Func1)new Func1<CloseBucketResponse, Boolean>(){

            public Boolean call(CloseBucketResponse response) {
                return response.status().isSuccess();
            }
        });
    }
}

