/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.transcoder;

import com.couchbase.client.core.lang.Tuple;
import com.couchbase.client.core.lang.Tuple2;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.deps.io.netty.util.CharsetUtil;
import com.couchbase.client.java.document.JsonDocument;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.error.TranscodingException;
import com.couchbase.client.java.transcoder.AbstractTranscoder;
import com.couchbase.client.java.transcoder.JacksonTransformers;
import com.couchbase.client.java.transcoder.TranscoderUtils;
import java.nio.charset.Charset;

public class JsonTranscoder
extends AbstractTranscoder<JsonDocument, JsonObject> {
    @Override
    public Class<JsonDocument> documentType() {
        return JsonDocument.class;
    }

    @Override
    protected Tuple2<ByteBuf, Integer> doEncode(JsonDocument document) throws Exception {
        String content = this.jsonObjectToString((JsonObject)document.content());
        return Tuple.create((Object)Unpooled.copiedBuffer((CharSequence)content, (Charset)CharsetUtil.UTF_8), (Object)TranscoderUtils.JSON_COMPAT_FLAGS);
    }

    @Override
    protected JsonDocument doDecode(String id, ByteBuf content, long cas, int expiry, int flags, ResponseStatus status) throws Exception {
        if (!TranscoderUtils.hasJsonFlags(flags)) {
            throw new TranscodingException("Flags (0x" + Integer.toHexString(flags) + ") indicate non-JSON document for " + "id " + id + ", could not decode.");
        }
        JsonObject converted = this.stringToJsonObject(content.toString(CharsetUtil.UTF_8));
        content.release();
        return this.newDocument(id, expiry, converted, cas);
    }

    @Override
    public JsonDocument newDocument(String id, int expiry, JsonObject content, long cas) {
        return JsonDocument.create(id, expiry, content, cas);
    }

    public String jsonObjectToString(JsonObject input) throws Exception {
        return JacksonTransformers.MAPPER.writeValueAsString((Object)input);
    }

    public JsonObject stringToJsonObject(String input) throws Exception {
        return (JsonObject)JacksonTransformers.MAPPER.readValue(input, JsonObject.class);
    }

    public JsonObject byteBufToJsonObject(ByteBuf input) throws Exception {
        return this.stringToJsonObject(input.toString(CharsetUtil.UTF_8));
    }
}

