/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.query;

import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.query.AsyncQueryRow;
import com.couchbase.client.java.query.DefaultAsyncQueryResult;
import com.couchbase.client.java.query.DefaultQueryRow;
import com.couchbase.client.java.query.QueryResult;
import com.couchbase.client.java.query.QueryRow;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.functions.Func1;

public class DefaultQueryResult
implements QueryResult {
    private static final TimeUnit TIMEOUT_UNIT = TimeUnit.MILLISECONDS;
    private final DefaultAsyncQueryResult asyncQueryResult;
    private final long timeout;

    public DefaultQueryResult(CouchbaseEnvironment environment, Observable<AsyncQueryRow> rows, Observable<JsonObject> info, JsonObject error, boolean success) {
        this.asyncQueryResult = new DefaultAsyncQueryResult(rows, info, error, success);
        this.timeout = environment.managementTimeout();
    }

    @Override
    public List<QueryRow> allRows() {
        return this.allRows(this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public List<QueryRow> allRows(long timeout, TimeUnit timeUnit) {
        return (List)this.asyncQueryResult.rows().map((Func1)new Func1<AsyncQueryRow, QueryRow>(){

            public QueryRow call(AsyncQueryRow asyncQueryRow) {
                return new DefaultQueryRow(asyncQueryRow.value());
            }
        }).toList().timeout(timeout, timeUnit).toBlocking().single();
    }

    @Override
    public Iterator<QueryRow> rows() {
        return this.rows(this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public Iterator<QueryRow> rows(long timeout, TimeUnit timeUnit) {
        return this.asyncQueryResult.rows().map((Func1)new Func1<AsyncQueryRow, QueryRow>(){

            public QueryRow call(AsyncQueryRow asyncQueryRow) {
                return new DefaultQueryRow(asyncQueryRow.value());
            }
        }).timeout(timeout, timeUnit).toBlocking().getIterator();
    }

    @Override
    public JsonObject info() {
        return this.info(this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public JsonObject info(long timeout, TimeUnit timeUnit) {
        return (JsonObject)this.asyncQueryResult.info().timeout(timeout, timeUnit).toBlocking().single();
    }

    @Override
    public boolean success() {
        return this.asyncQueryResult.success();
    }

    @Override
    public JsonObject error() {
        return this.asyncQueryResult.error();
    }
}

