/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.document.json;

import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.document.json.JsonValue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class JsonArray
extends JsonValue
implements Iterable<Object> {
    private final List<Object> content = new ArrayList<Object>();

    private JsonArray() {
    }

    public static JsonArray empty() {
        return new JsonArray();
    }

    public static JsonArray create() {
        return new JsonArray();
    }

    public static JsonArray from(Object ... items) {
        JsonArray array = new JsonArray();
        for (Object item : items) {
            if (!JsonArray.checkType(item)) {
                throw new IllegalArgumentException("Unsupported type for JsonArray: " + item.getClass());
            }
            array.add(item);
        }
        return array;
    }

    public Object get(int index) {
        return this.content.get(index);
    }

    public JsonArray add(Object value) {
        if (!JsonArray.checkType(value)) {
            throw new IllegalArgumentException("Unsupported type for JsonArray: " + value.getClass());
        }
        this.content.add(value);
        return this;
    }

    public JsonArray add(String value) {
        this.content.add(value);
        return this;
    }

    public String getString(int index) {
        return (String)this.content.get(index);
    }

    public JsonArray add(long value) {
        this.content.add(value);
        return this;
    }

    public Long getLong(int index) {
        return (Long)this.content.get(index);
    }

    public JsonArray add(int value) {
        this.content.add(value);
        return this;
    }

    public Integer getInt(int index) {
        return (Integer)this.content.get(index);
    }

    public JsonArray add(double value) {
        this.content.add(value);
        return this;
    }

    public Double getDouble(int index) {
        return (Double)this.content.get(index);
    }

    public JsonArray add(boolean value) {
        this.content.add(value);
        return this;
    }

    public boolean getBoolean(int index) {
        return (Boolean)this.content.get(index);
    }

    public JsonArray add(JsonObject value) {
        this.content.add(value);
        return this;
    }

    public JsonObject getObject(int index) {
        return (JsonObject)this.content.get(index);
    }

    public JsonArray add(JsonArray value) {
        this.content.add(value);
        return this;
    }

    public JsonArray getArray(int index) {
        return (JsonArray)this.content.get(index);
    }

    public List<Object> toList() {
        return new ArrayList<Object>(this.content);
    }

    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    public int size() {
        return this.content.size();
    }

    @Override
    public Iterator<Object> iterator() {
        return this.content.iterator();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < this.content.size(); ++i) {
            Object item = this.content.get(i);
            boolean isString = item instanceof String;
            if (isString) {
                sb.append("\"");
            }
            if (item == null) {
                sb.append("null");
            } else {
                sb.append(item.toString());
            }
            if (isString) {
                sb.append("\"");
            }
            if (i >= this.content.size() - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }
}

