/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.encryption.internal;

import com.couchbase.client.encryption.internal.DaemonThreadFactory;
import com.couchbase.client.encryption.internal.Jdk8Cleaner;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class Zeroizer
implements Closeable {
    private final List<byte[]> zeroizeMe = new ArrayList<byte[]>();
    private static final Jdk8Cleaner cleaner = Jdk8Cleaner.create(new DaemonThreadFactory("zeroizer"));

    public static void zeroizeWhenUnreachable(Object referent, byte[] bytes) {
        Objects.requireNonNull(referent);
        cleaner.register(referent, new ZeriozationTask(bytes));
    }

    public static void zeroize(byte[] b) {
        if (b != null) {
            Arrays.fill(b, (byte)0);
        }
    }

    public byte[] add(byte[] b) {
        this.zeroizeMe.add(b);
        return b;
    }

    @Override
    public void close() {
        for (byte[] b : this.zeroizeMe) {
            Zeroizer.zeroize(b);
        }
    }

    private static class ZeriozationTask
    implements Runnable {
        private final byte[] bytes;

        ZeriozationTask(byte[] bytes) {
            this.bytes = bytes;
        }

        @Override
        public void run() {
            Zeroizer.zeroize(this.bytes);
        }
    }
}

