/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.encryption.internal;

import com.couchbase.client.encryption.errors.CryptoException;
import java.security.Provider;
import java.util.Optional;
import javax.crypto.Cipher;
import javax.crypto.Mac;

class CryptoFactory {
    private final Optional<Provider> provider;

    CryptoFactory(Provider provider) {
        this.provider = Optional.ofNullable(provider);
    }

    Cipher newCipher(String name) {
        try {
            return this.provider.isPresent() ? Cipher.getInstance(name, this.provider.get()) : Cipher.getInstance(name);
        }
        catch (Exception e) {
            throw new CryptoException("Failed to get instance of cipher '" + name + "'", e);
        }
    }

    Mac newMac(String name) {
        try {
            return this.provider.isPresent() ? Mac.getInstance(name, this.provider.get()) : Mac.getInstance(name);
        }
        catch (Exception e) {
            throw new CryptoException("Failed to get instance of mac '" + name + "'", e);
        }
    }

    public String toString() {
        return "CryptoFactory{provider=" + this.provider + '}';
    }
}

