package com.couchbase.client.encryption.deps.org.checkerframework.checker.signature.qual;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import com.couchbase.client.encryption.deps.org.checkerframework.framework.qual.QualifierForLiterals;
import com.couchbase.client.encryption.deps.org.checkerframework.framework.qual.SubtypeOf;

/**
 * Represents a field descriptor (JVM type format) for a primitive as defined in the <a
 * href="https://docs.oracle.com/javase/specs/jvms/se11/html/jvms-4.html#jvms-4.3.2">Java Virtual
 * Machine Specification, section 4.3.2</a>.
 *
 * <p>Must be one of B, C, D, F, I, J, S, Z.
 *
 * @checker_framework.manual #signature-checker Signature Checker
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE_USE, ElementType.TYPE_PARAMETER})
@SubtypeOf({FieldDescriptorForPrimitiveOrArrayInUnnamedPackage.class, Identifier.class})
@QualifierForLiterals(stringPatterns = "^[BCDFIJSZ]$")
public @interface FieldDescriptorForPrimitive {}
