/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.columnar.client.java;

import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.util.Golang;
import com.couchbase.columnar.client.java.QueryPriority;
import com.couchbase.columnar.client.java.ScanConsistency;
import com.couchbase.columnar.client.java.codec.Deserializer;
import com.couchbase.columnar.client.java.internal.InternalJacksonSerDes;
import com.couchbase.columnar.client.java.internal.JacksonTransformers;
import com.couchbase.columnar.client.java.internal.JsonSerializer;
import com.couchbase.columnar.client.java.json.JsonArray;
import com.couchbase.columnar.client.java.json.JsonObject;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.ApiStatus;
import reactor.util.annotation.Nullable;

public final class QueryOptions {
    @Nullable
    private Duration timeout;
    @Nullable
    private String clientContextId;
    @Nullable
    private Map<String, ?> namedParameters;
    @Nullable
    private List<?> positionalParameters;
    @Nullable
    private QueryPriority priority;
    @Nullable
    private ScanConsistency scanConsistency;
    @Nullable
    private Duration scanWait;
    @Nullable
    private Deserializer deserializer;
    @Nullable
    private Boolean readOnly;
    @Nullable
    private Map<String, ?> raw;

    QueryOptions() {
    }

    public QueryOptions timeout(@Nullable Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    public QueryOptions parameters(@Nullable Map<String, ?> namedParameters) {
        this.namedParameters = namedParameters == null ? null : Collections.unmodifiableMap(new HashMap(namedParameters));
        return this;
    }

    public QueryOptions parameters(@Nullable List<?> positionalParameters) {
        this.positionalParameters = positionalParameters == null ? null : Collections.unmodifiableList(new ArrayList(positionalParameters));
        return this;
    }

    public QueryOptions deserializer(@Nullable Deserializer deserializer) {
        this.deserializer = deserializer;
        return this;
    }

    public QueryOptions scanWait(@Nullable Duration scanWait) {
        this.scanWait = scanWait;
        return this;
    }

    public QueryOptions priority(@Nullable QueryPriority priority) {
        this.priority = priority;
        return this;
    }

    public QueryOptions scanConsistency(@Nullable ScanConsistency scanConsistency) {
        this.scanConsistency = scanConsistency;
        return this;
    }

    public QueryOptions readOnly(@Nullable Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @ApiStatus.Experimental
    public QueryOptions raw(@Nullable Map<String, ?> raw) {
        this.raw = raw == null ? null : Collections.unmodifiableMap(new HashMap(raw));
        return this;
    }

    Unmodifiable build() {
        return new Unmodifiable(this);
    }

    static class Unmodifiable {
        @Nullable
        private final Duration timeout;
        @Nullable
        private final String clientContextId;
        @Nullable
        private final Map<String, ?> namedParameters;
        @Nullable
        private final List<?> positionalParameters;
        @Nullable
        private final QueryPriority priority;
        @Nullable
        private final ScanConsistency scanConsistency;
        @Nullable
        private final Duration scanWait;
        @Nullable
        private final Deserializer deserializer;
        @Nullable
        private final Boolean readOnly;
        @Nullable
        private final Map<String, ?> raw;

        Unmodifiable(QueryOptions builder) {
            this.timeout = builder.timeout;
            this.clientContextId = builder.clientContextId;
            this.namedParameters = builder.namedParameters;
            this.positionalParameters = builder.positionalParameters;
            this.priority = builder.priority;
            this.scanConsistency = builder.scanConsistency;
            this.scanWait = builder.scanWait;
            this.deserializer = builder.deserializer;
            this.readOnly = builder.readOnly;
            this.raw = builder.raw;
        }

        void injectParams(ObjectNode query) {
            boolean namedParametersPresent;
            boolean positionalPresent;
            query.put("client_context_id", this.clientContextId != null ? this.clientContextId : UUID.randomUUID().toString());
            if (this.scanConsistency != null) {
                query.put("scan_consistency", this.scanConsistency.toString());
            }
            if (this.scanWait != null && this.scanConsistency != null && this.scanConsistency != ScanConsistency.NOT_BOUNDED) {
                query.put("scan_wait", Golang.encodeDurationToMs((Duration)this.scanWait));
            }
            boolean bl = positionalPresent = this.positionalParameters != null && !this.positionalParameters.isEmpty();
            if (positionalPresent) {
                try {
                    JsonNode jsonArray = (JsonNode)JacksonTransformers.MAPPER.convertValue((Object)JsonArray.from(this.positionalParameters), JsonNode.class);
                    query.set("args", jsonArray);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Unsupported parameter type.", e);
                }
            }
            boolean bl2 = namedParametersPresent = this.namedParameters != null && !this.namedParameters.isEmpty();
            if (namedParametersPresent) {
                try {
                    JsonObject.from(this.namedParameters);
                    this.namedParameters.forEach((key, value) -> {
                        JsonNode jsonValue = Unmodifiable.toRepackagedJacksonNode(InternalJacksonSerDes.INSTANCE, value);
                        if (key.charAt(0) != '$') {
                            query.set("$" + key, jsonValue);
                        } else {
                            query.set(key, jsonValue);
                        }
                    });
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Unsupported parameter type.", e);
                }
            }
            if (this.readOnly != null) {
                query.put("readonly", this.readOnly);
            }
            if (this.raw != null) {
                JsonObject.from(this.raw);
                this.raw.forEach((key, value) -> {
                    JsonNode jsonValue = Unmodifiable.toRepackagedJacksonNode(InternalJacksonSerDes.INSTANCE, value);
                    query.set(key, jsonValue);
                });
            }
        }

        public String toString() {
            return "QueryOptions{timeout=" + this.timeout + ", clientContextId='" + this.clientContextId + "', namedParameters=" + this.namedParameters + ", positionalParameters=" + this.positionalParameters + ", priority=" + this.priority + ", scanConsistency=" + this.scanConsistency + ", scanWait=" + this.scanWait + ", deserializer=" + this.deserializer + ", readOnly=" + this.readOnly + ", raw=" + this.raw + "}";
        }

        private static JsonNode toRepackagedJacksonNode(JsonSerializer serializer, Object value) {
            byte[] jsonArrayBytes = serializer.serialize(value);
            return Mapper.decodeIntoTree((byte[])jsonArrayBytes);
        }

        @Nullable
        public QueryPriority priority() {
            return this.priority;
        }

        public boolean readOnly() {
            return this.readOnly != null && this.readOnly != false;
        }

        public Map<String, Object> clientContext() {
            return Collections.emptyMap();
        }

        @Nullable
        public Duration timeout() {
            return this.timeout;
        }

        @Nullable
        public String clientContextId() {
            return this.clientContextId;
        }

        @Nullable
        public Map<String, ?> namedParameters() {
            return this.namedParameters;
        }

        @Nullable
        public List<?> positionalParameters() {
            return this.positionalParameters;
        }

        @Nullable
        public ScanConsistency scanConsistency() {
            return this.scanConsistency;
        }

        @Nullable
        public Duration scanWait() {
            return this.scanWait;
        }

        @Nullable
        public Deserializer deserializer() {
            return this.deserializer;
        }
    }
}

