/**
 * Copyright (C) 2009-2013 Couchbase, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALING
 * IN THE SOFTWARE.
 */

package com.couchbase.client.protocol.views;

/**
 * Holds a row in a view result that contains the fields
 * key and value.
 */
public class ViewRowReduced implements ViewRow {
  private final String key;
  private final String value;

  public ViewRowReduced(String key, String value) {
    this.key = parseField(key);
    this.value = parseField(value);
  }

  private String parseField(String field) {
    if (field != null && field.equals("null")) {
      return null;
    } else {
      return field;
    }
  }

  @Override
  public String getId() {
    throw new UnsupportedOperationException("Reduced views don't contain "
        + "document ids");
  }

  @Override
  public String getKey() {
    return key;
  }

  public String getValue() {
    return value;
  }

  @Override
  public String getDocument() {
    throw new UnsupportedOperationException("Reduced views don't contain "
      + "documents");
  }


  @Override
  public String getBbox() {
    throw new UnsupportedOperationException("Map/Reduce views don't contain "
      + "Bounding Box information");
  }

  @Override
  public String getGeometry() {
    throw new UnsupportedOperationException("Map/Reduce views don't contain "
      + "Geometry information");
  }
}
