/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.protocol.views;

import com.couchbase.client.protocol.views.DesignDocFetcherOperation;
import com.couchbase.client.protocol.views.DesignDocument;
import com.couchbase.client.protocol.views.HttpOperationImpl;
import com.couchbase.client.protocol.views.SpatialViewDesign;
import com.couchbase.client.protocol.views.ViewDesign;
import java.text.ParseException;
import java.util.Iterator;
import net.spy.memcached.ops.OperationErrorType;
import net.spy.memcached.ops.OperationException;
import net.spy.memcached.ops.OperationStatus;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class DesignDocFetcherOperationImpl
extends HttpOperationImpl
implements DesignDocFetcherOperation {
    private final String designDocName;

    public DesignDocFetcherOperationImpl(HttpRequest r, String designDocName, DesignDocFetcherOperation.DesignDocFetcherCallback designCallback) {
        super(r, designCallback);
        this.designDocName = designDocName;
    }

    @Override
    public void handleResponse(HttpResponse response) {
        String json = this.getEntityString(response);
        try {
            int errorcode = response.getStatusLine().getStatusCode();
            if (errorcode == 200) {
                DesignDocument design = this.parseDesignDocument(this.designDocName, json);
                ((DesignDocFetcherOperation.DesignDocFetcherCallback)this.callback).gotData(design);
                this.callback.receivedStatus(new OperationStatus(true, "OK"));
            } else {
                this.callback.receivedStatus(new OperationStatus(false, Integer.toString(errorcode)));
            }
        }
        catch (ParseException e) {
            this.exception = new OperationException(OperationErrorType.GENERAL, "Error parsing JSON");
        }
        this.callback.complete();
    }

    private DesignDocument parseDesignDocument(String ddn, String json) throws ParseException {
        DesignDocument design = new DesignDocument(ddn);
        try {
            Iterator iterator;
            JSONObject views;
            JSONObject base = new JSONObject(json);
            if (base.has("error")) {
                return null;
            }
            if (base.has("views")) {
                views = base.getJSONObject("views");
                iterator = views.keys();
                while (iterator.hasNext()) {
                    ViewDesign view;
                    String name = (String)iterator.next();
                    String map = (String)views.getJSONObject(name).get("map");
                    if (views.getJSONObject(name).has("reduce")) {
                        String reduce = (String)views.getJSONObject(name).get("reduce");
                        view = new ViewDesign(name, map, reduce);
                    } else {
                        view = new ViewDesign(name, map);
                    }
                    design.setView(view);
                }
            }
            if (base.has("spatial")) {
                views = base.getJSONObject("spatial");
                iterator = views.keys();
                while (iterator.hasNext()) {
                    String name = (String)iterator.next();
                    String map = (String)views.get(name);
                    SpatialViewDesign view = new SpatialViewDesign(name, map);
                    design.setSpatialView(view);
                }
            }
        }
        catch (JSONException e) {
            throw new ParseException("Cannot read json: " + json, 0);
        }
        return design;
    }
}

