/*
 * Decompiled with CFR 0.152.
 */
package com.cosium.spring.data.jpa.entity.graph.repository.support;

import com.cosium.spring.data.jpa.entity.graph.domain2.EntityGraphQueryHint;
import com.cosium.spring.data.jpa.entity.graph.repository.support.EntityGraphQueryHintCandidate;
import com.cosium.spring.data.jpa.entity.graph.repository.support.EntityGraphQueryHintCandidates;
import com.cosium.spring.data.jpa.entity.graph.repository.support.QueryHintsUtils;
import com.cosium.spring.data.jpa.entity.graph.repository.support.RepositoryQueryEntityGraphInjector;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Selection;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;

class RepositoryEntityManagerEntityGraphInjector
implements MethodInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(RepositoryEntityManagerEntityGraphInjector.class);
    private static final List<String> FIND_METHODS = Collections.singletonList("find");
    private static final List<String> CREATE_QUERY_METHODS = Arrays.asList("createQuery", "createNamedQuery");

    private RepositoryEntityManagerEntityGraphInjector() {
    }

    static EntityManager proxy(EntityManager entityManager) {
        ProxyFactory proxyFactory = new ProxyFactory((Object)entityManager);
        proxyFactory.addAdvice((Advice)new RepositoryEntityManagerEntityGraphInjector());
        return (EntityManager)proxyFactory.getProxy();
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        boolean hasEntityGraphCandidate;
        EntityGraphQueryHintCandidate entityGraphCandidate = EntityGraphQueryHintCandidates.current();
        String methodName = invocation.getMethod().getName();
        boolean bl = hasEntityGraphCandidate = entityGraphCandidate != null;
        if (hasEntityGraphCandidate && FIND_METHODS.contains(methodName)) {
            this.addEntityGraphToFindMethodQueryHints(entityGraphCandidate, invocation);
        }
        Object result = invocation.proceed();
        if (hasEntityGraphCandidate && CREATE_QUERY_METHODS.contains(methodName) && this.isQueryCreationEligible(entityGraphCandidate, invocation)) {
            result = RepositoryQueryEntityGraphInjector.proxy((Query)result, entityGraphCandidate);
        }
        return result;
    }

    private boolean isQueryCreationEligible(EntityGraphQueryHintCandidate entityGraphCandidate, MethodInvocation invocation) {
        Object resultType = null;
        for (Object argument : invocation.getArguments()) {
            CriteriaQuery criteriaQuery;
            Selection selection;
            if (argument instanceof Class) {
                resultType = (Class)argument;
                break;
            }
            if (!(argument instanceof CriteriaQuery) || (selection = (criteriaQuery = (CriteriaQuery)argument).getSelection()) == null) continue;
            resultType = selection.getJavaType();
            break;
        }
        return resultType == null || resultType.equals(entityGraphCandidate.domainClass());
    }

    private void addEntityGraphToFindMethodQueryHints(EntityGraphQueryHintCandidate entityGraphCandidate, MethodInvocation invocation) {
        LOG.trace("Trying to push the EntityGraph candidate to the query hints find method");
        HashMap<String, Object> queryProperties = null;
        int index = 0;
        for (Object argument : invocation.getArguments()) {
            if (argument instanceof Map) {
                queryProperties = (HashMap<String, Object>)argument;
                break;
            }
            ++index;
        }
        if (queryProperties == null) {
            LOG.trace("No query hints passed to the find method.");
            return;
        }
        if (!entityGraphCandidate.primary() && QueryHintsUtils.containsEntityGraph(queryProperties)) {
            LOG.trace("The query hints passed with the find method already holds an entity graph. Overriding aborted because the candidate EntityGraph is not primary.");
            return;
        }
        queryProperties = new HashMap<String, Object>(queryProperties);
        QueryHintsUtils.removeEntityGraphs(queryProperties);
        EntityGraphQueryHint entityGraphQueryHint = entityGraphCandidate.queryHint();
        queryProperties.put(entityGraphQueryHint.type().key(), entityGraphQueryHint.entityGraph());
        invocation.getArguments()[index] = queryProperties;
    }
}

