/*
 * Decompiled with CFR 0.152.
 */
package com.cosium.spring.data.jpa.entity.graph.repository.support;

import com.cosium.spring.data.jpa.entity.graph.domain2.EntityGraph;
import com.cosium.spring.data.jpa.entity.graph.domain2.EntityGraphQueryHint;
import com.cosium.spring.data.jpa.entity.graph.repository.exception.InapplicableEntityGraphException;
import com.cosium.spring.data.jpa.entity.graph.repository.support.DefaultEntityGraphs;
import com.cosium.spring.data.jpa.entity.graph.repository.support.EntityGraphQueryHintCandidate;
import com.cosium.spring.data.jpa.entity.graph.repository.support.MethodProvidedDefaultEntityGraphs;
import com.cosium.spring.data.jpa.entity.graph.repository.support.RepositoryMethodInvocation;
import jakarta.persistence.EntityManager;
import java.lang.reflect.Method;
import java.util.Optional;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.core.NamedThreadLocal;
import org.springframework.core.ResolvableType;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.support.RepositoryProxyPostProcessor;

class EntityGraphQueryHintCandidates
implements MethodInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(EntityGraphQueryHintCandidates.class);
    private static final ThreadLocal<EntityGraphQueryHintCandidates> CURRENT_CANDIDATES = new NamedThreadLocal("Thread local holding the current candidates");
    private final Class<?> domainClass;
    private final EntityManager entityManager;
    private final DefaultEntityGraphs defaultEntityGraphs;
    private final ThreadLocal<EntityGraphQueryHintCandidate> currentCandidate = new NamedThreadLocal("Thread local holding the current entity graph query hint candidate");

    public EntityGraphQueryHintCandidates(EntityManager entityManager, RepositoryInformation repositoryInformation) {
        this.domainClass = repositoryInformation.getDomainType();
        this.entityManager = entityManager;
        this.defaultEntityGraphs = new MethodProvidedDefaultEntityGraphs();
    }

    public static RepositoryProxyPostProcessor createPostProcessor(EntityManager entityManager) {
        return new PostProcessor(entityManager);
    }

    public static EntityGraphQueryHintCandidate current() {
        EntityGraphQueryHintCandidates currentRepository = CURRENT_CANDIDATES.get();
        if (currentRepository == null) {
            return null;
        }
        return currentRepository.currentCandidate.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        EntityGraphQueryHintCandidates oldRepo = CURRENT_CANDIDATES.get();
        CURRENT_CANDIDATES.set(this);
        try {
            Object object = this.doInvoke(invocation);
            return object;
        }
        finally {
            if (oldRepo == null) {
                CURRENT_CANDIDATES.remove();
            } else {
                CURRENT_CANDIDATES.set(oldRepo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object doInvoke(MethodInvocation invocation) throws Throwable {
        boolean newEntityGraphCandidatePreValidated;
        RepositoryMethodInvocation methodInvocation = new RepositoryMethodInvocation(invocation);
        EntityGraph providedEntityGraph = methodInvocation.findEntityGraphArgument();
        Object repository = methodInvocation.repository();
        ResolvableType returnType = ResolvableType.forMethodReturnType((Method)methodInvocation.method(), repository.getClass());
        EntityGraphQueryHintCandidate candidate = this.buildEntityGraphCandidate(providedEntityGraph, repository);
        if (candidate != null && !this.canApplyEntityGraph(returnType)) {
            if (!candidate.queryHint().failIfInapplicable()) {
                LOG.trace("Cannot apply EntityGraph {}", (Object)candidate);
                candidate = null;
            } else {
                throw new InapplicableEntityGraphException("Cannot apply EntityGraph " + String.valueOf(candidate) + " to the the current query");
            }
        }
        EntityGraphQueryHintCandidate genuineCandidate = this.currentCandidate.get();
        boolean bl = newEntityGraphCandidatePreValidated = candidate != null && (genuineCandidate == null || !genuineCandidate.primary());
        if (newEntityGraphCandidatePreValidated) {
            this.currentCandidate.set(candidate);
        }
        try {
            Object object = methodInvocation.proceed();
            return object;
        }
        finally {
            if (newEntityGraphCandidatePreValidated) {
                if (genuineCandidate == null) {
                    this.currentCandidate.remove();
                } else {
                    this.currentCandidate.set(genuineCandidate);
                }
            }
        }
    }

    private EntityGraphQueryHintCandidate buildEntityGraphCandidate(EntityGraph providedEntityGraph, Object repository) {
        EntityGraphQueryHint queryHint = Optional.ofNullable(providedEntityGraph).flatMap(entityGraph -> entityGraph.buildQueryHint(this.entityManager, this.domainClass)).orElse(null);
        boolean isPrimary = true;
        if (queryHint == null) {
            queryHint = this.defaultEntityGraphs.findOne(repository).flatMap(entityGraph -> entityGraph.buildQueryHint(this.entityManager, this.domainClass)).orElse(null);
            isPrimary = false;
        }
        if (queryHint == null) {
            return null;
        }
        return new EntityGraphQueryHintCandidate(queryHint, this.domainClass, isPrimary);
    }

    private boolean canApplyEntityGraph(ResolvableType repositoryMethodReturnType) {
        Class resolvedReturnType = repositoryMethodReturnType.resolve();
        if (resolvedReturnType != null && (Void.TYPE.equals(resolvedReturnType) || this.domainClass.isAssignableFrom(resolvedReturnType))) {
            return true;
        }
        for (Class genericType : repositoryMethodReturnType.resolveGenerics()) {
            if (!this.domainClass.isAssignableFrom(genericType)) continue;
            return true;
        }
        return false;
    }

    private record PostProcessor(EntityManager entityManager) implements RepositoryProxyPostProcessor
    {
        public void postProcess(ProxyFactory factory, RepositoryInformation repositoryInformation) {
            factory.addAdvice((Advice)new EntityGraphQueryHintCandidates(this.entityManager, repositoryInformation));
        }
    }
}

