/*
 * Decompiled with CFR 0.152.
 */
package com.cosium.spring.data.jpa.entity.graph.repository.query;

import com.cosium.spring.data.jpa.entity.graph.domain2.EntityGraph;
import org.springframework.core.MethodParameter;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.repository.query.ParametersSource;
import org.springframework.data.util.TypeInformation;

class EntityGraphAwareJpaParameters
extends JpaParameters {
    public EntityGraphAwareJpaParameters(ParametersSource parametersSource) {
        super(parametersSource, methodParameter -> new EntityGraphAwareJpaParameter((MethodParameter)methodParameter, (TypeInformation<?>)parametersSource.getDomainTypeInformation()));
    }

    private static class EntityGraphAwareJpaParameter
    extends JpaParameters.JpaParameter {
        private final boolean entityGraph;

        private EntityGraphAwareJpaParameter(MethodParameter parameter, TypeInformation<?> domainType) {
            super(parameter, domainType);
            this.entityGraph = EntityGraph.class.isAssignableFrom(parameter.getParameterType());
        }

        public boolean isBindable() {
            return !this.entityGraph && super.isBindable();
        }

        public boolean isSpecialParameter() {
            return this.entityGraph || super.isSpecialParameter();
        }
    }
}

