/*
 * Decompiled with CFR 0.152.
 */
package com.cosium.spring.data.jpa.entity.graph.domain;

import com.cosium.spring.data.jpa.entity.graph.domain.AbstractEntityGraph;
import com.cosium.spring.data.jpa.entity.graph.domain.EntityGraphType;
import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Objects;
import org.springframework.util.Assert;

public class NamedEntityGraph
extends AbstractEntityGraph {
    private final String name;

    public NamedEntityGraph(EntityGraphType type, boolean optional, String name) {
        super(type, optional);
        Assert.hasLength((String)name);
        this.name = name;
    }

    public NamedEntityGraph(EntityGraphType type, String name) {
        this(type, false, name);
    }

    public NamedEntityGraph(String name) {
        this(DEFAULT_ENTITY_GRAPH_TYPE, name);
    }

    @Override
    public String getEntityGraphName() {
        return this.name;
    }

    @Override
    public final List<String> getEntityGraphAttributePaths() {
        return null;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamedEntityGraph that = (NamedEntityGraph)o;
        return this.name.equals(that.name) && this.getEntityGraphType() == that.getEntityGraphType() && this.isOptional() == that.isOptional();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.getEntityGraphType(), this.isOptional()});
    }
}

