/*
 * Decompiled with CFR 0.152.
 */
package com.cosium.spring.data.jpa.graph.generator;

import com.cosium.spring.data.jpa.graph.generator.MetamodelAttributeTarget;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Entity;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.PluralAttribute;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class MetamodelAttribute {
    private final VariableElement variableElement;
    private final boolean pluralAttribute;

    private MetamodelAttribute(VariableElement variableElement, boolean pluralAttribute) {
        this.variableElement = variableElement;
        this.pluralAttribute = pluralAttribute;
    }

    public static Optional<MetamodelAttribute> parse(Elements elements, Types types, Element element) {
        if (!(element instanceof VariableElement)) {
            return Optional.empty();
        }
        VariableElement variableElement = (VariableElement)element;
        if (variableElement.getKind() != ElementKind.FIELD) {
            return Optional.empty();
        }
        TypeElement attributeTypeElement = elements.getTypeElement(Attribute.class.getCanonicalName());
        if (!types.isSubtype(types.erasure(variableElement.asType()), types.erasure(attributeTypeElement.asType()))) {
            return Optional.empty();
        }
        TypeElement pluralAttributeTypeElement = elements.getTypeElement(PluralAttribute.class.getCanonicalName());
        boolean pluralAttribute = types.isSubtype(types.erasure(variableElement.asType()), types.erasure(pluralAttributeTypeElement.asType()));
        return Optional.of(new MetamodelAttribute(variableElement, pluralAttribute));
    }

    public Optional<MetamodelAttributeTarget> jpaTarget() {
        TypeMirror rawAttributeType = this.variableElement.asType();
        if (!(rawAttributeType instanceof DeclaredType)) {
            return Optional.empty();
        }
        DeclaredType attributeType = (DeclaredType)rawAttributeType;
        List<? extends TypeMirror> typeArguments = attributeType.getTypeArguments();
        TypeMirror rawTargetType = typeArguments.get(typeArguments.size() - 1);
        if (!(rawTargetType instanceof DeclaredType)) {
            return Optional.empty();
        }
        DeclaredType targetType = (DeclaredType)rawTargetType;
        Element rawTargetTypeElement = targetType.asElement();
        if (!(rawTargetTypeElement instanceof TypeElement)) {
            return Optional.empty();
        }
        TypeElement targetTypeElement = (TypeElement)rawTargetTypeElement;
        if (!this.canCarryEntityGraphAttribute(targetTypeElement) && !this.pluralAttribute) {
            return Optional.empty();
        }
        return Optional.of(new MetamodelAttributeTarget(this.variableElement.getSimpleName().toString(), targetTypeElement));
    }

    private boolean canCarryEntityGraphAttribute(TypeElement targetTypeElement) {
        return targetTypeElement.getAnnotation(Entity.class) != null || targetTypeElement.getAnnotation(Embeddable.class) != null;
    }
}

