/*
 * Decompiled with CFR 0.152.
 */
package com.cosium.code.format.git;

import com.cosium.code.format.git.AutoCRLFObjectStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.util.io.EolStreamTypeUtil;

public class AutoCRLFObjectLoader
extends ObjectLoader {
    private final ObjectLoader delegate;
    private final CoreConfig.EolStreamType eolStreamType;

    public AutoCRLFObjectLoader(ObjectLoader delegate, CoreConfig.EolStreamType eolStreamType) {
        this.delegate = Objects.requireNonNull(delegate);
        this.eolStreamType = Objects.requireNonNull(eolStreamType);
    }

    public int getType() {
        return this.delegate.getType();
    }

    public long getSize() {
        return this.delegate.getSize();
    }

    public boolean isLarge() {
        return this.delegate.isLarge();
    }

    public byte[] getCachedBytes() throws LargeObjectException {
        return this.convertBytes(this.delegate.getCachedBytes());
    }

    public byte[] getCachedBytes(int sizeLimit) throws LargeObjectException, MissingObjectException, IOException {
        return this.convertBytes(this.delegate.getCachedBytes(sizeLimit));
    }

    private byte[] convertBytes(byte[] bytes) {
        try {
            return IOUtils.toByteArray((InputStream)EolStreamTypeUtil.wrapInputStream((InputStream)new ByteArrayInputStream(bytes), (CoreConfig.EolStreamType)this.eolStreamType));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ObjectStream openStream() throws MissingObjectException, IOException {
        return new AutoCRLFObjectStream(this.delegate.openStream(), this.eolStreamType);
    }

    public void copyTo(OutputStream out) throws MissingObjectException, IOException {
        this.delegate.copyTo(EolStreamTypeUtil.wrapOutputStream((OutputStream)out, (CoreConfig.EolStreamType)this.eolStreamType));
    }
}

