/*
 * Decompiled with CFR 0.152.
 */
package com.cosium.code.format;

import com.cosium.code.format.AbstractMavenGitCodeFormatMojo;
import com.cosium.code.format.executable.Executable;
import com.cosium.code.format.executable.ExecutableManager;
import com.cosium.code.format.utils.MavenUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="install-hooks", defaultPhase=LifecyclePhase.INITIALIZE, threadSafe=true)
public class InstallHooksMojo
extends AbstractMavenGitCodeFormatMojo {
    private static final String BASE_PLUGIN_PRE_COMMIT_HOOK = "maven-git-code-format.pre-commit.sh";
    private static final String PRE_COMMIT_HOOK_BASE_SCRIPT = "pre-commit";
    private static final String BASE_PLUGIN_POST_COMMIT_HOOK = "maven-git-code-format.post-commit.sh";
    private static final String POST_COMMIT_HOOK_BASE_SCRIPT = "post-commit";
    private final ExecutableManager executableManager = new ExecutableManager(() -> ((InstallHooksMojo)this).getLog());
    private final MavenUtils mavenUtils = new MavenUtils();
    @Parameter(property="truncateHooksBaseScripts", defaultValue="false")
    private boolean truncateHooksBaseScripts;
    @Parameter(property="propertiesToPropagate")
    private String[] propertiesToPropagate;

    public void execute() throws MojoExecutionException {
        if (!this.isExecutionRoot()) {
            this.getLog().debug((CharSequence)"Not in execution root. Do not execute.");
            return;
        }
        try {
            this.getLog().info((CharSequence)"Installing git hooks");
            this.doExecute();
            this.getLog().info((CharSequence)"Installed git hooks");
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void doExecute() throws IOException {
        Path hooksDirectory = this.prepareHooksDirectory();
        this.writePluginHooks(hooksDirectory);
        this.configureHookBaseScripts(hooksDirectory);
    }

    private void writePluginHooks(Path hooksDirectory) throws IOException {
        this.getLog().debug((CharSequence)"Writing plugin pre commit hook file");
        this.executableManager.getOrCreateExecutableScript(hooksDirectory.resolve(this.pluginPreCommitHookFileName())).truncateWithTemplate(() -> ((Object)((Object)this)).getClass().getResourceAsStream(BASE_PLUGIN_PRE_COMMIT_HOOK), this.mavenUtils.getMavenExecutable().toAbsolutePath(), this.mavenCliArguments());
        this.getLog().debug((CharSequence)"Written plugin pre commit hook file");
        this.getLog().debug((CharSequence)"Writing plugin post commit hook file");
        this.executableManager.getOrCreateExecutableScript(hooksDirectory.resolve(this.pluginPostCommitHookFileName())).truncateWithTemplate(() -> ((Object)((Object)this)).getClass().getResourceAsStream(BASE_PLUGIN_POST_COMMIT_HOOK), new Object[0]);
        this.getLog().debug((CharSequence)"Written plugin post commit hook file");
    }

    private void configureHookBaseScripts(Path hooksDirectory) throws IOException {
        Executable basePreCommitHook = this.executableManager.getOrCreateExecutableScript(hooksDirectory.resolve(PRE_COMMIT_HOOK_BASE_SCRIPT));
        this.getLog().debug((CharSequence)("Configuring '" + basePreCommitHook + "'"));
        if (this.truncateHooksBaseScripts) {
            basePreCommitHook.truncate();
        }
        basePreCommitHook.appendCommandCall(this.preCommitHookBaseScriptCall());
        Executable basePostCommitHook = this.executableManager.getOrCreateExecutableScript(hooksDirectory.resolve(POST_COMMIT_HOOK_BASE_SCRIPT));
        this.getLog().debug((CharSequence)("Configuring '" + basePostCommitHook + "'"));
        if (this.truncateHooksBaseScripts) {
            basePostCommitHook.truncate();
        }
        basePostCommitHook.appendCommandCall(this.postCommitHookBaseScriptCall());
    }

    private String mavenCliArguments() {
        return Optional.ofNullable(this.propertiesToPropagate).map(Arrays::asList).orElse(Collections.emptyList()).stream().filter(prop -> System.getProperty(prop) != null).map(prop -> "-D" + prop + "=" + System.getProperty(prop)).collect(Collectors.joining(" "));
    }

    private Path prepareHooksDirectory() {
        this.getLog().debug((CharSequence)"Preparing git hook directory");
        Path hooksDirectory = this.getOrCreateHooksDirectory();
        this.getLog().debug((CharSequence)"Prepared git hook directory");
        return hooksDirectory;
    }

    private String preCommitHookBaseScriptCall() {
        return "./" + this.gitBaseDir().relativize(this.getOrCreateHooksDirectory()) + "/" + this.pluginPreCommitHookFileName();
    }

    private String postCommitHookBaseScriptCall() {
        return "./" + this.gitBaseDir().relativize(this.getOrCreateHooksDirectory()) + "/" + this.pluginPostCommitHookFileName();
    }

    private String pluginPreCommitHookFileName() {
        return this.artifactId() + "." + BASE_PLUGIN_PRE_COMMIT_HOOK;
    }

    private String pluginPostCommitHookFileName() {
        return this.artifactId() + "." + BASE_PLUGIN_POST_COMMIT_HOOK;
    }
}

