/*
 * Decompiled with CFR 0.152.
 */
package com.cosium.code.format;

import com.cosium.code.format.formatter.CodeFormatter;
import com.cosium.code.format.formatter.CompositeCodeFormatter;
import com.cosium.code.format.formatter.JavaFormatter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

public abstract class AbstractMavenGitCodeFormatMojo
extends AbstractMojo {
    private static final String HOOKS_DIR = "hooks";
    private final CodeFormatter codeFormatter = new CompositeCodeFormatter(new JavaFormatter(() -> ((AbstractMavenGitCodeFormatMojo)this).getLog()));
    @Parameter(readonly=true, defaultValue="${project}")
    private MavenProject currentProject;

    protected final Repository gitRepository() {
        Repository gitRepository;
        try {
            gitRepository = ((FileRepositoryBuilder)new FileRepositoryBuilder().findGitDir(this.currentProject.getBasedir())).build();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not find the git repository. Run 'git init' if you did not.", e);
        }
        return gitRepository;
    }

    protected final Path baseDir() {
        return this.currentProject.getBasedir().toPath();
    }

    protected final List<Path> sourceDirs() {
        return Stream.of(this.currentProject.getCompileSourceRoots(), this.currentProject.getTestCompileSourceRoots()).flatMap(Collection::stream).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
    }

    protected final Path targetDir() {
        return Paths.get(this.currentProject.getBuild().getDirectory(), new String[0]);
    }

    protected final String artifactId() {
        return this.currentProject.getArtifactId();
    }

    protected final CodeFormatter codeFormatter() {
        return this.codeFormatter;
    }

    protected final boolean isExecutionRoot() {
        return this.currentProject.isExecutionRoot();
    }

    protected final Path getOrCreateHooksDirectory() {
        Path hooksDirectory = this.gitRepository().getDirectory().toPath().resolve(HOOKS_DIR);
        if (!Files.exists(hooksDirectory, new LinkOption[0])) {
            this.getLog().debug((CharSequence)("Creating directory " + hooksDirectory));
            try {
                Files.createDirectories(hooksDirectory, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.getLog().debug((CharSequence)(hooksDirectory + " already exists"));
        }
        return hooksDirectory;
    }

    protected final Path gitBaseDir() {
        return this.gitRepository().getDirectory().getParentFile().toPath();
    }
}

