/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.handler;

import com.corundumstudio.socketio.HandshakeData;
import com.corundumstudio.socketio.handler.ClientHead;
import io.netty.channel.Channel;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class ClientsBox {
    private final Map<UUID, ClientHead> uuid2clients = new ConcurrentHashMap<UUID, ClientHead>();
    private final Map<Channel, ClientHead> channel2clients = new ConcurrentHashMap<Channel, ClientHead>();

    public HandshakeData getHandshakeData(UUID sessionId) {
        ClientHead client = this.uuid2clients.get(sessionId);
        if (client == null) {
            return null;
        }
        return client.getHandshakeData();
    }

    public void addClient(ClientHead clientHead) {
        this.uuid2clients.put(clientHead.getSessionId(), clientHead);
    }

    public void removeClient(UUID sessionId) {
        this.uuid2clients.remove(sessionId);
    }

    public ClientHead get(UUID sessionId) {
        return this.uuid2clients.get(sessionId);
    }

    public void add(Channel channel, ClientHead clientHead) {
        this.channel2clients.put(channel, clientHead);
    }

    public void remove(Channel channel) {
        this.channel2clients.remove(channel);
    }

    public ClientHead get(Channel channel) {
        return this.channel2clients.get(channel);
    }
}

