/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.handler;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.stream.ChunkedStream;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.activation.MimetypesFileTypeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class ResourceHandler
extends ChannelInboundHandlerAdapter {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String HTTP_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final String HTTP_DATE_GMT_TIMEZONE = "GMT";
    public static final int HTTP_CACHE_SECONDS = 60;
    private final Map<String, URL> resources = new HashMap<String, URL>();

    public ResourceHandler(String context) {
        this.addResource(context + "/static/flashsocket/WebSocketMain.swf", "/static/flashsocket/WebSocketMain.swf");
        this.addResource(context + "/static/flashsocket/WebSocketMainInsecure.swf", "/static/flashsocket/WebSocketMainInsecure.swf");
    }

    public void addResource(String pathPart, String resourcePath) {
        URL resUrl = ((Object)((Object)this)).getClass().getResource(resourcePath);
        if (resUrl == null) {
            this.log.error("The specified resource was not found: " + resourcePath);
            return;
        }
        this.resources.put(pathPart, resUrl);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        FullHttpRequest req;
        QueryStringDecoder queryDecoder;
        URL resUrl;
        if (msg instanceof FullHttpRequest && (resUrl = this.resources.get((queryDecoder = new QueryStringDecoder((req = (FullHttpRequest)msg).getUri())).path())) != null) {
            URLConnection fileUrl = resUrl.openConnection();
            long lastModified = fileUrl.getLastModified();
            if (this.isNotModified((HttpRequest)req, lastModified)) {
                this.sendNotModified(ctx);
                req.release();
                return;
            }
            InputStream is = fileUrl.getInputStream();
            if (is == null) {
                this.sendError(ctx, HttpResponseStatus.NOT_FOUND);
                return;
            }
            DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            HttpHeaders.setContentLength((HttpMessage)res, (long)fileUrl.getContentLength());
            this.setContentTypeHeader((HttpResponse)res, fileUrl);
            this.setDateAndCacheHeaders((HttpResponse)res, lastModified);
            ctx.write((Object)res);
            ctx.pipeline().addBefore("resourceHandler", "chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
            ChannelFuture writeFuture = ctx.channel().write((Object)new ChunkedStream(is, fileUrl.getContentLength()));
            writeFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return;
        }
        ctx.fireChannelRead(msg);
    }

    private boolean isNotModified(HttpRequest request, long lastModified) throws ParseException {
        String ifModifiedSince = request.headers().get("If-Modified-Since");
        if (ifModifiedSince != null && !ifModifiedSince.equals("")) {
            long fileLastModifiedSeconds;
            SimpleDateFormat dateFormatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US);
            Date ifModifiedSinceDate = dateFormatter.parse(ifModifiedSince);
            long ifModifiedSinceDateSeconds = ifModifiedSinceDate.getTime() / 1000L;
            return ifModifiedSinceDateSeconds == (fileLastModifiedSeconds = lastModified / 1000L);
        }
        return false;
    }

    private void sendNotModified(ChannelHandlerContext ctx) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_MODIFIED);
        this.setDateHeader((HttpResponse)response);
        ctx.channel().write((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private void setDateHeader(HttpResponse response) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US);
        dateFormatter.setTimeZone(TimeZone.getTimeZone(HTTP_DATE_GMT_TIMEZONE));
        GregorianCalendar time = new GregorianCalendar();
        HttpHeaders.setHeader((HttpMessage)response, (String)"Date", (Object)dateFormatter.format(time.getTime()));
    }

    private void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
        HttpHeaders.setHeader((HttpMessage)response, (String)"Content-Type", (Object)"text/plain; charset=UTF-8");
        ByteBuf content = Unpooled.copiedBuffer((CharSequence)("Failure: " + status.toString() + "\r\n"), (Charset)CharsetUtil.UTF_8);
        ctx.channel().write((Object)response);
        ctx.channel().write((Object)content).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private void setDateAndCacheHeaders(HttpResponse response, long lastModified) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US);
        dateFormatter.setTimeZone(TimeZone.getTimeZone(HTTP_DATE_GMT_TIMEZONE));
        GregorianCalendar time = new GregorianCalendar();
        HttpHeaders.setHeader((HttpMessage)response, (String)"Date", (Object)dateFormatter.format(time.getTime()));
        ((Calendar)time).add(13, 60);
        HttpHeaders.setHeader((HttpMessage)response, (String)"Expires", (Object)dateFormatter.format(time.getTime()));
        HttpHeaders.setHeader((HttpMessage)response, (String)"Cache-Control", (Object)"private, max-age=60");
        HttpHeaders.setHeader((HttpMessage)response, (String)"Last-Modified", (Object)dateFormatter.format(new Date(lastModified)));
    }

    private void setContentTypeHeader(HttpResponse response, URLConnection resUrlConnection) {
        MimetypesFileTypeMap mimeTypesMap = new MimetypesFileTypeMap();
        String resName = resUrlConnection.getURL().getFile();
        HttpHeaders.setHeader((HttpMessage)response, (String)"Content-Type", (Object)mimeTypesMap.getContentType(resName));
    }
}

