/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.transport;

import com.corundumstudio.socketio.DisconnectableHub;
import com.corundumstudio.socketio.SocketIOClient;
import com.corundumstudio.socketio.Transport;
import com.corundumstudio.socketio.ack.AckManager;
import com.corundumstudio.socketio.namespace.Namespace;
import com.corundumstudio.socketio.parser.Packet;
import com.corundumstudio.socketio.parser.PacketType;
import com.corundumstudio.socketio.store.Store;
import com.corundumstudio.socketio.store.StoreFactory;
import com.corundumstudio.socketio.transport.NamespaceClient;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class MainBaseClient {
    private final ConcurrentMap<Namespace, SocketIOClient> namespaceClients = new ConcurrentHashMap<Namespace, SocketIOClient>();
    private final Store store;
    private final DisconnectableHub disconnectable;
    private final AckManager ackManager;
    private final UUID sessionId;
    private final Transport transport;
    private Channel channel;

    public MainBaseClient(UUID sessionId, AckManager ackManager, DisconnectableHub disconnectable, Transport transport, StoreFactory storeFactory) {
        this.sessionId = sessionId;
        this.ackManager = ackManager;
        this.disconnectable = disconnectable;
        this.transport = transport;
        this.store = storeFactory.create(sessionId);
    }

    public Transport getTransport() {
        return this.transport;
    }

    public abstract ChannelFuture send(Packet var1);

    public void removeChildClient(SocketIOClient client) {
        this.namespaceClients.remove((Namespace)client.getNamespace());
        if (this.namespaceClients.isEmpty()) {
            this.disconnectable.onDisconnect(this);
        }
    }

    public SocketIOClient getChildClient(Namespace namespace) {
        SocketIOClient oldClient;
        SocketIOClient client = (SocketIOClient)this.namespaceClients.get(namespace);
        if (client == null && (oldClient = this.namespaceClients.putIfAbsent(namespace, client = new NamespaceClient(this, namespace))) != null) {
            client = oldClient;
        }
        return client;
    }

    public Collection<SocketIOClient> getAllChildClients() {
        return this.namespaceClients.values();
    }

    public void onChannelDisconnect() {
        for (SocketIOClient client : this.getAllChildClients()) {
            ((NamespaceClient)client).onDisconnect();
        }
    }

    public AckManager getAckManager() {
        return this.ackManager;
    }

    public UUID getSessionId() {
        return this.sessionId;
    }

    public SocketAddress getRemoteAddress() {
        return this.channel.remoteAddress();
    }

    public void disconnect() {
        ChannelFuture future = this.send(new Packet(PacketType.DISCONNECT));
        future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        this.onChannelDisconnect();
    }

    Channel getChannel() {
        return this.channel;
    }

    void setChannel(Channel channel) {
        this.channel = channel;
    }

    public Store getStore() {
        return this.store;
    }
}

