/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.scheduler;

import com.corundumstudio.socketio.scheduler.SchedulerKey;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CancelableScheduler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<SchedulerKey, Future<?>> scheduledFutures = new ConcurrentHashMap();
    private final ScheduledExecutorService executorService;

    public CancelableScheduler(int threadPoolSize) {
        this.executorService = Executors.newScheduledThreadPool(threadPoolSize);
    }

    public void cancel(SchedulerKey key) {
        Future<?> future = this.scheduledFutures.remove(key);
        if (future != null) {
            future.cancel(false);
        }
    }

    public void schedule(Runnable runnable, long delay, TimeUnit unit) {
        this.executorService.schedule(runnable, delay, unit);
    }

    public void schedule(final SchedulerKey key, final Runnable runnable, long delay, TimeUnit unit) {
        ScheduledFuture<?> future = this.executorService.schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    runnable.run();
                }
                finally {
                    CancelableScheduler.this.scheduledFutures.remove(key);
                }
            }
        }, delay, unit);
        this.scheduledFutures.put(key, future);
    }

    public void shutdown() {
        this.executorService.shutdownNow();
        try {
            this.executorService.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }
}

